/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.navigator.AndroidTreeUpdater;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectTreeBuilder
extends ProjectTreeBuilder {
    private Map<VirtualFile, AbstractTreeNode> myFileToNodeMap = new HashMap<VirtualFile, AbstractTreeNode>();

    public AndroidProjectTreeBuilder(@NotNull Project project, @NotNull JTree tree, @NotNull DefaultTreeModel treeModel, @NotNull ProjectAbstractTreeStructureBase treeStructure, @Nullable Comparator<NodeDescriptor> comparator2) {
        super(project, tree, treeModel, comparator2, treeStructure);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    AndroidProjectTreeBuilder.this.removeMapping(vFileEvent.getFile());
                }
            }
        });
    }

    @Nullable
    protected AbstractTreeUpdater createUpdater() {
        if (this.isDisposed()) {
            return null;
        }
        AbstractTreeStructure treeStructure = this.getTreeStructure();
        assert (treeStructure != null);
        return new AndroidTreeUpdater(treeStructure, this);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    protected Object findNodeByElement(@NotNull Object element) {
        Object parentNode;
        Object node = super.findNodeByElement(element);
        if (node != null) {
            return node;
        }
        VirtualFile virtualFile = null;
        if (element instanceof PsiDirectory) {
            virtualFile = ((PsiDirectory)element).getVirtualFile();
        } else if (element instanceof PsiFile) {
            virtualFile = ((PsiFile)element).getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        AbstractTreeNode treeNode = this.getNodeForFile(virtualFile);
        if (treeNode == null) {
            return null;
        }
        AbstractTreeNode parent = treeNode.getParent();
        Object object = parentNode = parent == null ? null : this.findNodeByElement(parent);
        if (!(parentNode instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Enumeration<TreeNode> children = ((DefaultMutableTreeNode)parentNode).children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (!(child.getUserObject() instanceof FolderGroupNode)) continue;
            for (PsiDirectory folder : ((FolderGroupNode)child.getUserObject()).getFolders()) {
                if (!folder.getVirtualFile().equals(virtualFile)) continue;
                return child;
            }
        }
        return null;
    }

    public void createMapping(@NotNull VirtualFile file, @NotNull AbstractTreeNode node) {
        this.myFileToNodeMap.put(file, node);
    }

    private void removeMapping(@Nullable VirtualFile file) {
        this.myFileToNodeMap.remove(file);
    }

    @Nullable
    private AbstractTreeNode getNodeForFile(@NotNull VirtualFile file) {
        return this.myFileToNodeMap.get(file);
    }
}

