/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestFileNode
extends PsiFileNode
implements FolderGroupNode {
    @NotNull
    private final AndroidFacet myAndroidFacet;

    AndroidManifestFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet androidFacet) {
        super(project, psiFile, settings);
        this.myAndroidFacet = androidFacet;
    }

    public void update(@NotNull PresentationData data) {
        IdeaSourceProvider sourceProvider;
        super.update(data);
        PsiFile file = (PsiFile)this.getValue();
        if (file != null && (sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myAndroidFacet, file)) != null && !"main".equals(sourceProvider.getName())) {
            data.addText(file.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String name = sourceProvider.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                data.addText(" (" + name + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            data.setPresentableText(file.getName());
        }
    }

    @Nullable
    static IdeaSourceProvider getSourceProvider(@NotNull AndroidFacet facet, @NotNull PsiFile file) {
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(facet)) {
            if (!file.getVirtualFile().equals(provider.getManifestFile())) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public Comparable getSortKey() {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        IdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myAndroidFacet, file);
        if (sourceProvider == null || "main".equals(sourceProvider.getName())) {
            return "";
        }
        return sourceProvider.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile file = (PsiFile)this.getValue();
        if (file == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(file.getName());
        IdeaSourceProvider sourceProvider = AndroidManifestFileNode.getSourceProvider(this.myAndroidFacet, file);
        assert (sourceProvider != null);
        String name = sourceProvider.getName();
        if (StringUtil.isNotEmpty((String)name)) {
            buffer.append(" (");
            buffer.append(name);
            buffer.append(")");
        }
        return buffer.toString();
    }
}

