/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestFileNode;
import com.google.common.collect.Iterables;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidManifestsGroupNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    private static final String MANIFESTS_NODE = "manifests";
    @NotNull
    private final Set<VirtualFile> mySources;

    public AndroidManifestsGroupNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull Set<VirtualFile> sources) {
        super(project, (Object)androidFacet, settings);
        this.mySources = sources;
    }

    public boolean contains(@NotNull VirtualFile file) {
        return this.mySources.contains(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Project project = this.getNotNullProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AndroidManifestFileNode> children = new ArrayList<AndroidManifestFileNode>();
        for (VirtualFile manifest : this.mySources) {
            PsiFile psiFile;
            if (!manifest.isValid() || (psiFile = psiManager.findFile(manifest)) == null) continue;
            AndroidFacet facet = this.getAndroidFacet();
            children.add(new AndroidManifestFileNode(project, psiFile, this.getSettings(), facet));
        }
        return children;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.addText(MANIFESTS_NODE, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon2 = AndroidSourceType.MANIFEST.getIcon();
        if (icon2 != null) {
            presentation.setIcon(icon2);
        }
        presentation.setPresentableText(MANIFESTS_NODE);
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public boolean canNavigate() {
        return !this.mySources.isEmpty();
    }

    public void navigate(boolean requestFocus) {
        VirtualFile fileToOpen = this.findFileToOpen(this.mySources);
        if (fileToOpen == null) {
            return;
        }
        new OpenFileDescriptor(this.getNotNullProject(), fileToOpen).navigate(requestFocus);
    }

    @Nullable
    private VirtualFile findFileToOpen(@NotNull Set<VirtualFile> files2) {
        VirtualFile bestFile = (VirtualFile)Iterables.getFirst(files2, null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.getNotNullProject());
        for (VirtualFile file : files2) {
            AndroidFacet facet;
            IdeaSourceProvider sourceProvider;
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile == null || (sourceProvider = AndroidManifestFileNode.getSourceProvider(facet = this.getAndroidFacet(), psiFile)) == null || !"main".equals(sourceProvider.getName())) continue;
            bestFile = file;
        }
        return bestFile;
    }

    @NotNull
    private AndroidFacet getAndroidFacet() {
        AndroidFacet facet = (AndroidFacet)((Object)this.getValue());
        assert (facet != null) : "Android Facet for module cannot be null";
        return facet;
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        return this.myProject;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public Comparable getSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return AndroidSourceType.MANIFEST;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return MANIFESTS_NODE;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }
}

