/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.util.PathString;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidViewModuleNode;
import com.android.tools.idea.navigator.nodes.android.AndroidJniFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidResFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidSourceTypeNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkModuleNode;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.HashMultimap;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleNode
extends AndroidViewModuleNode {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidModuleNode(@NotNull Project project, @NotNull Module module, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, module, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    private Module getModule() {
        Module module = (Module)this.getValue();
        assert (module != null);
        return module;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        AndroidFacet facet = AndroidFacet.getInstance(this.getModule());
        if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            return super.getChildren();
        }
        return AndroidModuleNode.getChildren(facet, this.getSettings(), this.myProjectViewPane, AndroidProjectViewPane.getSourceProviders(facet));
    }

    @NotNull
    static Collection<AbstractTreeNode> getChildren(@NotNull AndroidFacet facet, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane, @NotNull List<IdeaSourceProvider> providers) {
        AndroidModuleSystem moduleSystem;
        PsiDirectory sampleDataPsi;
        Project project = facet.getModule().getProject();
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
        HashMultimap<AndroidSourceType, VirtualFile> sourcesByType = AndroidModuleNode.getSourcesBySourceType(providers, androidModuleModel);
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet.getModule());
        for (AndroidSourceType sourceType : sourcesByType.keySet()) {
            if (sourceType == AndroidSourceType.CPP && ndkModuleModel != null) continue;
            if (sourceType == AndroidSourceType.MANIFEST) {
                result2.add((AbstractTreeNode)new AndroidManifestsGroupNode(project, facet, settings, sourcesByType.get((Object)sourceType)));
                continue;
            }
            if (sourceType == AndroidSourceType.RES || sourceType == AndroidSourceType.GENERATED_RES) {
                result2.add((AbstractTreeNode)new AndroidResFolderNode(project, facet, sourceType, settings, (Set<VirtualFile>)sourcesByType.get((Object)sourceType), projectViewPane));
                continue;
            }
            if (sourceType == AndroidSourceType.SHADERS && (androidModuleModel == null || !androidModuleModel.getFeatures().isShadersSupported())) continue;
            result2.add((AbstractTreeNode)new AndroidSourceTypeNode(project, facet, settings, sourceType, sourcesByType.get((Object)sourceType), projectViewPane));
        }
        if (ndkModuleModel != null) {
            result2.add((AbstractTreeNode)new AndroidJniFolderNode(project, ndkModuleModel, settings));
        }
        if ((sampleDataPsi = AndroidModuleNode.getPsiDirectory(project, (moduleSystem = ProjectSystemUtil.getModuleSystem(facet.getModule())).getSampleDataDirectory())) != null) {
            result2.add((AbstractTreeNode)new PsiDirectoryNode(project, sampleDataPsi, settings));
        }
        return result2;
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(@NotNull Project project, @Nullable PathString path) {
        VirtualFile virtualFile = FileExtensions.toVirtualFile(path);
        return virtualFile != null ? PsiManager.getInstance((Project)project).findDirectory(virtualFile) : null;
    }

    @NotNull
    private static HashMultimap<AndroidSourceType, VirtualFile> getSourcesBySourceType(@NotNull List<IdeaSourceProvider> providers, @Nullable AndroidModuleModel androidModel) {
        HashMultimap sourcesByType = HashMultimap.create();
        HashSet<VirtualFile> allSources = new HashSet<VirtualFile>();
        for (AndroidSourceType sourceType : AndroidSourceType.values()) {
            Set<VirtualFile> sources;
            if (sourceType == AndroidSourceType.SHADERS && (androidModel == null || !androidModel.getFeatures().isShadersSupported()) || (sources = sourceType == AndroidSourceType.GENERATED_JAVA ? AndroidModuleNode.getGeneratedSources(androidModel) : (sourceType == AndroidSourceType.GENERATED_RES ? AndroidModuleNode.getGeneratedResFolders(androidModel) : AndroidModuleNode.getSources(sourceType, providers))).isEmpty()) continue;
            if (SetUtil.intersect(allSources, sources).isEmpty()) {
                sourcesByType.putAll((Object)sourceType, sources);
            } else if (!allSources.containsAll(sources)) {
                sources.removeAll(allSources);
                sourcesByType.putAll((Object)sourceType, sources);
            }
            allSources.addAll(sources);
        }
        return sourcesByType;
    }

    @NotNull
    private static Set<VirtualFile> getSources(@NotNull AndroidSourceType sourceType, @NotNull Iterable<IdeaSourceProvider> providers) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (IdeaSourceProvider provider : providers) {
            sources.addAll(sourceType.getSources(provider));
        }
        return sources;
    }

    @NotNull
    private static Set<VirtualFile> getGeneratedSources(@Nullable AndroidModuleModel androidModuleModel) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        if (androidModuleModel != null) {
            IdeJavaArtifact unitTestArtifact;
            ArrayList<File> files2 = new ArrayList<File>(GradleUtil.getGeneratedSourceFoldersToUse((IdeBaseArtifact)androidModuleModel.getMainArtifact(), androidModuleModel));
            IdeAndroidArtifact androidTestArtifact = androidModuleModel.getArtifactForAndroidTest();
            if (androidTestArtifact != null) {
                files2.addAll(GradleUtil.getGeneratedSourceFoldersToUse((IdeBaseArtifact)androidTestArtifact, androidModuleModel));
            }
            if ((unitTestArtifact = androidModuleModel.getSelectedVariant().getUnitTestArtifact()) != null) {
                files2.addAll(unitTestArtifact.getGeneratedSourceFolders());
            }
            for (File file : files2) {
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (vFile == null) continue;
                sources.add(vFile);
            }
        }
        return sources;
    }

    @NotNull
    private static Set<VirtualFile> getGeneratedResFolders(@Nullable AndroidModuleModel androidModuleModel) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        if (androidModuleModel != null) {
            ArrayList files2 = new ArrayList(androidModuleModel.getMainArtifact().getGeneratedResourceFolders());
            IdeAndroidArtifact androidTest = androidModuleModel.getArtifactForAndroidTest();
            if (androidTest != null) {
                files2.addAll(androidTest.getGeneratedResourceFolders());
            }
            for (File file : files2) {
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (vFile == null) continue;
                sources.add(vFile);
            }
        }
        return sources;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (super.contains(file)) {
            return true;
        }
        if (((Boolean)StudioFlags.ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT.get()).booleanValue()) {
            AndroidFacet facet = AndroidFacet.getInstance(this.getModule());
            if (facet == null || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
                return false;
            }
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet.getModule());
            if (ndkModuleModel != null) {
                return NdkModuleNode.containedInIncludeFolders(ndkModuleModel, file);
            }
            return false;
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return String.format("%1$s (Android)", this.getModule().getName());
    }

    public void update(@NotNull PresentationData presentation) {
        super.update(presentation);
        Module module = (Module)this.getValue();
        if (module != null) {
            presentation.setIcon(GradleUtil.getModuleIcon(module));
        }
    }
}

