/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.ndk;

import com.android.tools.idea.io.FilePaths;
import com.google.common.base.Splitter;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SourceFolderNode
extends PsiDirectoryNode {
    @NotNull
    private final File myFolderPath;
    @NotNull
    private final String myPathToShow;

    public SourceFolderNode(@NotNull Project project, @NotNull PsiDirectory value2, @NotNull ViewSettings viewSettings) {
        super(project, value2, viewSettings, null);
        this.myFolderPath = FilePaths.toSystemDependentPath((String)value2.getVirtualFile().getPath());
        String pathToShow = this.myFolderPath.getPath();
        List segments = Splitter.on((String)File.separator).omitEmptyStrings().splitToList((CharSequence)pathToShow);
        int segmentCount = segments.size();
        if (segmentCount > 4) {
            segments = segments.subList(segmentCount - 5, segmentCount - 1);
            pathToShow = "..." + File.separatorChar + FileUtil.join((String[])ArrayUtil.toStringArray(segments));
        }
        this.myPathToShow = pathToShow;
    }

    protected void updateImpl(@NotNull PresentationData data) {
        PsiDirectory folder = (PsiDirectory)this.getValue();
        assert (folder != null);
        data.addText(folder.getName() + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.addText("(" + this.myPathToShow + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        data.setTooltip(this.myFolderPath.getPath());
    }
}

