/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalBuildFileNode
extends PsiFileNode {
    @NotNull
    private final String myModuleName;

    ExternalBuildFileNode(@NotNull Project project, @NotNull PsiFile value2, @NotNull ViewSettings settings, @NotNull String moduleName) {
        super(project, value2, settings);
        this.myModuleName = moduleName;
    }

    public void update(@NotNull PresentationData data) {
        super.update(data);
        String fileName = this.getFileName();
        data.addText(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(fileName);
        data.addText(" (" + this.myModuleName + ", " + this.getFilePath() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myModuleName + "-" + this.getFileName() + "-" + this.getFilePath();
    }

    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.getFileName() + " (" + this.myModuleName + ", " + this.getFilePath() + ")";
    }

    @NotNull
    private String getFileName() {
        return this.getFile().getName();
    }

    @NotNull
    private String getFilePath() {
        return FileUtil.getLocationRelativeToUserHome((String)this.getFile().getVirtualFile().getPresentableUrl());
    }

    @NotNull
    private PsiFile getFile() {
        PsiFile value2 = (PsiFile)this.getValue();
        assert (value2 != null);
        return value2;
    }
}

