/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkSourceFolderNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludesViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.NativeIncludes;
import com.google.common.collect.Iterables;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkLibraryEnhancedHeadersNode
extends ProjectViewNode<Collection<NativeArtifact>>
implements FolderGroupNode {
    @NotNull
    private final VirtualFile myBuildFileFolder;
    @NotNull
    private final String myNativeLibraryName;
    @NotNull
    private final String myNativeLibraryType;
    @NotNull
    private final Collection<String> mySourceFileExtensions;
    @NotNull
    private final NativeIncludes myNativeIncludes;
    @Nullable
    private VirtualFile myLibraryFolder;

    public NdkLibraryEnhancedHeadersNode(@NotNull VirtualFile buildFileFolder, @NotNull Project project, @NotNull String nativeLibraryName, @NotNull String nativeLibraryType, @NotNull Collection<NativeArtifact> artifacts, @NotNull NativeIncludes nativeIncludes, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        super(project, artifacts, settings);
        assert (((Boolean)StudioFlags.ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT.get()).booleanValue());
        this.myBuildFileFolder = buildFileFolder;
        this.myNativeLibraryName = nativeLibraryName;
        this.myNativeLibraryType = nativeLibraryType;
        this.mySourceFileExtensions = sourceFileExtensions;
        this.myNativeIncludes = nativeIncludes;
    }

    @NotNull
    private static Collection<AbstractTreeNode> getSourceFolderNodes(@NotNull Project project, @NotNull Collection<NativeArtifact> artifacts, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        TreeMap<String, RootFolder> rootFolders = new TreeMap<String, RootFolder>();
        for (NativeArtifact artifact : artifacts) {
            NdkLibraryEnhancedHeadersNode.addSourceFolders(rootFolders, artifact);
            NdkLibraryEnhancedHeadersNode.addSourceFiles(rootFolders, artifact);
        }
        if (rootFolders.size() > 1) {
            NdkLibraryEnhancedHeadersNode.groupFolders(rootFolders);
        }
        if (rootFolders.size() > 1) {
            NdkLibraryEnhancedHeadersNode.mergeFolders(rootFolders);
        }
        HashSet<String> fileExtensions = new HashSet<String>(sourceFileExtensions.size());
        fileExtensions.addAll(sourceFileExtensions);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (RootFolder rootFolder : rootFolders.values()) {
            PsiDirectory directory = psiManager.findDirectory(rootFolder.rootFolder);
            if (directory == null) continue;
            children.add((AbstractTreeNode)new NdkSourceFolderNode(project, directory, settings, fileExtensions, rootFolder.sourceFolders, rootFolder.sourceFiles));
        }
        return children;
    }

    private static void addSourceFolders(@NotNull TreeMap<String, RootFolder> rootFolders, @NotNull NativeArtifact artifact) {
        for (VirtualFile sourceFolder : NdkLibraryEnhancedHeadersNode.getSourceFolders(artifact)) {
            String path = sourceFolder.getPath();
            if (rootFolders.containsKey(path)) continue;
            RootFolder rootFolder = new RootFolder(sourceFolder);
            rootFolder.sourceFolders.add(sourceFolder);
            rootFolders.put(path, rootFolder);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFolders(@NotNull NativeArtifact artifact) {
        ArrayList<File> sourceFolders = new ArrayList<File>(artifact.getExportedHeaders());
        return NdkLibraryEnhancedHeadersNode.convertToVirtualFiles(sourceFolders);
    }

    private static void addSourceFiles(@NotNull TreeMap<String, RootFolder> rootFolders, @NotNull NativeArtifact artifact) {
        for (VirtualFile sourceFile : NdkLibraryEnhancedHeadersNode.getSourceFiles(artifact)) {
            VirtualFile sourceFolder = sourceFile.getParent();
            String path = sourceFolder.getPath();
            RootFolder rootFolder = rootFolders.computeIfAbsent(path, k -> new RootFolder(sourceFolder));
            rootFolder.sourceFiles.add(sourceFile);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFiles(@NotNull NativeArtifact artifact) {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (NativeFile sourceFile : artifact.getSourceFiles()) {
            File source = sourceFile.getFilePath();
            sourceFiles.add(source);
        }
        return NdkLibraryEnhancedHeadersNode.convertToVirtualFiles(sourceFiles);
    }

    @NotNull
    private static List<VirtualFile> convertToVirtualFiles(@NotNull Collection<File> files2) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files2.size());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File file : files2) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
            if (virtualFile == null) continue;
            result2.add(virtualFile);
        }
        return result2;
    }

    private static void groupFolders(@NotNull TreeMap<String, RootFolder> rootFolders) {
        String keyToMerge = rootFolders.lastKey();
        while (keyToMerge != null) {
            RootFolder folderToMerge = rootFolders.get(keyToMerge);
            VirtualFile folderToMergeParent = folderToMerge.rootFolder.getParent();
            if (folderToMergeParent == null) {
                keyToMerge = rootFolders.lowerKey(keyToMerge);
                continue;
            }
            RootFolder targetFolder = rootFolders.get(folderToMergeParent.getPath());
            if (targetFolder != null) {
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                rootFolders.remove(keyToMerge);
                keyToMerge = rootFolders.lastKey();
                continue;
            }
            String previousKey = rootFolders.lowerKey(keyToMerge);
            if (previousKey == null) break;
            RootFolder previousFolder = rootFolders.get(previousKey);
            VirtualFile previousFolderParent = previousFolder.rootFolder.getParent();
            if (previousFolderParent != null && previousFolderParent.getPath().equals(folderToMergeParent.getPath())) {
                targetFolder = rootFolders.computeIfAbsent(folderToMergeParent.getPath(), k -> new RootFolder(folderToMergeParent));
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFolders.addAll(previousFolder.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                targetFolder.sourceFiles.addAll(previousFolder.sourceFiles);
                rootFolders.remove(keyToMerge);
                rootFolders.remove(previousKey);
                keyToMerge = rootFolders.lastKey();
                continue;
            }
            keyToMerge = previousKey;
        }
    }

    private static void mergeFolders(@NotNull TreeMap<String, RootFolder> rootFolders) {
        String keyToMerge = rootFolders.lastKey();
        while (keyToMerge != null) {
            VirtualFile folder;
            RootFolder folderToMerge = rootFolders.get(keyToMerge);
            for (folder = folderToMerge.rootFolder.getParent(); folder != null; folder = folder.getParent()) {
                RootFolder targetFolder = rootFolders.get(folder.getPath());
                if (targetFolder == null) {
                    continue;
                }
                targetFolder.sourceFolders.addAll(folderToMerge.sourceFolders);
                targetFolder.sourceFiles.addAll(folderToMerge.sourceFiles);
                rootFolders.remove(keyToMerge);
                keyToMerge = rootFolders.lastKey();
                break;
            }
            if (rootFolders.size() <= 1) break;
            if (folder != null) continue;
            keyToMerge = rootFolders.lowerKey(keyToMerge);
        }
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        IncludesViewNode includesNode = new IncludesViewNode(this.myBuildFileFolder, this.getNotNullProject(), this.myNativeIncludes, this.getSettings());
        ArrayList<IncludesViewNode> result2 = new ArrayList<IncludesViewNode>();
        result2.add(includesNode);
        Collection<AbstractTreeNode> sourceFolderNodes = NdkLibraryEnhancedHeadersNode.getSourceFolderNodes(this.getNotNullProject(), this.getArtifacts(), this.getSettings(), this.mySourceFileExtensions);
        if (sourceFolderNodes.size() == 1) {
            AbstractTreeNode node = (AbstractTreeNode)Iterables.getOnlyElement(sourceFolderNodes);
            assert (node instanceof NdkSourceFolderNode);
            NdkSourceFolderNode sourceFolderNode = (NdkSourceFolderNode)node;
            sourceFolderNode.setShowFolderPath(false);
            this.myLibraryFolder = sourceFolderNode.getVirtualFile();
            result2.addAll(sourceFolderNode.getChildren());
            return result2;
        }
        for (AbstractTreeNode sourceFolderNode : sourceFolderNodes) {
            if (!(sourceFolderNode instanceof NdkSourceFolderNode)) continue;
            ((NdkSourceFolderNode)sourceFolderNode).setShowFolderPath(true);
        }
        this.myLibraryFolder = null;
        result2.addAll(sourceFolderNodes);
        return result2;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.addText(this.myNativeLibraryName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (!this.myNativeLibraryType.isEmpty()) {
            presentation.addText(" (" + this.myNativeLibraryType + (this.myLibraryFolder != null ? ", " + FileUtil.getLocationRelativeToUserHome((String)this.myLibraryFolder.getPresentableUrl()) : "") + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.NativeLibrariesFolder);
    }

    public boolean contains(@NotNull VirtualFile file) {
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile folder : NdkLibraryEnhancedHeadersNode.getSourceFolders(artifact)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
        }
        return NdkLibraryEnhancedHeadersNode.containedInIncludeFolders(this.myNativeIncludes, file);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myNativeLibraryType + this.myNativeLibraryName;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myNativeLibraryName + (this.myNativeLibraryType.isEmpty() ? "" : " (" + this.myNativeLibraryType + ")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NdkLibraryEnhancedHeadersNode that = (NdkLibraryEnhancedHeadersNode)o;
        return Objects.equals(this.myBuildFileFolder, that.myBuildFileFolder) && Objects.equals(this.myNativeLibraryName, that.myNativeLibraryName);
    }

    public int hashCode() {
        return Objects.hash(this.myBuildFileFolder, this.myNativeLibraryName);
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.getNotNullProject());
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>();
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile f : NdkLibraryEnhancedHeadersNode.getSourceFolders(artifact)) {
                PsiDirectory dir = psiManager.findDirectory(f);
                if (dir == null) continue;
                folders.add(dir);
            }
        }
        return folders.toArray(PsiDirectory.EMPTY_ARRAY);
    }

    @NotNull
    private Project getNotNullProject() {
        assert (this.myProject != null);
        return this.myProject;
    }

    @NotNull
    private Collection<NativeArtifact> getArtifacts() {
        Collection artifacts = (Collection)this.getValue();
        assert (artifacts != null);
        return artifacts;
    }

    public static boolean containedInIncludeFolders(NativeIncludes myNativeIncludes, VirtualFile file) {
        return IncludesViewNode.containedInIncludeFolders(myNativeIncludes, file);
    }

    private static final class RootFolder {
        @NotNull
        final VirtualFile rootFolder;
        @NotNull
        final List<VirtualFile> sourceFolders = new ArrayList<VirtualFile>();
        @NotNull
        final List<VirtualFile> sourceFiles = new ArrayList<VirtualFile>();

        RootFolder(@NotNull VirtualFile rootFolder) {
            this.rootFolder = rootFolder;
        }
    }
}

