/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk;

import com.android.builder.model.NativeArtifact;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.navigator.nodes.AndroidViewModuleNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkLibraryEnhancedHeadersNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkLibraryNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.NativeIncludes;
import com.google.common.collect.HashMultimap;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkModuleNode
extends AndroidViewModuleNode {
    public NdkModuleNode(@NotNull Project project, @NotNull Module value2, @NotNull ViewSettings settings) {
        super(project, value2, settings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = (Module)this.getValue();
        if (module == null) {
            return Collections.emptyList();
        }
        NdkFacet facet = NdkFacet.getInstance(module);
        if (facet == null || facet.getNdkModuleModel() == null) {
            return Collections.emptyList();
        }
        assert (this.myProject != null);
        return NdkModuleNode.getNativeSourceNodes(this.myProject, facet.getNdkModuleModel(), this.getSettings());
    }

    @NotNull
    public static Collection<AbstractTreeNode> getNativeSourceNodes(@NotNull Project project, @NotNull NdkModuleModel ndkModel, @NotNull ViewSettings settings) {
        IdeNativeAndroidProject nativeAndroidProject = ndkModel.getAndroidProject();
        Set<String> sourceFileExtensions = nativeAndroidProject.getFileExtensions().keySet();
        NdkVariant variant = ndkModel.getSelectedVariant();
        HashMultimap nativeLibraries = HashMultimap.create();
        for (NativeArtifact artifact : variant.getArtifacts()) {
            String artifactOutputFileName = artifact.getOutputFile().getName();
            nativeLibraries.put((Object)artifactOutputFileName, (Object)artifact);
        }
        if (!((Boolean)StudioFlags.ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT.get()).booleanValue() && nativeLibraries.keySet().size() == 1) {
            return NdkLibraryNode.getSourceFolderNodes(project, nativeLibraries.values(), settings, sourceFileExtensions);
        }
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        for (String name : nativeLibraries.keySet()) {
            String nativeLibraryType = "";
            String nativeLibraryName = StringUtil.trimEnd((String)name, (String)".so");
            if (nativeLibraryName.length() < name.length()) {
                nativeLibraryType = "Shared Library";
            } else {
                nativeLibraryName = StringUtil.trimEnd((String)name, (String)".a");
                if (nativeLibraryName.length() < name.length()) {
                    nativeLibraryType = "Static Library";
                }
            }
            nativeLibraryName = StringUtil.trimStart((String)nativeLibraryName, (String)"lib");
            if (((Boolean)StudioFlags.ENABLE_ENHANCED_NATIVE_HEADER_SUPPORT.get()).booleanValue()) {
                LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                VirtualFile buildFileFolder = fileSystem.findFileByIoFile(ndkModel.getRootDirPath());
                NdkLibraryEnhancedHeadersNode node = new NdkLibraryEnhancedHeadersNode(buildFileFolder, project, nativeLibraryName, nativeLibraryType, nativeLibraries.get((Object)name), new NativeIncludes(ndkModel::findSettings, nativeLibraries.get((Object)name)), settings, sourceFileExtensions);
                children.add((AbstractTreeNode)node);
                continue;
            }
            NdkLibraryNode node = new NdkLibraryNode(project, nativeLibraryName, nativeLibraryType, nativeLibraries.get((Object)name), settings, sourceFileExtensions);
            children.add((AbstractTreeNode)node);
        }
        if (children.size() == 1) {
            return ((AbstractTreeNode)children.get(0)).getChildren();
        }
        return children;
    }

    @Nullable
    public Comparable getSortKey() {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return module.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return String.format("%1$s (Native-Android-Gradle)", ((Module)this.getValue()).getName());
    }

    public void update(@NotNull PresentationData presentation) {
        super.update(presentation);
        Module module = (Module)this.getValue();
        if (module != null) {
            presentation.setIcon(GradleUtil.getModuleIcon(module));
        }
    }

    public static boolean containedInIncludeFolders(@NotNull NdkModuleModel model2, @NotNull VirtualFile file) {
        if (!LexicalIncludePaths.hasHeaderExtension(file.getName())) {
            return false;
        }
        NdkVariant variant = model2.getSelectedVariant();
        HashMultimap nativeLibraries = HashMultimap.create();
        for (NativeArtifact artifact : variant.getArtifacts()) {
            String artifactOutputFileName = artifact.getOutputFile().getName();
            nativeLibraries.put((Object)artifactOutputFileName, (Object)artifact);
        }
        for (String name : nativeLibraries.keySet()) {
            if (!NdkLibraryEnhancedHeadersNode.containedInIncludeFolders(new NativeIncludes(model2::findSettings, nativeLibraries.get((Object)name)), file)) continue;
            return true;
        }
        return false;
    }
}

