/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.model;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.ClassifiedIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.IncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageFamilyKey;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PackageFamilyValue
extends ClassifiedIncludeValue {
    @NotNull
    public final PackageFamilyKey myKey;
    @NotNull
    public final ImmutableList<ClassifiedIncludeValue> myIncludes;

    public PackageFamilyValue(@NotNull PackageFamilyKey key, @NotNull Collection<ClassifiedIncludeValue> includes) {
        this.myKey = key;
        this.myIncludes = ImmutableList.copyOf(includes);
    }

    @Override
    @NotNull
    public String getPackageDescription() {
        return this.myKey.getDescription();
    }

    public String toString() {
        return String.format("%s (%s)", this.myKey.getDescription(), this.getPackageFamilyBaseFolder());
    }

    @Override
    @NotNull
    public String getSortKey() {
        if (this.getPackageType().equals((Object)PackageType.NdkComponent) || this.getPackageType().equals((Object)PackageType.NdkSxsComponent)) {
            return IncludeValue.SortOrderKey.NDK_PACKAGING_FAMILY.myKey + this.toString();
        }
        return IncludeValue.SortOrderKey.OTHER_PACKAGING_FAMILY.myKey + this.toString();
    }

    @Override
    @NotNull
    public PackageType getPackageType() {
        return this.myKey.getPackageType();
    }

    @Override
    @NotNull
    public File getPackageFamilyBaseFolder() {
        return this.myKey.getPackagingFamilyBaseFolder();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageFamilyValue)) {
            return false;
        }
        PackageFamilyValue that = (PackageFamilyValue)obj;
        return Objects.equals(this.myKey, that.myKey) && Objects.equals(this.myIncludes, that.myIncludes);
    }

    public final int hashCode() {
        return Objects.hash(this.myKey, this.myIncludes);
    }
}

