/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.resolver;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.CDepIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.CocosIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IndexedRegularExpressionIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.NdkIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.PlainFolderIncludeResolver;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncludeResolver {
    @NotNull
    public static IncludeResolver getGlobalResolver(@Nullable File ndkPath) {
        final IncludeResolver[] resolvers = new IncludeResolver[]{new NdkIncludeResolver(), new CDepIncludeResolver(), new CocosIncludeResolver(), IncludeResolver.thirdParty(), IncludeResolver.externals(), new PlainFolderIncludeResolver()};
        return new IncludeResolver(){

            @Override
            public SimpleIncludeValue resolve(@NotNull File includeFolder) {
                for (IncludeResolver resolver : resolvers) {
                    SimpleIncludeValue dependency = resolver.resolve(includeFolder);
                    if (dependency == null) continue;
                    return dependency;
                }
                return null;
            }
        };
    }

    @NotNull
    static IncludeResolver thirdParty() {
        return new IndexedRegularExpressionIncludeResolver(PackageType.ThirdParty, "^(?<home>.*)(?<relative>/third[_-]party/(?<library>.*?)/.*)$", null);
    }

    @NotNull
    static IncludeResolver externals() {
        return new IndexedRegularExpressionIncludeResolver(PackageType.Externals, "^(?<home>.*)(?<relative>/(?:E|e)xternals?/(?<library>.*?)/.*)$", null);
    }

    @Nullable
    public abstract SimpleIncludeValue resolve(@NotNull File var1);
}

