/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeSet {
    @NotNull
    private static final String TAKE_NEXT_SENTINEL = "TAKE_NEXT_SENTINEL";
    @NotNull
    private static final Pattern PATTERN = Pattern.compile("://", 16);
    @NotNull
    private final LinkedHashSet<String> myIncludes = new LinkedHashSet();

    @NotNull
    private static String getSysrootEquivalentPath(@NotNull String compilerFlag) {
        String result2 = compilerFlag;
        result2 = FilenameUtils.concat((String)result2, (String)"usr");
        result2 = FilenameUtils.concat((String)result2, (String)"include");
        return result2;
    }

    private static String analyzeFlagPattern(@NotNull String flag, @NotNull IncludeFlags checkFlag) {
        String check = checkFlag.myFlag;
        if (flag.equals("-" + check)) {
            return TAKE_NEXT_SENTINEL;
        }
        if (flag.equals("--" + check)) {
            return TAKE_NEXT_SENTINEL;
        }
        if (flag.startsWith("-" + check + "=")) {
            return flag.substring(check.length() + 2);
        }
        if (flag.startsWith("--" + check + "=")) {
            return flag.substring(check.length() + 3);
        }
        if (flag.startsWith("-" + check)) {
            return flag.substring(check.length() + 1);
        }
        if (flag.startsWith("--" + check)) {
            return flag.substring(check.length() + 2);
        }
        return null;
    }

    public List<File> getIncludesInOrder() {
        return this.myIncludes.stream().map(File::new).collect(Collectors.toList());
    }

    public void addIncludesFromCompilerFlags(@NotNull Collection<String> compilerFlags, @Nullable File compilerWorkingFolder) {
        ArrayList<String> includeFolders = new ArrayList<String>();
        boolean useNextFlagAsInclude = false;
        boolean appendUsrInclude = false;
        block0: for (String compilerFlag : compilerFlags) {
            if (useNextFlagAsInclude) {
                if (appendUsrInclude) {
                    compilerFlag = IncludeSet.getSysrootEquivalentPath(compilerFlag);
                }
                includeFolders.add(compilerFlag);
                useNextFlagAsInclude = false;
                continue;
            }
            for (IncludeFlags test : IncludeFlags.values()) {
                String analysis = IncludeSet.analyzeFlagPattern(compilerFlag, test);
                if (analysis == TAKE_NEXT_SENTINEL) {
                    useNextFlagAsInclude = true;
                    appendUsrInclude = test.myAppendUsrInclude;
                    continue block0;
                }
                if (analysis == null) continue;
                if (test.myAppendUsrInclude) {
                    analysis = IncludeSet.getSysrootEquivalentPath(analysis);
                }
                includeFolders.add(analysis);
                continue block0;
            }
        }
        for (String include : includeFolders) {
            this.add(include, compilerWorkingFolder);
        }
    }

    public void add(@NotNull String include, @Nullable File compilerWorkingFolder) {
        String includePath = include;
        if (compilerWorkingFolder != null) {
            includePath = FilenameUtils.concat((String)compilerWorkingFolder.getAbsolutePath(), (String)includePath);
        }
        includePath = FilenameUtils.normalizeNoEndSeparator((String)includePath, (boolean)true);
        includePath = PATTERN.matcher(includePath).replaceAll(Matcher.quoteReplacement(":/"));
        this.myIncludes.add(includePath);
    }

    @NotNull
    public String toString() {
        return this.myIncludes.toString();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncludeSet)) {
            return false;
        }
        IncludeSet that = (IncludeSet)obj;
        return Objects.equals(this.myIncludes, that.myIncludes);
    }

    public final int hashCode() {
        return this.myIncludes.hashCode();
    }

    private static enum IncludeFlags {
        I_FLAG("I", false),
        ISYSTEM_FLAG("isystem", false),
        SYSROOT_FLAG("sysroot", true);

        @NotNull
        final String myFlag;
        final boolean myAppendUsrInclude;

        private IncludeFlags(String flag, boolean appendUsrInclude) {
            this.myFlag = flag;
            this.myAppendUsrInclude = appendUsrInclude;
        }
    }
}

