/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.ClassifiedIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageFamilyValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.IncludeSet;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapper;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapperKt;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.PackagingFamilyViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.PackagingViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.SimpleIncludeViewNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncludeViewNode<T extends ClassifiedIncludeValue>
extends ProjectViewNode<T>
implements FolderGroupNode {
    @NotNull
    protected final VirtualFile myBuildFileFolder;
    private String myDescription;
    private int myHashCode;
    @NotNull
    protected final IncludeSet myIncludeFolders;
    protected final boolean myShowPackageType;

    protected IncludeViewNode(@NotNull VirtualFile buildFileFolder, @NotNull T thisInclude, @NotNull IncludeSet allIncludes, boolean showPackageType, @Nullable Project project, @NotNull ViewSettings viewSettings) {
        super(project, thisInclude, viewSettings);
        this.myBuildFileFolder = buildFileFolder;
        this.myIncludeFolders = allIncludes;
        this.myShowPackageType = showPackageType;
    }

    public static IncludeViewNode createIncludeView(@NotNull VirtualFile buildFileFolder, @NotNull ClassifiedIncludeValue thisInclude, @NotNull IncludeSet allIncludes, boolean showPackageType, @Nullable Project project, @NotNull ViewSettings viewSettings) {
        if (thisInclude instanceof SimpleIncludeValue) {
            return new SimpleIncludeViewNode(buildFileFolder, (SimpleIncludeValue)thisInclude, allIncludes, showPackageType, project, viewSettings);
        }
        if (thisInclude instanceof PackageValue) {
            return new PackagingViewNode(buildFileFolder, allIncludes, project, (PackageValue)thisInclude, viewSettings, showPackageType);
        }
        if (thisInclude instanceof PackageFamilyValue) {
            return new PackagingFamilyViewNode(buildFileFolder, allIncludes, project, (PackageFamilyValue)thisInclude, viewSettings, showPackageType);
        }
        throw new RuntimeException(thisInclude.getClass().toString());
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public Comparable getSortKey() {
        ClassifiedIncludeValue value2 = (ClassifiedIncludeValue)this.getValue();
        return "[icon-f]" + (value2 == null ? "" : value2.getSortKey());
    }

    @NotNull
    public final String toString() {
        return this.myDescription;
    }

    private void lazyInitializeHashCodeAndDescription() {
        if (this.myDescription == null) {
            StringBuilder sb = new StringBuilder();
            this.writeDescription(PresentationDataWrapperKt.createPresentationDataWrapper(sb));
            this.myDescription = sb.toString();
            this.myHashCode = Objects.hash(this.myBuildFileFolder, this.myDescription);
        }
    }

    abstract void writeDescription(@NotNull PresentationDataWrapper var1);

    protected final void update(@NotNull PresentationData presentation) {
        this.writeDescription(PresentationDataWrapperKt.createPresentationDataWrapper(presentation));
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        IncludeViewNode that = (IncludeViewNode)object;
        this.lazyInitializeHashCodeAndDescription();
        return Objects.equals(this.myBuildFileFolder, that.myBuildFileFolder) && Objects.equals(this.myDescription, that.myDescription);
    }

    public final int hashCode() {
        this.lazyInitializeHashCodeAndDescription();
        return this.myHashCode;
    }
}

