/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.ClassifiedIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.IncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.IncludeValues;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.ShadowingIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.IncludeSet;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNodes;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.NativeIncludes;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.SimpleIncludeViewNode;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.util.VirtualFiles;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CppHeadersViewEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludesViewNode
extends ProjectViewNode<NativeIncludes>
implements FolderGroupNode {
    @NotNull
    private final VirtualFile myBuildFileFolder;
    @NotNull
    private final NativeIncludes myDependencyInfo;

    public IncludesViewNode(@NotNull VirtualFile buildFileFolder, @Nullable Project project, @NotNull NativeIncludes dependencyInfo, @NotNull ViewSettings settings) {
        super(project, (Object)dependencyInfo, settings);
        this.myDependencyInfo = dependencyInfo;
        this.myBuildFileFolder = buildFileFolder;
    }

    @NotNull
    private static IncludeSet distinctIncludes(@NotNull NativeIncludes nativeIncludes) {
        IncludeSet set = new IncludeSet();
        HashSet<String> settingsSeen = new HashSet<String>();
        for (NativeArtifact artifact : nativeIncludes.myArtifacts) {
            for (NativeFile sourceFile : artifact.getSourceFiles()) {
                File workingDirectory = sourceFile.getWorkingDirectory();
                String settingsName = sourceFile.getSettingsName();
                if (settingsSeen.contains(settingsName)) continue;
                settingsSeen.add(settingsName);
                NativeSettings settings = nativeIncludes.findExpectedSettings(settingsName);
                set.addIncludesFromCompilerFlags(settings.getCompilerFlags(), workingDirectory);
            }
        }
        return set;
    }

    public static boolean containedInIncludeFolders(@NotNull NativeIncludes includes, @NotNull VirtualFile file) {
        if (!LexicalIncludePaths.hasHeaderExtension(file.getName())) {
            return false;
        }
        IncludeSet includeSet = IncludesViewNode.distinctIncludes(includes);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File include : includeSet.getIncludesInOrder()) {
            VirtualFile ancestor = fileSystem.findFileByIoFile(include);
            if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        return PsiDirectory.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Long startTime = System.currentTimeMillis();
        try {
            Collection<? extends AbstractTreeNode> collection = this.getChildrenImpl();
            return collection;
        }
        finally {
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CPP_HEADERS_VIEW_EVENT).setCppHeadersViewEvent(CppHeadersViewEvent.newBuilder().setEventDurationMs(System.currentTimeMillis() - startTime).setType(CppHeadersViewEvent.CppHeadersViewEventType.OPEN_TOP_INCLUDES_NODE)), this.myProject));
        }
    }

    @NotNull
    private Collection<? extends AbstractTreeNode> getChildrenImpl() {
        ArrayList<Object> result2 = new ArrayList<Object>();
        Project project = this.getProject();
        if (project == null || GradleSyncState.getInstance(project).isSyncInProgress()) {
            return result2;
        }
        IncludeSet includeSet = IncludesViewNode.distinctIncludes(this.myDependencyInfo);
        ArrayList<SimpleIncludeValue> simpleIncludes = new ArrayList<SimpleIncludeValue>();
        for (File includeFolder : includeSet.getIncludesInOrder()) {
            simpleIncludes.add(IncludeResolver.getGlobalResolver(IdeSdks.getInstance().getAndroidNdkPath()).resolve(includeFolder));
        }
        List<IncludeValue> includes = IncludeValues.INSTANCE.organize(simpleIncludes);
        for (IncludeValue include : includes) {
            if (include instanceof ShadowingIncludeValue) {
                ShadowingIncludeValue concrete = (ShadowingIncludeValue)include;
                result2.addAll(IncludeViewNodes.getIncludeFolderNodesWithShadowing(concrete.getIncludePathsInOrder(), VirtualFiles.convertToVirtualFile(concrete.myExcludes), false, project, this.getSettings()));
                continue;
            }
            if (include instanceof SimpleIncludeValue) {
                result2.add(new SimpleIncludeViewNode(this.myBuildFileFolder, (SimpleIncludeValue)include, includeSet, true, this.getProject(), this.getSettings()));
                continue;
            }
            if (!(include instanceof ClassifiedIncludeValue)) continue;
            ClassifiedIncludeValue classifiedIncludeValue = (ClassifiedIncludeValue)include;
            result2.add(IncludeViewNode.createIncludeView(this.myBuildFileFolder, classifiedIncludeValue, includeSet, true, this.getProject(), this.getSettings()));
        }
        return result2;
    }

    public boolean contains(@NotNull VirtualFile file) {
        return IncludesViewNode.containedInIncludeFolders(this.myDependencyInfo, file);
    }

    public int getTypeSortWeight(boolean sortByType) {
        return -100;
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.addText("includes", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(AllIcons.Nodes.WebFolder);
    }

    @NotNull
    public String toString() {
        return "includes";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IncludesViewNode)) {
            return false;
        }
        IncludesViewNode that = (IncludesViewNode)object;
        return Objects.equals(this.myBuildFileFolder, that.myBuildFileFolder);
    }

    public int hashCode() {
        return this.myBuildFileFolder.hashCode();
    }
}

