/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.ClassifiedIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageFamilyValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.IncludeSet;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapper;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingFamilyViewNode
extends IncludeViewNode<PackageFamilyValue> {
    protected PackagingFamilyViewNode(@NotNull VirtualFile buildFileFolder, @NotNull IncludeSet includeFolders, @Nullable Project project, @NotNull PackageFamilyValue include, @NotNull ViewSettings viewSettings, boolean showPackageType) {
        super(buildFileFolder, include, includeFolders, showPackageType, project, viewSettings);
    }

    @NotNull
    private PackageFamilyValue getPackageFamilyValue() {
        PackageFamilyValue value2 = (PackageFamilyValue)this.getValue();
        assert (value2 != null);
        return value2;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<IncludeViewNode> children = new ArrayList<IncludeViewNode>();
        PackageFamilyValue value2 = this.getPackageFamilyValue();
        for (ClassifiedIncludeValue child : value2.myIncludes) {
            children.add(PackagingFamilyViewNode.createIncludeView(this.myBuildFileFolder, child, this.myIncludeFolders, false, this.getProject(), this.getSettings()));
        }
        return children;
    }

    @Override
    final void writeDescription(@NotNull PresentationDataWrapper presentation) {
        presentation.addText(this.getPackageFamilyValue().myKey.getDescription(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.addText(String.format(" (%s)", this.getPackageFamilyValue().getPackagingFamilyBaseFolderNameRelativeToHome()), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (!LexicalIncludePaths.hasHeaderExtension(file.getName())) {
            return false;
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        PackageFamilyValue value2 = this.getPackageFamilyValue();
        for (ClassifiedIncludeValue include : value2.myIncludes) {
            VirtualFile ancestor = fileSystem.findFileByIoFile(include.getPackageFamilyBaseFolder());
            if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

