/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.repository.io.FileOpUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathValidationResult {
    public static final PathValidationResult OK = new PathValidationResult(Status.OK, null, "any", new Object[0]);
    private static final CharMatcher ILLEGAL_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"[/\\\\?%*:|\"<>!;]");
    private static final Set<String> INVALID_WINDOWS_FILENAMES = ImmutableSet.of((Object)"con", (Object)"prn", (Object)"aux", (Object)"clock$", (Object)"nul", (Object)"com1", (Object[])new String[]{"com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "$mft", "$mftmirr", "$logfile", "$volume", "$attrdef", "$bitmap", "$boot", "$badclus", "$secure", "$upcase", "$extend", "$quota", "$objid", "$reparse"});
    private static final int WINDOWS_PATH_LENGTH_LIMIT = 100;
    private final Status myStatus;
    private final Message myMessage;
    private final Object[] myMessageParams;

    public static PathValidationResult warn(@NotNull Message message2, String field2, Object ... params) {
        return new PathValidationResult(Status.WARN, message2, field2, params);
    }

    public static PathValidationResult error(@NotNull Message message2, String field2, Object ... params) {
        return new PathValidationResult(Status.ERROR, message2, field2, params);
    }

    @NotNull
    public static PathValidationResult validateLocation(@Nullable String projectLocation) {
        return PathValidationResult.validateLocation(projectLocation, "project location", true);
    }

    @NotNull
    public static PathValidationResult validateLocation(@Nullable String projectLocation, @NotNull String fieldName, boolean checkEmpty) {
        return PathValidationResult.validateLocation(projectLocation, fieldName, checkEmpty, WritableCheckMode.NOT_WRITABLE_IS_ERROR);
    }

    @NotNull
    public static PathValidationResult validateLocation(@Nullable String projectLocation, @NotNull String fieldName, boolean checkEmpty, @NotNull WritableCheckMode writableCheckMode) {
        PathValidationResult warningResult = null;
        if (projectLocation == null || projectLocation.isEmpty()) {
            return PathValidationResult.error(Message.NO_LOCATION_SPECIFIED, fieldName, new Object[0]);
        }
        if (File.separatorChar == '/' && projectLocation.contains("\\") || File.separatorChar == '\\' && projectLocation.contains("/")) {
            return PathValidationResult.error(Message.BAD_SLASHES, fieldName, new Object[0]);
        }
        File testFile = new File(projectLocation);
        while (testFile != null) {
            String filename = testFile.getName();
            if (ILLEGAL_CHARACTER_MATCHER.matchesAnyOf((CharSequence)filename)) {
                char illegalChar = filename.charAt(ILLEGAL_CHARACTER_MATCHER.indexIn((CharSequence)filename));
                return PathValidationResult.error(Message.ILLEGAL_CHARACTER, fieldName, Character.valueOf(illegalChar), filename);
            }
            if (INVALID_WINDOWS_FILENAMES.contains(filename.toLowerCase(Locale.US))) {
                Status status = SystemInfo.isWindows ? Status.ERROR : Status.WARN;
                return new PathValidationResult(status, Message.ILLEGAL_FILENAME, fieldName, filename);
            }
            if (CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)filename)) {
                warningResult = PathValidationResult.warn(Message.WHITESPACE, fieldName, new Object[0]);
            }
            if (!CharMatcher.ASCII.matchesAllOf((CharSequence)filename)) {
                if (SystemInfo.isWindows) {
                    return PathValidationResult.error(Message.NON_ASCII_CHARS_ERROR, fieldName, new Object[0]);
                }
                warningResult = PathValidationResult.warn(Message.NON_ASCII_CHARS_WARNING, fieldName, new Object[0]);
            }
            File parent = testFile.getParentFile();
            if (!writableCheckMode.equals((Object)WritableCheckMode.DO_NOT_CHECK) && !testFile.exists() && parent != null && parent.exists() && !parent.canWrite()) {
                return PathValidationResult.pathNotWritable(WritableCheckMode.NOT_WRITABLE_IS_ERROR, fieldName, parent);
            }
            testFile = parent;
        }
        if (SystemInfo.isWindows && projectLocation.length() > 100) {
            return PathValidationResult.error(Message.PATH_TOO_LONG, fieldName, new Object[0]);
        }
        File file = new File(projectLocation);
        if (file.isFile()) {
            return PathValidationResult.error(Message.PROJECT_LOC_IS_FILE, fieldName, new Object[0]);
        }
        if (file.getParent() == null) {
            return PathValidationResult.error(Message.PROJECT_IS_FILE_SYSTEM_ROOT, fieldName, new Object[0]);
        }
        if (file.getParentFile().exists() && !file.getParentFile().isDirectory()) {
            return PathValidationResult.error(Message.PARENT_NOT_DIR, fieldName, new Object[0]);
        }
        if (!writableCheckMode.equals((Object)WritableCheckMode.DO_NOT_CHECK) && file.exists() && !file.canWrite()) {
            return PathValidationResult.pathNotWritable(writableCheckMode, fieldName, file);
        }
        String installLocation = PathManager.getHomePathFor(Application.class);
        if (installLocation != null && FileUtil.isAncestor((File)new File(installLocation), (File)file, (boolean)false)) {
            String applicationName = ApplicationNamesInfo.getInstance().getProductName();
            return PathValidationResult.error(Message.INSIDE_ANDROID_STUDIO, fieldName, applicationName);
        }
        if (checkEmpty && file.exists() && FileOpUtils.create().listFiles(file).length > 0) {
            return PathValidationResult.warn(Message.NON_EMPTY_DIR, fieldName, new Object[0]);
        }
        return warningResult == null ? OK : warningResult;
    }

    private PathValidationResult(@NotNull Status status, @Nullable Message message2, @NotNull String field2, Object ... messageParams) {
        this.myStatus = status;
        this.myMessage = message2;
        this.myMessageParams = ArrayUtil.prepend((Object)field2, (Object[])messageParams);
    }

    @NotNull
    private static PathValidationResult pathNotWritable(@NotNull WritableCheckMode mode, @NotNull String field2, @NotNull File file) {
        switch (mode) {
            case NOT_WRITABLE_IS_ERROR: {
                return PathValidationResult.error(Message.PATH_NOT_WRITABLE, field2, file.getPath());
            }
            case NOT_WRITABLE_IS_WARNING: {
                return PathValidationResult.warn(Message.PATH_NOT_WRITABLE, field2, file.getPath());
            }
        }
        throw new IllegalArgumentException(mode.toString());
    }

    public String getFormattedMessage() {
        if (this.myMessage == null) {
            throw new IllegalStateException("Null message, are you trying to get the message of an OK?");
        }
        return String.format(this.myMessage.toString(), this.myMessageParams);
    }

    @NotNull
    public Status getStatus() {
        return this.myStatus;
    }

    public boolean isError() {
        return this.myStatus.equals((Object)Status.ERROR);
    }

    public boolean isOk() {
        return this.myStatus.equals((Object)Status.OK);
    }

    public static enum WritableCheckMode {
        DO_NOT_CHECK,
        NOT_WRITABLE_IS_ERROR,
        NOT_WRITABLE_IS_WARNING;

    }

    public static enum Message {
        NO_LOCATION_SPECIFIED("Please specify a %1$s"),
        BAD_SLASHES("Your %1$s contains incorrect slashes ('\\' vs '/')"),
        ILLEGAL_CHARACTER("Illegal character in %1$s path: '%2$c' in filename %3s"),
        ILLEGAL_FILENAME("Illegal filename in %1$s path: %2$s"),
        WHITESPACE("%1$s should not contain whitespace, as this can cause problems with the NDK tools."),
        NON_ASCII_CHARS_WARNING("Your %1$s contains non-ASCII characters, which can cause problems. Proceed with caution."),
        NON_ASCII_CHARS_ERROR("Your %1$s contains non-ASCII characters."),
        PATH_NOT_WRITABLE("The path '%2$s' is not writable. Please choose a new location."),
        PROJECT_LOC_IS_FILE("There must not already be a file at the %1$s."),
        NON_EMPTY_DIR("A non-empty directory already exists at the specified %1$s. Existing files may be overwritten. Proceed with caution."),
        PROJECT_IS_FILE_SYSTEM_ROOT("The %1$s can not be at the filesystem root"),
        PARENT_NOT_DIR("The %1$s's parent directory must be a directory, not a plain file"),
        INSIDE_ANDROID_STUDIO("The %1$s is inside %2$s install location"),
        PATH_TOO_LONG("The %1$s is too long");

        private final String myText;

        private Message(String text) {
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }
    }

    public static enum Status {
        OK,
        WARN,
        ERROR;

    }
}

