/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeHelper {
    private static final String DEFAULT_THEME_NAME = "AppTheme";
    private static final String ALTERNATE_THEME_NAME = "Theme.App";
    private static final String APP_COMPAT = "Theme.AppCompat.";
    private final Module myModule;
    private final LocalResourceRepository myProjectRepository;

    public ThemeHelper(@NotNull Module module) {
        this.myModule = module;
        this.myProjectRepository = ResourceRepositoryManager.getProjectResources(module);
    }

    @Nullable
    public String getAppThemeName() {
        String manifestTheme = MergedManifestManager.getSnapshot(this.myModule).getManifestTheme();
        if (manifestTheme != null) {
            manifestTheme = StringUtil.trimStart((String)manifestTheme, (String)"@style/");
            return manifestTheme;
        }
        if (this.getProjectStyleResource(DEFAULT_THEME_NAME) != null) {
            return DEFAULT_THEME_NAME;
        }
        if (this.getProjectStyleResource(ALTERNATE_THEME_NAME) != null) {
            return ALTERNATE_THEME_NAME;
        }
        return null;
    }

    public boolean isAppCompatTheme(@NotNull String themeName) {
        StyleResourceValue theme = this.getProjectStyleResource(themeName);
        return this.isAppCompatTheme(themeName, theme);
    }

    public static boolean themeExists(@NotNull Configuration configuration, @NotNull String themeName) {
        return ThemeHelper.getStyleResource(configuration, themeName) != null;
    }

    public boolean isLocalTheme(@NotNull String themeName) {
        return this.getProjectStyleResource(themeName) != null;
    }

    public static Boolean hasActionBar(@NotNull Configuration configuration, @NotNull String themeName) {
        StyleResourceValue theme = ThemeHelper.getStyleResource(configuration, themeName);
        if (theme == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        ResourceValue value2 = resolver.resolveResValue((ResourceValue)resolver.findItemInStyle(theme, ResourceReference.attr((ResourceNamespace)ResourceNamespace.TODO(), (String)"windowActionBar")));
        if (value2 == null || value2.getValue() == null) {
            return true;
        }
        return "true".equals(value2.getValue());
    }

    @Nullable
    private static StyleResourceValue getStyleResource(@NotNull Configuration configuration, @NotNull String themeName) {
        configuration.setTheme(themeName);
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        ResourceUrl url = ResourceUrl.parse((String)themeName);
        if (url == null) {
            return null;
        }
        ResourceReference reference2 = url.resolve(ResourceNamespace.TODO(), ResourceNamespace.Resolver.EMPTY_RESOLVER);
        if (reference2 == null) {
            return null;
        }
        return resolver.getStyle(reference2);
    }

    @Nullable
    private StyleResourceValue getProjectStyleResource(@Nullable String theme) {
        if (theme == null) {
            return null;
        }
        List<ResourceItem> items2 = this.myProjectRepository.getResources(ResourceNamespace.TODO(), ResourceType.STYLE, theme);
        if (items2.isEmpty()) {
            return null;
        }
        return (StyleResourceValue)items2.get(0).getResourceValue();
    }

    private boolean isAppCompatTheme(@NotNull String themeName, @Nullable StyleResourceValue localTheme) {
        while (localTheme != null) {
            String parentThemeName = localTheme.getParentStyleName();
            if (parentThemeName == null) {
                if (themeName.lastIndexOf(46) > 0) {
                    parentThemeName = themeName.substring(0, themeName.lastIndexOf(46));
                } else {
                    return false;
                }
            }
            themeName = parentThemeName;
            localTheme = this.getProjectStyleResource(themeName);
        }
        return themeName.startsWith(APP_COMPAT);
    }
}

