/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.util.AssetUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterables;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class AssetStudioUtils {
    @NotNull
    public static Rectangle scaleRectangle(@NotNull Rectangle rect, double scaleFactor) {
        return new Rectangle(AssetStudioUtils.roundToInt((double)rect.x * scaleFactor), AssetStudioUtils.roundToInt((double)rect.y * scaleFactor), AssetStudioUtils.roundToInt((double)rect.width * scaleFactor), AssetStudioUtils.roundToInt((double)rect.height * scaleFactor));
    }

    @NotNull
    public static Rectangle scaleRectangleAroundCenter(@NotNull Rectangle rect, double scaleFactor) {
        int width = AssetStudioUtils.roundToInt((double)rect.width * scaleFactor);
        int height = AssetStudioUtils.roundToInt((double)rect.height * scaleFactor);
        return new Rectangle(AssetStudioUtils.roundToInt((double)rect.x * scaleFactor - (double)(width - rect.width) / 2.0), AssetStudioUtils.roundToInt((double)rect.y * scaleFactor - (double)(height - rect.height) / 2.0), width, height);
    }

    @NotNull
    public static Dimension scaleDimension(@NotNull Dimension dim, double scaleFactor) {
        return new Dimension(AssetStudioUtils.roundToInt((double)dim.width * scaleFactor), AssetStudioUtils.roundToInt((double)dim.height * scaleFactor));
    }

    public static int roundToInt(double f) {
        return Math.round((float)f);
    }

    @NotNull
    public static BufferedImage createDummyImage() {
        return new BufferedImage(1, 1, 2);
    }

    @NotNull
    public static BufferedImage trim(@NotNull BufferedImage image) {
        BufferedImage cropped = ImageUtils.cropBlank((BufferedImage)image, null, (int)2);
        return cropped != null ? cropped : image;
    }

    @NotNull
    public static BufferedImage pad(@NotNull BufferedImage image, int paddingPercent) {
        if (image.getWidth() <= 1 || image.getHeight() <= 1) {
            return image;
        }
        if (paddingPercent > 100) {
            paddingPercent = 100;
        }
        int largerSide = Math.max(image.getWidth(), image.getHeight());
        int smallerSide = Math.min(image.getWidth(), image.getHeight());
        int padding = largerSide * paddingPercent / 100;
        padding = Math.max(-(smallerSide / 2 - 1), padding);
        return AssetUtil.paddedImage((BufferedImage)image, (int)padding);
    }

    public static boolean resourceExists(@NotNull AndroidModuleTemplate paths2, @NotNull ResourceFolderType resourceType, @NotNull String name) {
        File resDir = (File)Iterables.getFirst(paths2.getResDirectories(), null);
        if (resDir == null) {
            return false;
        }
        File[] resTypes = resDir.listFiles();
        if (resTypes == null) {
            return false;
        }
        for (File resTypeDir : resTypes) {
            File[] files2;
            if (!resTypeDir.isDirectory() || !resourceType.equals((Object)ResourceFolderType.getFolderType((String)resTypeDir.getName())) || (files2 = resTypeDir.listFiles()) == null) continue;
            for (File f : files2) {
                if (!FileUtil.getNameWithoutExtension((File)f).equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean resourceExists(@NotNull AndroidFacet facet, @NotNull ResourceType resourceType, @NotNull String name) {
        LocalResourceRepository repository = ResourceRepositoryManager.getAppResources(facet);
        return repository.hasResources(ResourceNamespace.TODO(), resourceType, name);
    }

    public static String toLowerCamelCase(Enum<?> enumValue) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, enumValue.name());
    }

    public static String toUpperCamelCase(Enum<?> enumValue) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enumValue.name());
    }

    private AssetStudioUtils() {
    }
}

