/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.utils.SdkUtils;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuiltInImages {
    private BuiltInImages() {
    }

    @Nullable
    public static BufferedImage getStencilImage(@NotNull String relativePath) throws IOException {
        try (InputStream is = BuiltInImages.class.getResourceAsStream(relativePath);){
            BufferedImage bufferedImage = is == null ? null : ImageIO.read(is);
            return bufferedImage;
        }
    }

    @Nullable
    public static BufferedImage getClipartImage(@NotNull String name) throws IOException {
        try (InputStream is = BuiltInImages.class.getResourceAsStream("/images/clipart/big/" + name);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> getResourcesNames(@NotNull String pathPrefix, @NotNull String filenameExtension) {
        ArrayList<String> names = new ArrayList<String>(80);
        ZipFile zipFile = null;
        try {
            ProtectionDomain protectionDomain = BuiltInImages.class.getProtectionDomain();
            URL url = protectionDomain.getCodeSource().getLocation();
            if (url != null && url.getProtocol().equals("jar")) {
                File file = SdkUtils.urlToFile((URL)url);
                zipFile = new JarFile(file);
            } else {
                Enumeration<URL> en = BuiltInImages.class.getClassLoader().getResources(pathPrefix);
                if (en.hasMoreElements()) {
                    url = en.nextElement();
                    URLConnection urlConnection = url.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        JarURLConnection urlConn = (JarURLConnection)urlConnection;
                        zipFile = urlConn.getJarFile();
                    } else if ("file".equals(url.getProtocol())) {
                        File directory = new File(url.getPath());
                        String[] list = directory.list();
                        if (list == null) {
                            List<String> list2 = Collections.emptyList();
                            return list2;
                        }
                        List<String> list3 = Arrays.asList(list);
                        return list3;
                    }
                }
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.startsWith(pathPrefix) || !name.endsWith(filenameExtension)) continue;
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash >= 0) {
                    name = name.substring(lastSlash + 1);
                }
                names.add(name);
            }
        }
        catch (Exception e) {
            BuiltInImages.getLog().error((Throwable)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    BuiltInImages.getLog().error((Throwable)e);
                }
            }
        }
        return names;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(BuiltInImages.class);
    }
}

