/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutPsiPullParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class DrawableRenderer
implements Disposable {
    @NotNull
    private final CompletableFuture<RenderTask> myRenderTaskFuture;
    @NotNull
    private final Object myRenderLock = new Object();
    @NotNull
    private final MyLayoutPullParserFactory myParserFactory;
    @NotNull
    private final AtomicInteger myCounter = new AtomicInteger();

    public DrawableRenderer(@NotNull AndroidFacet facet) {
        this(facet, ThemeEditorUtils.getConfigurationForModule(facet.getModule()));
    }

    public DrawableRenderer(@NotNull AndroidFacet facet, @NotNull Configuration configuration) {
        Module module = facet.getModule();
        RenderLogger logger = new RenderLogger(LauncherIconGenerator.class.getSimpleName(), module);
        this.myParserFactory = new MyLayoutPullParserFactory(module.getProject(), logger);
        this.myRenderTaskFuture = CompletableFuture.supplyAsync(() -> {
            try {
                RenderService service = RenderService.getInstance(module.getProject());
                RenderTask renderTask = service.taskBuilder(facet, configuration).withLogger(logger).withParserFactory(this.myParserFactory).buildSynchronously();
                assert (renderTask != null);
                renderTask.getLayoutlibCallback().setLogger(logger);
                if (logger.hasProblems()) {
                    DrawableRenderer.getLog().error(RenderProblem.format(logger.getMessages()));
                }
                return renderTask;
            }
            catch (Error | RuntimeException e) {
                DrawableRenderer.getLog().error(e);
                return null;
            }
        }, PooledThreadExecutor.INSTANCE);
    }

    @NotNull
    public CompletableFuture<BufferedImage> renderDrawable(@NotNull String xmlDrawableText, @NotNull Dimension size) {
        String xmlText = VectorDrawableTransformer.transform(xmlDrawableText, size, 1.0, null, null, 1.0);
        String resourceName = String.format("preview_%x.xml", this.myCounter.getAndIncrement());
        ResourceValueImpl value2 = new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.DRAWABLE, "ic_image_preview", "file://" + resourceName);
        return this.myRenderTaskFuture.thenCompose(arg_0 -> this.lambda$renderDrawable$1(resourceName, xmlText, size, (ResourceValue)value2, arg_0));
    }

    public void dispose() {
        this.myRenderTaskFuture.whenComplete((renderTask, throwable) -> {
            if (renderTask != null) {
                Object object = this.myRenderLock;
                synchronized (object) {
                    renderTask.dispose();
                }
            }
        });
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(DrawableRenderer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ CompletionStage lambda$renderDrawable$1(String resourceName, String xmlText, Dimension size, ResourceValue value2, RenderTask renderTask) {
        if (renderTask == null) {
            return CompletableFuture.completedFuture(AssetStudioUtils.createDummyImage());
        }
        Object object = this.myRenderLock;
        synchronized (object) {
            this.myParserFactory.addFileContent(new PathString(resourceName), xmlText);
            renderTask.setOverrideRenderSize(size.width, size.height);
            renderTask.setMaxRenderSize(size.width, size.height);
            return renderTask.renderDrawable(value2);
        }
    }

    private static class MyLayoutPullParserFactory
    implements ILayoutPullParserFactory {
        @NotNull
        private final ConcurrentMap<PathString, String> myFileContent = new ConcurrentHashMap<PathString, String>();
        @NotNull
        private final Project myProject;
        @NotNull
        private final RenderLogger myLogger;

        MyLayoutPullParserFactory(@NotNull Project project, @NotNull RenderLogger logger) {
            this.myProject = project;
            this.myLogger = logger;
        }

        @Override
        @Nullable
        public ILayoutPullParser create(@NotNull PathString file, @NotNull LayoutlibCallback layoutlibCallback) {
            String content = (String)this.myFileContent.remove(file);
            if (content == null) {
                return null;
            }
            XmlFile xmlFile = (XmlFile)MyLayoutPullParserFactory.createEphemeralPsiFile(this.myProject, file.getFileName(), StdFileTypes.XML, content);
            return LayoutPsiPullParser.create(xmlFile, this.myLogger);
        }

        void addFileContent(@NotNull PathString file, @NotNull String content) {
            this.myFileContent.put(file, content);
        }

        @NotNull
        private static PsiFile createEphemeralPsiFile(@NotNull Project project, @NotNull String filename, @NotNull LanguageFileType fileType, @NotNull String contents) {
            LightVirtualFile virtualFile;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(psiManager, (VirtualFile)(virtualFile = new LightVirtualFile(filename, (FileType)fileType, (CharSequence)contents)));
            PsiFile psiFile = viewProvider.getPsi(fileType.getLanguage());
            if (psiFile == null) {
                throw new IllegalArgumentException("Unsupported language: " + fileType.getLanguage().getDisplayName());
            }
            return psiFile;
        }
    }
}

