/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.lint.checks.ApiLookup;
import com.android.utils.CharSequences;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class IconGenerator
implements Disposable {
    protected static final ImmutableSet<Density> DENSITIES = ImmutableSet.of((Object)Density.MEDIUM, (Object)Density.HIGH, (Object)Density.XHIGH, (Object)Density.XXHIGH, (Object)Density.XXXHIGH);
    private static final Map<Density, Pattern> DENSITY_PATTERNS;
    protected static final BufferedImage PLACEHOLDER_IMAGE;
    private final OptionalProperty<BaseAsset> mySourceAsset = new OptionalValueProperty<BaseAsset>();
    private final StringProperty myOutputName = new StringValueProperty();
    protected final int myMinSdkVersion;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @NotNull
    private final AtomicNullableLazyValue<ApiLookup> myApiLookup;
    @NotNull
    protected final String myLineSeparator;

    public IconGenerator(final @NotNull Project project, int minSdkVersion2, @NotNull GraphicGeneratorContext context) {
        this.myMinSdkVersion = minSdkVersion2;
        this.myContext = context;
        this.myApiLookup = new AtomicNullableLazyValue<ApiLookup>(){

            @Nullable
            protected ApiLookup compute() {
                return LintIdeClient.getApiLookup(project);
            }
        };
        this.myLineSeparator = CodeStyle.getSettings((Project)project).getLineSeparator();
    }

    public void dispose() {
    }

    @NotNull
    public GraphicGeneratorContext getGraphicGeneratorContext() {
        return this.myContext;
    }

    @NotNull
    public final OptionalProperty<BaseAsset> sourceAsset() {
        return this.mySourceAsset;
    }

    @NotNull
    public final StringProperty outputName() {
        return this.myOutputName;
    }

    @NotNull
    public IconGeneratorResult generateIcons(Options options) {
        return new IconGeneratorResult(this.generateIcons(this.myContext, options, (String)this.myOutputName.get()), options);
    }

    @NotNull
    private CategoryIconMap generateIntoMemory() {
        if (!((Optional)this.mySourceAsset.get()).isPresent()) {
            throw new IllegalStateException("Can't generate icons without a source asset set first");
        }
        Options options = this.createOptions(false);
        return this.generateIntoMemory(options);
    }

    @NotNull
    private CategoryIconMap generateIntoMemory(Options options) {
        HashMap<String, Map<String, BufferedImage>> categoryMap = new HashMap<String, Map<String, BufferedImage>>();
        this.generateRasterImage(null, categoryMap, this.myContext, options, (String)this.myOutputName.get());
        return new CategoryIconMap(categoryMap);
    }

    @NotNull
    public final Map<File, BufferedImage> generateIntoFileMap(@NotNull File resDirectory) {
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        if (resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        CategoryIconMap categoryIconMap = this.generateIntoMemory();
        return categoryIconMap.toFileMap(resDirectory.getParentFile());
    }

    @NotNull
    public Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidModuleTemplate template) {
        Options options = this.createOptions(false);
        return this.generateIntoIconMap(template, options);
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIconPlaceholders(@NotNull AndroidModuleTemplate template) {
        if (((String)this.myOutputName.get()).isEmpty()) {
            return Collections.emptyMap();
        }
        Options options = this.createOptions(false);
        options.usePlaceholders = true;
        return this.generateIntoIconMap(template, options);
    }

    @NotNull
    private Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidModuleTemplate template, Options options) {
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        IconGeneratorResult icons = this.generateIcons(options);
        HashMap<File, GeneratedIcon> outputMap = new HashMap<File, GeneratedIcon>();
        icons.getIcons().forEach(icon2 -> {
            PathString relativePath = icon2.getOutputPath();
            if (relativePath != null && icon2.getCategory() != IconCategory.PREVIEW) {
                File path = new File(IconGenerator.getBaseDirectory(template, icon2.getCategory()), relativePath.getNativePath());
                outputMap.put(path, (GeneratedIcon)icon2);
            }
        });
        return outputMap;
    }

    @NotNull
    private static File getBaseDirectory(@NotNull AndroidModuleTemplate template, @NotNull IconCategory category) {
        File dir;
        if (category == IconCategory.WEB) {
            dir = template.getManifestDirectory();
            if (dir != null) {
                return dir;
            }
            dir = IconGenerator.getResDirectory(template);
            if (dir != null) {
                dir = dir.getParentFile();
            }
        } else {
            dir = IconGenerator.getResDirectory(template);
        }
        if (dir == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        return dir;
    }

    public void generateIconsToDisk(@NotNull AndroidModuleTemplate template) {
        Map<File, GeneratedIcon> pathIconMap = this.generateIntoIconMap(template);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Map.Entry fileImageEntry : pathIconMap.entrySet()) {
                File file = (File)fileImageEntry.getKey();
                GeneratedIcon icon2 = (GeneratedIcon)fileImageEntry.getValue();
                if (icon2 instanceof GeneratedImageIcon) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"png")) {
                        this.writePngToDisk(file, ((GeneratedImageIcon)icon2).getImage());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                if (icon2 instanceof GeneratedXmlResource) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"xml")) {
                        this.writeTextToDisk(file, ((GeneratedXmlResource)icon2).getXmlText());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
            }
        });
    }

    private void writePngToDisk(@NotNull File file, @NotNull BufferedImage image) {
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "PNG", outputStream);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    private void writeTextToDisk(@NotNull File file, @NotNull String text) {
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
                outputStream.write(bytes);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        List<Callable<GeneratedIcon>> tasks = this.createIconGenerationTasks(context, options, name);
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        Disposable taskCanceler = () -> executor.cancelAllTasks();
        Disposer.register((Disposable)this, (Disposable)taskCanceler);
        tasks.forEach(arg_0 -> ((WaitableExecutor)executor).execute(arg_0));
        try {
            List list = executor.waitForTasksWithQuickFail(true);
            return list;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            Disposer.dispose((Disposable)taskCanceler);
        }
    }

    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        TransformedImageAsset image = options.image;
        if (image == null) {
            return Collections.emptyList();
        }
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        for (Density density : DENSITIES) {
            Density outputDensity;
            Options localOptions = options.clone();
            localOptions.density = density;
            Density density2 = outputDensity = density == Density.XXXHIGH && image.isDrawable() ? Density.ANYDPI : density;
            if (options.generateOutputIcons) {
                if (outputDensity == Density.ANYDPI) {
                    tasks.add(() -> {
                        Options iconOptions = options.clone();
                        iconOptions.density = Density.ANYDPI;
                        String xmlDrawableText = image.getTransformedDrawable();
                        assert (xmlDrawableText != null);
                        iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                        return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.REGULAR, xmlDrawableText);
                    });
                } else {
                    tasks.add(() -> {
                        BufferedImage foregroundImage = this.generateRasterImage(context, localOptions);
                        return new GeneratedImageIcon(name, new PathString(this.getIconPath(localOptions, name)), IconCategory.REGULAR, density, foregroundImage);
                    });
                }
            }
            if (!options.generatePreviewIcons) continue;
            tasks.add(() -> {
                BufferedImage rasterImage = this.generateRasterImage(context, localOptions);
                return new GeneratedImageIcon(outputDensity.getResourceValue(), null, IconCategory.PREVIEW, density, rasterImage);
            });
        }
        return tasks;
    }

    @NotNull
    public abstract BufferedImage generateRasterImage(@NotNull GraphicGeneratorContext var1, @NotNull Options var2);

    @NotNull
    protected BufferedImage generateRasterImage(@NotNull Dimension iconSize, @NotNull Options options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        double scaleFactor = IconGenerator.getMdpiScaleFactor(options.density);
        Dimension imageSize = AssetStudioUtils.scaleDimension(iconSize, scaleFactor);
        TransformedImageAsset imageAsset = options.image;
        return imageAsset == null ? PLACEHOLDER_IMAGE : imageAsset.getTransformedImage(imageSize);
    }

    @NotNull
    public abstract Options createOptions(boolean var1);

    @NotNull
    protected String getIconPath(@NotNull Options options, @NotNull String iconName) {
        return this.getIconFolder(options) + '/' + IconGenerator.getIconFileName(options, iconName);
    }

    @NotNull
    private static String getIconFileName(@NotNull Options options, @NotNull String iconName) {
        if (options.density == Density.ANYDPI) {
            return iconName + ".xml";
        }
        return iconName + ".png";
    }

    @NotNull
    protected String getIconFolder(@NotNull Options options) {
        switch (options.iconFolderKind) {
            case DRAWABLE: {
                return IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, options.density, options.apiVersion);
            }
            case MIPMAP: {
                return IconGenerator.getIconFolder(ResourceFolderType.MIPMAP, options.density, options.apiVersion);
            }
            case DRAWABLE_NO_DPI: {
                return IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, Density.NODPI, options.apiVersion);
            }
            case VALUES: {
                return IconGenerator.getIconFolder(ResourceFolderType.VALUES, Density.NODPI, options.apiVersion);
            }
        }
        throw new IllegalArgumentException("Unexpected folder kind: " + (Object)((Object)options.iconFolderKind));
    }

    @NotNull
    private static String getIconFolder(@NotNull ResourceFolderType folderType, @NotNull Density density, int apiVersion) {
        StringBuilder buf = new StringBuilder(50);
        buf.append(folderType.getName());
        if (density != Density.NODPI) {
            buf.append('-');
            buf.append(density.getResourceValue());
        }
        if (apiVersion > 1) {
            buf.append("-v");
            buf.append(apiVersion);
        }
        return buf.toString();
    }

    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        if (options.density == Density.ANYDPI) {
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
            return;
        }
        Density[] densityValues = Density.values();
        Arrays.sort(densityValues, Comparator.comparingInt(Density::getDpiValue));
        for (Density density : densityValues) {
            if (!density.isValidValueForDevice() || !this.includeDensity(density)) continue;
            options.density = density;
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
        }
    }

    private void generateImageAndUpdateMap(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        BufferedImage image = this.generateRasterImage(context, options);
        String mapCategory = category;
        if (mapCategory == null) {
            mapCategory = options.density.getResourceValue();
        }
        Map imageMap = categoryMap.computeIfAbsent(mapCategory, k -> new LinkedHashMap());
        imageMap.put(this.getIconPath(options, name), image);
    }

    protected boolean includeDensity(@NotNull Density density) {
        return density.isRecommended() && density != Density.LOW;
    }

    public static double getMdpiScaleFactor(@NotNull Density density) {
        if (density == Density.ANYDPI) {
            density = Density.XXXHIGH;
        }
        if (density == Density.NODPI) {
            density = Density.MEDIUM;
        }
        return (double)density.getDpiValue() / (double)Density.MEDIUM.getDpiValue();
    }

    @Nullable
    public static Density pathToDensity(@NotNull String iconPath) {
        iconPath = FileUtils.toSystemIndependentPath((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    protected int calculateMinRequiredApiLevel(@NotNull String xmlDrawableText, int minSdk) {
        ApiLookup apiLookup = (ApiLookup)this.myApiLookup.getValue();
        if (apiLookup == null) {
            return 0;
        }
        KXmlParser parser = new KXmlParser();
        int requiredApiLevel = 0;
        try {
            int type;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)xmlDrawableText, (boolean)true));
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                for (int i2 = 0; i2 < parser.getAttributeCount(); ++i2) {
                    int attributeApiLevel;
                    String attributeName;
                    if (!"http://schemas.android.com/apk/res/android".equals(parser.getAttributeNamespace(i2)) || (attributeName = parser.getAttributeName(i2)).equals("fillType") || requiredApiLevel >= (attributeApiLevel = apiLookup.getFieldVersion("android/R$attr", attributeName))) continue;
                    requiredApiLevel = attributeApiLevel;
                }
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            // empty catch block
        }
        return requiredApiLevel > minSdk && requiredApiLevel > 21 ? requiredApiLevel : 0;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(IconGenerator.class);
    }

    @Nullable
    public static File getResDirectory(@NotNull AndroidModuleTemplate template) {
        return (File)Iterables.getLast(template.getResDirectories(), null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder.build();
        PLACEHOLDER_IMAGE = AssetStudioUtils.createDummyImage();
    }

    public static enum Style {
        SIMPLE("fore1");

        public final String id;

        private Style(String id) {
            this.id = id;
        }
    }

    public static enum Shape {
        NONE("none"),
        CIRCLE("circle"),
        SQUARE("square"),
        VRECT("vrect"),
        HRECT("hrect"),
        SQUARE_DOG("square_dogear"),
        VRECT_DOG("vrect_dogear"),
        HRECT_DOG("hrect_dogear");

        public final String id;

        private Shape(String id) {
            this.id = id;
        }
    }

    public static enum IconFolderKind {
        DRAWABLE,
        DRAWABLE_NO_DPI,
        MIPMAP,
        VALUES;

    }

    public static class Options
    implements Cloneable {
        public boolean generateOutputIcons;
        public boolean generatePreviewIcons;
        @Nullable
        public TransformedImageAsset image;
        @Nullable
        public ListenableFuture<BufferedImage> sourceImageFuture;
        public boolean isTrimmed;
        public int paddingPercent;
        @NotNull
        public IconFolderKind iconFolderKind = IconFolderKind.DRAWABLE;
        @NotNull
        public Density density = Density.XHIGH;
        public int apiVersion;
        public boolean usePlaceholders;

        public Options(boolean forPreview) {
            this.generatePreviewIcons = forPreview;
            this.generateOutputIcons = !forPreview;
        }

        @NotNull
        public Options clone() {
            try {
                return (Options)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }
}

