/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherLegacyIconGenerator;
import com.android.tools.idea.npw.assetstudio.PrimitiveShapesHelper;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtilRt;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherIconGenerator
extends IconGenerator {
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(2533018);
    public static final Rectangle IMAGE_SIZE_FULL_BLEED_DP = new Rectangle(0, 0, 108, 108);
    public static final Dimension SIZE_FULL_BLEED_DP = IMAGE_SIZE_FULL_BLEED_DP.getSize();
    private static final Rectangle IMAGE_SIZE_SAFE_ZONE_DP = new Rectangle(0, 0, 66, 66);
    private static final Rectangle IMAGE_SIZE_VIEWPORT_DP = new Rectangle(0, 0, 72, 72);
    private static final Rectangle IMAGE_SIZE_LEGACY_DP = new Rectangle(0, 0, 48, 48);
    private static final Rectangle IMAGE_SIZE_VIEW_PORT_WEB_PX = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_FULL_BLEED_WEB_PX = new Rectangle(0, 0, 768, 768);
    private final ObjectProperty<Color> myBackgroundColor = new ObjectValueProperty<Color>(DEFAULT_BACKGROUND_COLOR);
    private final BoolProperty myGenerateLegacyIcon = new BoolValueProperty(true);
    private final BoolProperty myGenerateRoundIcon = new BoolValueProperty(true);
    private final BoolProperty myGenerateWebIcon = new BoolValueProperty(true);
    private final ObjectProperty<IconGenerator.Shape> myLegacyIconShape = new ObjectValueProperty<IconGenerator.Shape>(IconGenerator.Shape.SQUARE);
    private final ObjectProperty<IconGenerator.Shape> myWebIconShape = new ObjectValueProperty<IconGenerator.Shape>(IconGenerator.Shape.SQUARE);
    private final BoolProperty myShowGrid = new BoolValueProperty();
    private final BoolProperty myShowSafeZone = new BoolValueProperty(true);
    private final ObjectValueProperty<Density> myPreviewDensity = new ObjectValueProperty<Density>(Density.XHIGH);
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>();
    private final StringProperty myForegroundLayerName = new StringValueProperty();
    private final StringProperty myBackgroundLayerName = new StringValueProperty();

    public LauncherIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer));
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        return this.myBackgroundColor;
    }

    @NotNull
    public BoolProperty generateLegacyIcon() {
        return this.myGenerateLegacyIcon;
    }

    @NotNull
    public BoolProperty generateRoundIcon() {
        return this.myGenerateRoundIcon;
    }

    @NotNull
    public BoolProperty generateWebIcon() {
        return this.myGenerateWebIcon;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> legacyIconShape() {
        return this.myLegacyIconShape;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> webIconShape() {
        return this.myWebIconShape;
    }

    @NotNull
    public OptionalProperty<ImageAsset> backgroundImageAsset() {
        return this.myBackgroundImageAsset;
    }

    @NotNull
    public BoolProperty showGrid() {
        return this.myShowGrid;
    }

    @NotNull
    public BoolProperty showSafeZone() {
        return this.myShowSafeZone;
    }

    @NotNull
    public ObjectValueProperty<Density> previewDensity() {
        return this.myPreviewDensity;
    }

    @NotNull
    public StringProperty foregroundLayerName() {
        return this.myForegroundLayerName;
    }

    @NotNull
    public StringProperty backgroundLayerName() {
        return this.myBackgroundLayerName;
    }

    @Override
    @NotNull
    public LauncherIconOptions createOptions(boolean forPreview) {
        ImageAsset backgroundAsset;
        double scaleFactor;
        LauncherIconOptions options = new LauncherIconOptions(forPreview);
        BaseAsset foregroundAsset = this.sourceAsset().getValueOrNull();
        if (foregroundAsset != null) {
            Color color;
            options.useForegroundColor = foregroundAsset.isColorable();
            Color color2 = color = foregroundAsset.isColorable() ? (Color)foregroundAsset.color().getValueOrNull() : null;
            if (color != null) {
                options.foregroundColor = color.getRGB();
            }
            scaleFactor = (double)((Integer)foregroundAsset.scalingPercent().get()).intValue() / 100.0;
            if (foregroundAsset instanceof ImageAsset && ((ImageAsset)foregroundAsset).isClipart()) {
                scaleFactor *= 0.58;
            } else if (foregroundAsset instanceof TextAsset) {
                scaleFactor *= 0.46;
            } else if (((Boolean)foregroundAsset.trimmed().get()).booleanValue()) {
                scaleFactor *= IMAGE_SIZE_SAFE_ZONE_DP.getWidth() / SIZE_FULL_BLEED_DP.getWidth();
            }
            options.foregroundImage = new TransformedImageAsset(foregroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, color, this.getGraphicGeneratorContext());
        }
        if ((backgroundAsset = this.myBackgroundImageAsset.getValueOrNull()) != null) {
            scaleFactor = (double)((Integer)backgroundAsset.scalingPercent().get()).intValue() / 100.0;
            options.backgroundImage = new TransformedImageAsset(backgroundAsset, SIZE_FULL_BLEED_DP, scaleFactor, null, this.getGraphicGeneratorContext());
        }
        options.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options.showGrid = (Boolean)this.myShowGrid.get();
        options.showSafeZone = (Boolean)this.myShowSafeZone.get();
        options.previewDensity = this.myPreviewDensity.get();
        options.foregroundLayerName = (String)this.myForegroundLayerName.get();
        options.backgroundLayerName = (String)this.myBackgroundLayerName.get();
        options.generateLegacyIcon = (Boolean)this.myGenerateLegacyIcon.get();
        options.legacyIconShape = (IconGenerator.Shape)((Object)this.myLegacyIconShape.get());
        options.webIconShape = (IconGenerator.Shape)((Object)this.myWebIconShape.get());
        options.generateRoundIcon = (Boolean)this.myGenerateRoundIcon.get();
        options.generateWebIcon = (Boolean)this.myGenerateWebIcon.get();
        return options;
    }

    @Override
    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options, @NotNull String name) {
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options;
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        this.createOutputIconsTasks(context, name, launcherIconOptions, tasks);
        this.createXmlDrawableResourcesTasks(name, launcherIconOptions, tasks);
        LauncherIconGenerator.createPreviewImagesTasks(context, launcherIconOptions, tasks);
        return tasks;
    }

    private void createOutputIconsTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options.generateOutputIcons) {
            return;
        }
        for (Density density : DENSITIES) {
            LauncherIconOptions localOptions = options.clone();
            localOptions.density = density;
            localOptions.showGrid = false;
            localOptions.showSafeZone = false;
            this.createOutputIconsForSingleDensityTasks(context, name, localOptions, density, tasks);
        }
        if (options.generateWebIcon) {
            tasks.add(() -> {
                LauncherIconOptions localOptions = options.clone();
                localOptions.showGrid = false;
                localOptions.showSafeZone = false;
                localOptions.generateWebIcon = true;
                localOptions.generateOutputIcons = true;
                localOptions.generatePreviewIcons = false;
                localOptions.legacyIconShape = localOptions.webIconShape;
                BufferedImage image = LauncherIconGenerator.generateLegacyImage(context, localOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(localOptions, name)), IconCategory.WEB, Density.NODPI, image);
            });
        }
    }

    private void createOutputIconsForSingleDensityTasks(@NotNull GraphicGeneratorContext context, @NotNull String name, @NotNull LauncherIconOptions options, @NotNull Density density, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (options.foregroundImage != null && options.foregroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions foregroundOptions = options.clone();
                foregroundOptions.generateWebIcon = false;
                foregroundOptions.generatePreviewIcons = false;
                foregroundOptions.generateOutputIcons = true;
                BufferedImage foregroundImage = LauncherIconGenerator.generateIconForegroundLayer(context, foregroundOptions);
                return new GeneratedImageIcon(foregroundOptions.foregroundLayerName, new PathString(this.getIconPath(foregroundOptions, options.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, density, foregroundImage);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isRasterImage()) {
            tasks.add(() -> {
                LauncherIconOptions backgroundOptions = options.clone();
                backgroundOptions.generateWebIcon = false;
                backgroundOptions.generatePreviewIcons = false;
                backgroundOptions.generateOutputIcons = true;
                BufferedImage backgroundImage = LauncherIconGenerator.generateIconBackgroundLayer(context, backgroundOptions);
                return new GeneratedImageIcon(backgroundOptions.backgroundLayerName, new PathString(this.getIconPath(backgroundOptions, options.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, density, backgroundImage);
            });
        }
        if (options.generateLegacyIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                BufferedImage legacy = LauncherIconGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name, new PathString(this.getIconPath(legacyOptions, name)), IconCategory.LEGACY, density, legacy);
            });
        }
        if (options.generateRoundIcon) {
            tasks.add(() -> {
                LauncherIconOptions legacyOptions = options.clone();
                legacyOptions.previewShape = PreviewShape.LEGACY_ROUND;
                legacyOptions.generateWebIcon = false;
                legacyOptions.generatePreviewIcons = false;
                legacyOptions.generateOutputIcons = true;
                legacyOptions.legacyIconShape = IconGenerator.Shape.CIRCLE;
                BufferedImage legacyRound = LauncherIconGenerator.generateLegacyImage(context, legacyOptions);
                return new GeneratedImageIcon(name + "_round", new PathString(this.getIconPath(legacyOptions, name + "_round")), IconCategory.ROUND_API_25, density, legacyRound);
            });
        }
    }

    private void createXmlDrawableResourcesTasks(@NotNull String name, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        TransformedImageAsset image;
        if (!options.generateOutputIcons) {
            return;
        }
        LauncherIconOptions iconOptions = options.clone();
        iconOptions.density = Density.ANYDPI;
        iconOptions.generateWebIcon = false;
        iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        iconOptions.apiVersion = 26;
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        tasks.add(() -> {
            String xmlAdaptiveIcon = this.getAdaptiveIconXml(iconOptions);
            return new GeneratedXmlResource(name + "_round", new PathString(this.getIconPath(iconOptions, name + "_round")), IconCategory.XML_RESOURCE, xmlAdaptiveIcon);
        });
        if (options.foregroundImage != null && options.foregroundImage.isDrawable()) {
            image = options.foregroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generateWebIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    LauncherIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    LauncherIconGenerator.getLog().error("Transformed foreground drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.foregroundLayerName)), IconCategory.ADAPTIVE_FOREGROUND_LAYER, xmlDrawableText);
            });
        }
        if (options.backgroundImage != null && options.backgroundImage.isDrawable()) {
            image = options.backgroundImage;
            tasks.add(() -> {
                String xmlDrawableText;
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generateWebIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
                if (!image.isDrawable()) {
                    LauncherIconGenerator.getLog().error("Background image is not drawable!", new Throwable());
                }
                if ((xmlDrawableText = image.getTransformedDrawable()) == null) {
                    LauncherIconGenerator.getLog().error("Transformed background drawable is null" + (image.isDrawable() ? " but the image is drawable" : ""), new Throwable());
                    xmlDrawableText = "<vector/>";
                }
                iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.ADAPTIVE_BACKGROUND_LAYER, xmlDrawableText);
            });
        } else if (options.backgroundImage == null) {
            tasks.add(() -> {
                LauncherIconOptions iconOptions = options.clone();
                iconOptions.generateWebIcon = false;
                iconOptions.density = Density.ANYDPI;
                iconOptions.iconFolderKind = IconGenerator.IconFolderKind.VALUES;
                String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<resources>%1$s    <color name=\"%2$s\">#%3$06X</color>%1$s</resources>";
                String xmlColor = String.format(format, this.myLineSeparator, iconOptions.backgroundLayerName, iconOptions.backgroundColor & 0xFFFFFF);
                return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, iconOptions.backgroundLayerName)), IconCategory.XML_RESOURCE, xmlColor);
            });
        }
    }

    @NotNull
    private String getAdaptiveIconXml(@NotNull LauncherIconOptions options) {
        String backgroundType = options.backgroundImage == null ? "color" : (options.backgroundImage.isDrawable() ? "drawable" : "mipmap");
        String foregroundType = options.foregroundImage != null && options.foregroundImage.isDrawable() ? "drawable" : "mipmap";
        String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">%1$s    <background android:drawable=\"@%2$s/%3$s\"/>%1$s    <foreground android:drawable=\"@%4$s/%5$s\"/>%1$s</adaptive-icon>";
        return String.format(format, this.myLineSeparator, backgroundType, options.backgroundLayerName, foregroundType, options.foregroundLayerName);
    }

    private static void createPreviewImagesTasks(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options, @NotNull List<Callable<GeneratedIcon>> tasks) {
        if (!options.generatePreviewIcons) {
            return;
        }
        ArrayList<PreviewShape> previewShapes = new ArrayList<PreviewShape>();
        previewShapes.add(PreviewShape.FULL_BLEED);
        previewShapes.add(PreviewShape.SQUIRCLE);
        previewShapes.add(PreviewShape.CIRCLE);
        previewShapes.add(PreviewShape.SQUARE);
        previewShapes.add(PreviewShape.ROUNDED_SQUARE);
        if (options.generateLegacyIcon) {
            previewShapes.add(PreviewShape.LEGACY);
        }
        if (options.generateRoundIcon) {
            previewShapes.add(PreviewShape.LEGACY_ROUND);
        }
        if (options.generateWebIcon) {
            previewShapes.add(PreviewShape.WEB);
        }
        for (PreviewShape previewShape : previewShapes) {
            tasks.add(() -> {
                BufferedImage image;
                LauncherIconOptions localOptions = options.clone();
                localOptions.density = options.previewDensity;
                localOptions.previewShape = previewShape;
                localOptions.generateLegacyIcon = previewShape == PreviewShape.LEGACY;
                localOptions.generateRoundIcon = previewShape == PreviewShape.LEGACY_ROUND;
                localOptions.generateWebIcon = previewShape == PreviewShape.WEB;
                String errorMessage = null;
                try {
                    image = LauncherIconGenerator.generatePreviewImage(context, localOptions);
                }
                catch (Throwable e) {
                    errorMessage = e.getMessage();
                    Rectangle imageRect = LauncherIconGenerator.getFullBleedRectangle(localOptions);
                    image = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
                }
                GeneratedImageIcon icon2 = new GeneratedImageIcon(previewShape.id, null, IconCategory.PREVIEW, localOptions.density, image);
                if (errorMessage != null) {
                    icon2.setErrorMessage(errorMessage);
                }
                return icon2;
            });
        }
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options, @NotNull String name) {
        LauncherIconOptions launcherIconOptions = (LauncherIconOptions)options;
        LauncherIconOptions localOptions = launcherIconOptions.clone();
        localOptions.generateWebIcon = false;
        Collection<GeneratedIcon> icons = this.generateIcons(context, options, name);
        icons.stream().filter(x -> x instanceof GeneratedImageIcon).map(x -> (GeneratedImageIcon)x).filter(x -> x.getOutputPath() != null).forEach(x -> {
            assert (x.getOutputPath() != null);
            Map imageMap = categoryMap.computeIfAbsent(x.getCategory().toString(), k -> new LinkedHashMap());
            LauncherIconOptions iconOptions = localOptions.clone();
            iconOptions.density = x.getDensity();
            iconOptions.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
            iconOptions.generateWebIcon = x.getCategory() == IconCategory.WEB;
            imageMap.put(x.getOutputPath().toString(), x.getImage());
        });
    }

    @Override
    @NotNull
    public BufferedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        return LauncherIconGenerator.generatePreviewImage(context, (LauncherIconOptions)options);
    }

    @NotNull
    private static BufferedImage generatePreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        switch (options.previewShape) {
            case CIRCLE: 
            case SQUIRCLE: 
            case ROUNDED_SQUARE: 
            case SQUARE: {
                return LauncherIconGenerator.generateViewportPreviewImage(context, options);
            }
            case LEGACY: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                return LauncherIconGenerator.generateLegacyImage(context, options);
            }
            case LEGACY_ROUND: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = false;
                options.legacyIconShape = IconGenerator.Shape.CIRCLE;
                return LauncherIconGenerator.generateLegacyImage(context, options);
            }
            case FULL_BLEED: {
                BufferedImage image = LauncherIconGenerator.generateFullBleedPreviewImage(context, options);
                return LauncherIconGenerator.scaledPreviewImage(image, 0.8f);
            }
            case WEB: {
                options.generatePreviewIcons = true;
                options.generateWebIcon = true;
                options.legacyIconShape = options.webIconShape;
                BufferedImage image = LauncherIconGenerator.generateLegacyImage(context, options);
                image = AssetUtil.trimmedImage((BufferedImage)image);
                double scale = LauncherIconGenerator.getMdpiScaleFactor(options.previewDensity);
                return LauncherIconGenerator.scaledPreviewImage(image, 0.25 * scale);
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    private static BufferedImage generateFullBleedPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        Layers layers = LauncherIconGenerator.generateIconLayers(context, options);
        BufferedImage result2 = LauncherIconGenerator.mergeLayers(layers, Color.BLACK);
        LauncherIconGenerator.drawGrid(options, result2);
        return result2;
    }

    @NotNull
    private static BufferedImage generateLegacyImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        Rectangle viewportRect = LauncherIconGenerator.getViewportRectangle(options);
        Rectangle legacyRect = LauncherIconGenerator.getLegacyRectangle(options);
        Density legacyOrWebDensity = options.generateWebIcon ? Density.NODPI : options.density;
        Rectangle legacyShapeRect = LauncherLegacyIconGenerator.getTargetRect(options.legacyIconShape, legacyOrWebDensity);
        Layers layers = LauncherIconGenerator.generateIconLayers(context, options);
        BufferedImage fullBleed = LauncherIconGenerator.mergeLayers(layers);
        float viewportScale = LauncherIconGenerator.getRectangleInsideScale(viewportRect, legacyShapeRect);
        BufferedImage scaledFullBleed = options.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(fullBleed, viewportScale) : LauncherIconGenerator.scaledImage(fullBleed, viewportScale);
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (options.legacyIconShape != IconGenerator.Shape.NONE) {
            shapeImageBack = LauncherLegacyIconGenerator.loadBackImage(context, options.legacyIconShape, legacyOrWebDensity);
            shapeImageFore = LauncherLegacyIconGenerator.loadStyleImage(context, options.legacyIconShape, legacyOrWebDensity, IconGenerator.Style.SIMPLE);
            shapeImageMask = LauncherLegacyIconGenerator.loadMaskImage(context, options.legacyIconShape, legacyOrWebDensity);
        }
        BufferedImage legacyImage = AssetUtil.newArgbBufferedImage((int)legacyRect.width, (int)legacyRect.height);
        Graphics2D gLegacy = (Graphics2D)legacyImage.getGraphics();
        if (shapeImageBack != null) {
            AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)shapeImageBack, (Rectangle)legacyRect);
        }
        if (shapeImageMask != null) {
            scaledFullBleed = LauncherIconGenerator.applyMask(scaledFullBleed, shapeImageMask);
        }
        AssetUtil.drawCentered((Graphics2D)gLegacy, (BufferedImage)scaledFullBleed, (Rectangle)legacyRect);
        if (shapeImageFore != null) {
            gLegacy.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gLegacy.dispose();
        return legacyImage;
    }

    public static float getRectangleInsideScale(@NotNull Rectangle source, @NotNull Rectangle destination) {
        float scaleWidth = (float)destination.width / (float)source.width;
        float scaleHeight = (float)destination.height / (float)source.height;
        return Math.min(scaleWidth, scaleHeight);
    }

    @NotNull
    private static BufferedImage scaledImage(@NotNull BufferedImage image, float scale) {
        int width = Math.round((float)image.getWidth() * scale);
        int height = Math.round((float)image.getHeight() * scale);
        return AssetUtil.scaledImage((BufferedImage)image, (int)width, (int)height);
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage image, double scale) {
        int width = (int)Math.round((double)image.getWidth() * scale);
        int height = (int)Math.round((double)image.getHeight() * scale);
        return LauncherIconGenerator.scaledPreviewImage(image, width, height);
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage source, int width, int height) {
        if (source.getWidth() == width && source.getHeight() == height) {
            return source;
        }
        BufferedImage scaledBufImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D g = scaledBufImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        return scaledBufImage;
    }

    @NotNull
    private static BufferedImage generateViewportPreviewImage(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        Layers layers = LauncherIconGenerator.generateIconLayers(context, options);
        BufferedImage result2 = LauncherIconGenerator.mergeLayers(layers);
        BufferedImage mask = LauncherIconGenerator.generateMaskLayer(context, options, options.previewShape);
        result2 = LauncherIconGenerator.cropImageToViewport(options, result2);
        result2 = LauncherIconGenerator.applyMask(result2, mask);
        LauncherIconGenerator.drawGrid(options, result2);
        return result2;
    }

    private static BufferedImage cropImageToViewport(@NotNull LauncherIconOptions options, @NotNull BufferedImage image) {
        return LauncherIconGenerator.cropImage(image, LauncherIconGenerator.getViewportRectangle(options));
    }

    private static BufferedImage cropImage(@NotNull BufferedImage image, @NotNull Rectangle targetRect) {
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage subImage = image.getSubimage((imageRect.width - targetRect.width) / 2, (imageRect.height - targetRect.height) / 2, targetRect.width, targetRect.height);
        BufferedImage viewportImage = AssetUtil.newArgbBufferedImage((int)targetRect.width, (int)targetRect.height);
        Graphics2D gViewport = (Graphics2D)viewportImage.getGraphics();
        gViewport.drawImage((Image)subImage, 0, 0, null);
        gViewport.dispose();
        return viewportImage;
    }

    @NotNull
    private static BufferedImage mergeLayers(@NotNull Layers layers) {
        return LauncherIconGenerator.mergeLayers(layers, null);
    }

    @NotNull
    private static BufferedImage mergeLayers(@NotNull Layers layers, @Nullable Color fillColor) {
        int width = Math.max(layers.background.getWidth(), layers.foreground.getWidth());
        int height = Math.max(layers.background.getHeight(), layers.foreground.getHeight());
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (fillColor != null) {
            gOut.setPaint(fillColor);
            gOut.fillRect(0, 0, width, height);
        }
        gOut.drawImage((Image)layers.background, 0, 0, null);
        gOut.drawImage((Image)layers.foreground, 0, 0, null);
        gOut.dispose();
        return outImage;
    }

    @NotNull
    private static Layers generateIconLayers(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        BufferedImage backgroundImage = LauncherIconGenerator.generateIconBackgroundLayer(context, options);
        BufferedImage foregroundImage = LauncherIconGenerator.generateIconForegroundLayer(context, options);
        return new Layers(backgroundImage, foregroundImage);
    }

    @Nullable
    private static BufferedImage generateMaskLayer(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options, @NotNull PreviewShape shape) {
        String maskName;
        switch (shape) {
            case CIRCLE: {
                maskName = "circle";
                break;
            }
            case SQUARE: {
                maskName = "square";
                break;
            }
            case ROUNDED_SQUARE: {
                maskName = "rounded_corner";
                break;
            }
            case SQUIRCLE: {
                maskName = "squircle";
                break;
            }
            default: {
                maskName = null;
            }
        }
        if (maskName == null) {
            return null;
        }
        if (options.generateWebIcon) {
            String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, Density.XXXHIGH.getResourceValue());
            BufferedImage mask = context.loadImageResource(resourceName);
            if (mask == null) {
                return null;
            }
            Rectangle maskRect = new Rectangle(0, 0, mask.getWidth(), mask.getHeight());
            float scale = LauncherIconGenerator.getRectangleInsideScale(maskRect, LauncherIconGenerator.getViewportRectangle(options));
            return options.generatePreviewIcons ? LauncherIconGenerator.scaledPreviewImage(mask, scale) : LauncherIconGenerator.scaledImage(mask, scale);
        }
        String resourceName = String.format("/images/adaptive_icons_masks/adaptive_%s-%s.png", maskName, options.density.getResourceValue());
        return context.loadImageResource(resourceName);
    }

    @NotNull
    private static Rectangle getFullBleedRectangle(@NotNull LauncherIconOptions options) {
        if (options.generateWebIcon) {
            return IMAGE_SIZE_FULL_BLEED_WEB_PX;
        }
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_FULL_BLEED_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
    }

    @NotNull
    private static Rectangle getViewportRectangle(@NotNull LauncherIconOptions options) {
        if (options.generateWebIcon) {
            return IMAGE_SIZE_VIEW_PORT_WEB_PX;
        }
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_VIEWPORT_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
    }

    @NotNull
    private static Rectangle getLegacyRectangle(@NotNull LauncherIconOptions options) {
        if (options.generateWebIcon) {
            return IMAGE_SIZE_VIEW_PORT_WEB_PX;
        }
        return AssetStudioUtils.scaleRectangle(IMAGE_SIZE_LEGACY_DP, LauncherIconGenerator.getMdpiScaleFactor(options.density));
    }

    @NotNull
    private static BufferedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        Rectangle imageRect = LauncherIconGenerator.getFullBleedRectangle(options);
        if (options.backgroundImage != null) {
            return LauncherIconGenerator.generateIconLayer(context, options.backgroundImage, imageRect, false, 0, !options.generateOutputIcons);
        }
        return LauncherIconGenerator.generateFlatColorRectangle(new Color(options.backgroundColor), imageRect);
    }

    @NotNull
    private static BufferedImage generateIconForegroundLayer(@NotNull GraphicGeneratorContext context, @NotNull LauncherIconOptions options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        Rectangle imageRect = LauncherIconGenerator.getFullBleedRectangle(options);
        if (options.foregroundImage != null) {
            return LauncherIconGenerator.generateIconLayer(context, options.foregroundImage, imageRect, options.useForegroundColor, options.foregroundColor, !options.generateOutputIcons);
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateFlatColorRectangle(@NotNull Color color, @NotNull Rectangle imageRect) {
        BufferedImage result2 = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)result2.getGraphics();
        gTemp.setPaint(color);
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        gTemp.dispose();
        return result2;
    }

    @NotNull
    private static BufferedImage applyMask(@NotNull BufferedImage image, @Nullable BufferedImage mask) {
        if (mask == null) {
            return image;
        }
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)mask, (Rectangle)imageRect);
        gTemp.setComposite(AlphaComposite.SrcIn);
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)image, (Rectangle)imageRect);
        gTemp.dispose();
        return tempImage;
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull TransformedImageAsset sourceImage, @NotNull Rectangle imageRect, boolean useFillColor, int fillColor, boolean forPreview) {
        String scaledDrawable = sourceImage.getTransformedDrawable();
        if (scaledDrawable != null) {
            return LauncherIconGenerator.generateIconLayer(context, scaledDrawable, imageRect);
        }
        BufferedImage trimmedImage = sourceImage.getTrimmedImage();
        if (trimmedImage != null) {
            return LauncherIconGenerator.generateIconLayer(context, trimmedImage, imageRect, sourceImage.getScaleFactor(), useFillColor, fillColor, forPreview);
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull String xmlDrawable, @NotNull Rectangle imageRect) {
        Future<BufferedImage> imageFuture = context.renderDrawable(xmlDrawable, imageRect.getSize());
        try {
            BufferedImage image = imageFuture.get();
            if (image != null) {
                return image;
            }
        }
        catch (ExecutionException e) {
            ExceptionUtilRt.rethrow((Throwable)e.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor, boolean forPreview) {
        if (forPreview && (double)Math.max(sourceImage.getWidth(), sourceImage.getHeight()) > IMAGE_SIZE_FULL_BLEED_WEB_PX.getWidth() * 1.2) {
            sourceImage = LauncherIconGenerator.generateIconLayer(context, sourceImage, IMAGE_SIZE_FULL_BLEED_WEB_PX, 1.0, false, 0);
        }
        return LauncherIconGenerator.generateIconLayer(context, sourceImage, imageRect, scaleFactor, useFillColor, fillColor);
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor) {
        Callable<Future> generator = () -> FutureUtils.executeOnPooledThread(() -> {
            BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
            Rectangle rect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scaleFactor);
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)rect);
            gIcon.dispose();
            if (!useFillColor) {
                return iconImage;
            }
            BufferedImage effectImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gEffect = (Graphics2D)effectImage.getGraphics();
            AssetUtil.Effect[] effects = new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(fillColor), 1.0)};
            AssetUtil.drawEffects((Graphics2D)gEffect, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
            gEffect.dispose();
            return effectImage;
        });
        class CacheKey {
            @NotNull
            private final Object mySource;
            @NotNull
            private final Rectangle myImageRect;
            private final int myScaleFactorTimes1000;
            private final boolean myUseFillColor;
            private final int myFillColor;

            CacheKey(@NotNull Object source, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor) {
                this.mySource = source;
                this.myImageRect = imageRect;
                this.myScaleFactorTimes1000 = AssetStudioUtils.roundToInt(scaleFactor * 1000.0);
                this.myUseFillColor = useFillColor;
                this.myFillColor = fillColor;
            }

            public int hashCode() {
                return Objects.hash(this.mySource, this.myImageRect, this.myScaleFactorTimes1000, this.myUseFillColor, this.myFillColor);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.mySource, other.mySource) && Objects.equals(this.myImageRect, other.myImageRect) && this.myScaleFactorTimes1000 == other.myScaleFactorTimes1000 && this.myUseFillColor == other.myUseFillColor && this.myFillColor == other.myFillColor;
            }
        }
        CacheKey cacheKey = new CacheKey(sourceImage, imageRect, scaleFactor, useFillColor, fillColor);
        Future<BufferedImage> imageFuture = context.getFromCacheOrCreate(cacheKey, generator);
        return (BufferedImage)Futures.getUnchecked(imageFuture);
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull BufferedImage image) {
        Graphics2D gOut = (Graphics2D)image.getGraphics();
        LauncherIconGenerator.drawGrid(launcherIconOptions, gOut);
        gOut.dispose();
    }

    private static void drawGrid(@NotNull LauncherIconOptions launcherIconOptions, @NotNull Graphics2D gOut) {
        if (launcherIconOptions.generateWebIcon) {
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.FULL_BLEED) {
            if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
                LauncherIconGenerator.drawFullBleedIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.previewShape == PreviewShape.LEGACY || launcherIconOptions.previewShape == PreviewShape.LEGACY_ROUND) {
            if (launcherIconOptions.showGrid) {
                LauncherIconGenerator.drawLegacyIconGrid(launcherIconOptions, gOut);
            }
            return;
        }
        if (launcherIconOptions.showGrid || launcherIconOptions.showSafeZone) {
            LauncherIconGenerator.drawAdaptiveIconGrid(launcherIconOptions, gOut);
        }
    }

    private static void drawAdaptiveIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
            int arcSize = 4;
            int rect1 = 36;
            int rect2 = 44;
            int rect3 = 52;
            g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
            g.drawRoundRect((size - rect2) / 2, (size - rect2) / 2, rect2, rect2, arcSize, arcSize);
            g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
            g.drawCenteredCircle(center, center, 18);
            g.drawCenteredCircle(center, center, 26);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, 33);
        }
    }

    private static void drawFullBleedIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_FULL_BLEED_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        if (options.showGrid) {
            g.drawRect(0, 0, size, size);
            g.drawRect(18, 18, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.width, LauncherIconGenerator.IMAGE_SIZE_VIEWPORT_DP.height);
            g.drawLine(0, 0, size, size);
            g.drawLine(size, 0, 0, size);
            g.drawLine(0, center, size, center);
            g.drawLine(center, 0, center, size);
        }
        if (options.showSafeZone) {
            g.drawCenteredCircle(center, center, LauncherIconGenerator.IMAGE_SIZE_SAFE_ZONE_DP.width / 2);
        }
    }

    private static void drawLegacyIconGrid(@NotNull LauncherIconOptions options, @NotNull Graphics2D out) {
        double scaleFactor = LauncherIconGenerator.getMdpiScaleFactor(options.density);
        int size = LauncherIconGenerator.IMAGE_SIZE_LEGACY_DP.width;
        int center = size / 2;
        Color c = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        out.setColor(c);
        out.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PrimitiveShapesHelper g = new PrimitiveShapesHelper(out, scaleFactor);
        g.drawRect(0, 0, size, size);
        g.drawLine(0, 0, size, size);
        g.drawLine(size, 0, 0, size);
        g.drawLine(0, center, size, center);
        g.drawLine(center, 0, center, size);
        int arcSize = 3;
        int rect1 = 32;
        int rect3 = 44;
        g.drawRoundRect((size - rect1) / 2, (size - rect3) / 2, rect1, rect3, arcSize, arcSize);
        g.drawRoundRect((size - rect3) / 2, (size - rect1) / 2, rect3, rect1, arcSize, arcSize);
        g.drawCenteredCircle(center, center, 10);
        g.drawCenteredCircle(center, center, 22);
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    @NotNull
    protected String getIconPath(@NotNull IconGenerator.Options options, @NotNull String iconName) {
        if (((LauncherIconOptions)options).generateWebIcon) {
            return iconName + "-web.png";
        }
        return super.getIconPath(options, iconName);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(LauncherIconGenerator.class);
    }

    private static class Layers {
        @NotNull
        public BufferedImage background;
        @NotNull
        public BufferedImage foreground;

        Layers(@NotNull BufferedImage background, @NotNull BufferedImage foreground) {
            this.background = background;
            this.foreground = foreground;
        }
    }

    public static enum PreviewShape {
        NONE("none", "none"),
        CIRCLE("circle", "Circle"),
        SQUIRCLE("squircle", "Squircle"),
        ROUNDED_SQUARE("rounded-square", "Rounded Square"),
        SQUARE("square", "Square"),
        FULL_BLEED("full-bleed-layers", "Full Bleed Layers"),
        LEGACY("legacy", "Legacy Icon"),
        LEGACY_ROUND("legacy-round", "Round Icon"),
        WEB("web", "Google Play Store");

        public final String id;
        public final String displayName;

        private PreviewShape(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }
    }

    public static class LauncherIconOptions
    extends IconGenerator.Options
    implements Cloneable {
        public String foregroundLayerName;
        public String backgroundLayerName;
        public boolean useForegroundColor = true;
        public int foregroundColor = 0;
        @Nullable
        public TransformedImageAsset foregroundImage;
        public int backgroundColor = 0;
        @Nullable
        public TransformedImageAsset backgroundImage;
        public boolean generateLegacyIcon = true;
        public boolean generateRoundIcon = true;
        public boolean generateWebIcon;
        public PreviewShape previewShape = PreviewShape.NONE;
        public Density previewDensity;
        public IconGenerator.Shape legacyIconShape = IconGenerator.Shape.SQUARE;
        public IconGenerator.Shape webIconShape = IconGenerator.Shape.SQUARE;
        public boolean showGrid;
        public boolean showSafeZone;

        public LauncherIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public LauncherIconOptions clone() {
            return (LauncherIconOptions)super.clone();
        }
    }
}

