/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LauncherLegacyIconGenerator
extends IconGenerator {
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    public static final IconGenerator.Shape DEFAULT_ICON_SHAPE = IconGenerator.Shape.SQUARE;
    private static final Rectangle IMAGE_SIZE_WEB = new Rectangle(0, 0, 512, 512);
    private static final Rectangle IMAGE_SIZE_MDPI = new Rectangle(0, 0, 48, 48);
    private static final Map<Pair<IconGenerator.Shape, Density>, Rectangle> TARGET_RECTS = LauncherLegacyIconGenerator.buildTargetRectangles();
    private final ObjectProperty<Color> myBackgroundColor = new ObjectValueProperty<Color>(DEFAULT_BACKGROUND_COLOR);
    private final ObjectProperty<IconGenerator.Shape> myShape = new ObjectValueProperty<IconGenerator.Shape>(DEFAULT_ICON_SHAPE);
    private final BoolProperty myCropped = new BoolValueProperty();
    private final BoolProperty myDogEared = new BoolValueProperty();

    public LauncherLegacyIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer));
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        return this.myBackgroundColor;
    }

    @NotNull
    public BoolProperty cropped() {
        return this.myCropped;
    }

    @NotNull
    public ObjectProperty<IconGenerator.Shape> shape() {
        return this.myShape;
    }

    @NotNull
    public BoolProperty dogEared() {
        return this.myDogEared;
    }

    @Override
    @NotNull
    public LauncherLegacyOptions createOptions(boolean forPreview) {
        LauncherLegacyOptions options = new LauncherLegacyOptions(forPreview);
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            Color color;
            double paddingFactor = (double)((Integer)asset.paddingPercent().get()).intValue() / 100.0;
            double scaleFactor = 1.0 / (1.0 + paddingFactor * 2.0);
            options.useForegroundColor = asset.isColorable();
            Color color2 = color = asset.isColorable() ? (Color)asset.color().getValueOrNull() : null;
            if (color != null) {
                options.foregroundColor = color.getRGB();
            }
            options.image = new TransformedImageAsset(asset, IMAGE_SIZE_MDPI.getSize(), scaleFactor, color, this.getGraphicGeneratorContext());
        }
        options.shape = (IconGenerator.Shape)((Object)this.myShape.get());
        options.crop = (Boolean)this.myCropped.get();
        options.style = IconGenerator.Style.SIMPLE;
        options.backgroundColor = ((Color)this.myBackgroundColor.get()).getRGB();
        options.generateWebIcon = true;
        options.isDogEar = (Boolean)this.myDogEared.get();
        return options;
    }

    private static IconGenerator.Shape applyDog(IconGenerator.Shape shape) {
        if (shape == IconGenerator.Shape.SQUARE) {
            return IconGenerator.Shape.SQUARE_DOG;
        }
        if (shape == IconGenerator.Shape.HRECT) {
            return IconGenerator.Shape.HRECT_DOG;
        }
        if (shape == IconGenerator.Shape.VRECT) {
            return IconGenerator.Shape.VRECT_DOG;
        }
        return shape;
    }

    @Nullable
    private static BufferedImage loadImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Shape shape, @NotNull Density density, @NotNull String fileName) {
        String densityValue = density == Density.NODPI ? "web" : density.getResourceValue();
        String name = String.format("/images/launcher_stencil/%s/%s/%s.png", shape.id, densityValue, fileName);
        return context.loadImageResource(name);
    }

    @Nullable
    public static BufferedImage loadMaskImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Shape shape, @NotNull Density density) {
        return LauncherLegacyIconGenerator.loadImage(context, shape, density, "mask");
    }

    @Nullable
    public static BufferedImage loadBackImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Shape shape, @NotNull Density density) {
        return LauncherLegacyIconGenerator.loadImage(context, shape, density, "back");
    }

    @Nullable
    public static BufferedImage loadStyleImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Shape shape, @NotNull Density density, @NotNull IconGenerator.Style style) {
        return LauncherLegacyIconGenerator.loadImage(context, shape, density, style.id);
    }

    @NotNull
    public static Rectangle getTargetRect(@Nullable IconGenerator.Shape shape, @NotNull Density density) {
        Rectangle targetRect = TARGET_RECTS.get(Pair.of((Object)((Object)shape), (Object)density));
        if (targetRect == null) {
            targetRect = AssetStudioUtils.scaleRectangle(TARGET_RECTS.get(Pair.of((Object)((Object)shape), (Object)Density.MEDIUM)), LauncherLegacyIconGenerator.getMdpiScaleFactor(density));
        }
        return targetRect;
    }

    @Override
    @NotNull
    public BufferedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options) {
        Rectangle imageRect;
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        LauncherLegacyOptions launcherOptions = (LauncherLegacyOptions)options;
        Rectangle rectangle = imageRect = launcherOptions.generateWebIcon ? IMAGE_SIZE_WEB : AssetStudioUtils.scaleRectangle(IMAGE_SIZE_MDPI, LauncherLegacyIconGenerator.getMdpiScaleFactor(launcherOptions.density));
        if (launcherOptions.isDogEar) {
            launcherOptions.shape = LauncherLegacyIconGenerator.applyDog(launcherOptions.shape);
        }
        BufferedImage shapeImageBack = null;
        BufferedImage shapeImageFore = null;
        BufferedImage shapeImageMask = null;
        if (launcherOptions.shape != IconGenerator.Shape.NONE && launcherOptions.shape != null && launcherOptions.renderShape) {
            Density loadImageDensity = launcherOptions.generateWebIcon ? Density.NODPI : launcherOptions.density;
            shapeImageBack = LauncherLegacyIconGenerator.loadBackImage(context, launcherOptions.shape, loadImageDensity);
            shapeImageFore = LauncherLegacyIconGenerator.loadStyleImage(context, launcherOptions.shape, loadImageDensity, launcherOptions.style);
            shapeImageMask = LauncherLegacyIconGenerator.loadMaskImage(context, launcherOptions.shape, loadImageDensity);
        }
        Rectangle targetRect = LauncherLegacyIconGenerator.getTargetRect(launcherOptions.shape, launcherOptions.density);
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        gTemp.setPaint(new Color(launcherOptions.backgroundColor));
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        BufferedImage sourceImage = this.generateRasterImage(targetRect.getSize(), options);
        BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
        if (launcherOptions.crop) {
            AssetUtil.drawCenterCrop((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)targetRect);
        } else {
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)targetRect);
        }
        AssetUtil.Effect[] effects = launcherOptions.useForegroundColor ? new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(launcherOptions.foregroundColor), 1.0)} : AssetUtil.NO_EFFECTS;
        AssetUtil.drawEffects((Graphics2D)gTemp, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
        if (shapeImageMask != null) {
            gTemp.setComposite(AlphaComposite.DstIn);
            gTemp.drawImage((Image)shapeImageMask, 0, 0, null);
        }
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (shapeImageBack != null) {
            gOut.drawImage((Image)shapeImageBack, 0, 0, null);
        }
        gOut.drawImage((Image)tempImage, 0, 0, null);
        if (shapeImageFore != null) {
            gOut.drawImage((Image)shapeImageFore, 0, 0, null);
        }
        gOut.dispose();
        gTemp.dispose();
        gIcon.dispose();
        return outImage;
    }

    @Override
    protected boolean includeDensity(@NotNull Density density) {
        return super.includeDensity(density) || density == Density.XXXHIGH;
    }

    @Override
    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options, @NotNull String name) {
        LauncherLegacyOptions launcherOptions = (LauncherLegacyOptions)options;
        boolean generateWebImage = launcherOptions.generateWebIcon;
        launcherOptions.generateWebIcon = false;
        super.generateRasterImage(category, categoryMap, context, options, name);
        if (generateWebImage) {
            launcherOptions.generateWebIcon = true;
            launcherOptions.density = Density.NODPI;
            BufferedImage image = this.generateRasterImage(context, options);
            HashMap<String, BufferedImage> imageMap = new HashMap<String, BufferedImage>();
            categoryMap.put("Web", imageMap);
            imageMap.put(this.getIconPath(options, name), image);
        }
    }

    @Override
    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options, @NotNull String name) {
        HashMap<String, Map<String, BufferedImage>> categoryMap = new HashMap<String, Map<String, BufferedImage>>();
        this.generateRasterImage(null, categoryMap, context, options, name);
        ArrayList<GeneratedIcon> icons = new ArrayList<GeneratedIcon>();
        categoryMap.forEach((category, images) -> images.forEach((path, image) -> {
            IconCategory iconCategory = IconCategory.REGULAR;
            Density density = LauncherLegacyIconGenerator.pathToDensity(path);
            if (density == null) {
                density = Density.NODPI;
                iconCategory = IconCategory.WEB;
            }
            GeneratedImageIcon icon2 = new GeneratedImageIcon((String)path, new PathString(path), iconCategory, density, (BufferedImage)image);
            icons.add(icon2);
        }));
        return icons;
    }

    @Override
    @NotNull
    protected String getIconPath(@NotNull IconGenerator.Options options, @NotNull String iconName) {
        if (((LauncherLegacyOptions)options).generateWebIcon) {
            return iconName + "-web.png";
        }
        return super.getIconPath(options, iconName);
    }

    private static Map<Pair<IconGenerator.Shape, Density>, Rectangle> buildTargetRectangles() {
        ImmutableMap.Builder targetRects = new ImmutableMap.Builder();
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.NONE), (Object)Density.NODPI), (Object)new Rectangle(32, 32, 448, 448));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.NONE), (Object)Density.HIGH), (Object)new Rectangle(4, 4, 64, 64));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.NONE), (Object)Density.MEDIUM), (Object)new Rectangle(3, 3, 42, 42));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.CIRCLE), (Object)Density.NODPI), (Object)new Rectangle(21, 21, 470, 470));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.CIRCLE), (Object)Density.HIGH), (Object)new Rectangle(3, 3, 66, 66));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.CIRCLE), (Object)Density.MEDIUM), (Object)new Rectangle(2, 2, 44, 44));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE), (Object)Density.NODPI), (Object)new Rectangle(53, 53, 406, 406));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE), (Object)Density.HIGH), (Object)new Rectangle(7, 7, 57, 57));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE), (Object)Density.MEDIUM), (Object)new Rectangle(5, 5, 38, 38));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT), (Object)Density.NODPI), (Object)new Rectangle(85, 21, 342, 470));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT), (Object)Density.HIGH), (Object)new Rectangle(12, 3, 48, 66));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT), (Object)Density.MEDIUM), (Object)new Rectangle(8, 2, 32, 44));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT), (Object)Density.NODPI), (Object)new Rectangle(21, 85, 470, 342));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT), (Object)Density.HIGH), (Object)new Rectangle(3, 12, 66, 48));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT), (Object)Density.MEDIUM), (Object)new Rectangle(2, 8, 44, 32));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE_DOG), (Object)Density.NODPI), (Object)new Rectangle(53, 149, 406, 312));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE_DOG), (Object)Density.HIGH), (Object)new Rectangle(7, 21, 57, 43));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.SQUARE_DOG), (Object)Density.MEDIUM), (Object)new Rectangle(5, 14, 38, 29));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT_DOG), (Object)Density.NODPI), (Object)new Rectangle(85, 117, 342, 374));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT_DOG), (Object)Density.HIGH), (Object)new Rectangle(12, 17, 48, 52));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.VRECT_DOG), (Object)Density.MEDIUM), (Object)new Rectangle(8, 11, 32, 35));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT_DOG), (Object)Density.NODPI), (Object)new Rectangle(21, 85, 374, 342));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT_DOG), (Object)Density.HIGH), (Object)new Rectangle(3, 12, 52, 48));
        targetRects.put((Object)Pair.of((Object)((Object)IconGenerator.Shape.HRECT_DOG), (Object)Density.MEDIUM), (Object)new Rectangle(2, 8, 35, 32));
        return targetRects.build();
    }

    public static class LauncherLegacyOptions
    extends IconGenerator.Options {
        public boolean useForegroundColor = true;
        public int foregroundColor;
        public int backgroundColor;
        public boolean crop = true;
        public IconGenerator.Shape shape = IconGenerator.Shape.SQUARE;
        public IconGenerator.Style style = IconGenerator.Style.SIMPLE;
        public boolean isDogEar;
        public boolean renderShape = true;
        public boolean generateWebIcon;

        public LauncherLegacyOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }
    }
}

