/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationIconGenerator
extends IconGenerator {
    private static final Dimension ICON_SIZE = new Dimension(24, 24);

    public NotificationIconGenerator(@NotNull Project project, int minSdkVersion2, @Nullable DrawableRenderer renderer) {
        super(project, minSdkVersion2, new GraphicGeneratorContext(40, renderer));
    }

    @Override
    @NotNull
    public IconGenerator.Options createOptions(boolean forPreview) {
        IconGenerator.Options options = new IconGenerator.Options(forPreview);
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            double paddingFactor = (double)((Integer)asset.paddingPercent().get()).intValue() / 100.0 + 1.0 / (double)(NotificationIconGenerator.ICON_SIZE.width - 1);
            double scaleFactor = 1.0 / (1.0 + paddingFactor * 2.0);
            options.image = new TransformedImageAsset(asset, ICON_SIZE, scaleFactor, Color.WHITE, this.getGraphicGeneratorContext());
        }
        return options;
    }

    @Override
    @NotNull
    public BufferedImage generateRasterImage(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options) {
        return this.generateRasterImage(ICON_SIZE, options);
    }

    @Override
    protected int calculateMinRequiredApiLevel(@NotNull String xmlDrawableText, int minSdk) {
        if (minSdk < 24) {
            return 24;
        }
        return 0;
    }
}

