/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.google.common.util.concurrent.Futures;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransformedImageAsset {
    @Nullable
    private final Future<BufferedImage> myImageFuture;
    @Nullable
    private final Future<String> myDrawableFuture;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @Nullable
    private final Color myTint;
    private final double myOpacity;
    private final boolean myIsTrimmed;
    @NotNull
    private final Dimension myTargetSize;
    private final double myScaleFactor;
    @Nullable
    private Rectangle2D myTrimRectangle;
    @GuardedBy(value="myLock")
    @Nullable
    private String myTransformedDrawable;
    @GuardedBy(value="myLock")
    @Nullable
    private BufferedImage myTrimmedImage;
    private final Object myLock = new Object();

    public TransformedImageAsset(@NotNull BaseAsset asset, @NotNull Dimension targetSize, double scaleFactor, @Nullable Color tint, @NotNull GraphicGeneratorContext context) {
        this.myDrawableFuture = asset instanceof ImageAsset ? ((ImageAsset)asset).getXmlDrawable() : null;
        this.myImageFuture = this.myDrawableFuture == null ? asset.toImage() : null;
        this.myTint = tint;
        this.myOpacity = (double)((Integer)asset.opacityPercent().get()).intValue() / 100.0;
        this.myIsTrimmed = (Boolean)asset.trimmed().get();
        this.myTargetSize = targetSize;
        this.myScaleFactor = scaleFactor;
        this.myContext = context;
    }

    public boolean isDrawable() {
        return this.myDrawableFuture != null;
    }

    public boolean isRasterImage() {
        return this.myImageFuture != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getTransformedDrawable() {
        if (this.myDrawableFuture == null) {
            return null;
        }
        try {
            Object object = this.myLock;
            synchronized (object) {
                String xmlDrawable = this.myDrawableFuture.get();
                if (xmlDrawable == null) {
                    return null;
                }
                if (this.myTransformedDrawable == null) {
                    Rectangle2D clipRectangle = this.myIsTrimmed ? this.getTrimRectangle(xmlDrawable) : null;
                    this.myTransformedDrawable = VectorDrawableTransformer.transform(xmlDrawable, this.myTargetSize, this.myScaleFactor, clipRectangle, this.myTint, this.myOpacity);
                }
                return this.myTransformedDrawable;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @NotNull
    public BufferedImage getTransformedImage(@NotNull Dimension imageSize) {
        AssetUtil.Effect[] effectArray;
        BufferedImage sourceImage;
        String drawable;
        if (this.isDrawable() && (drawable = this.getTransformedDrawable()) != null) {
            Future<BufferedImage> future2 = this.myContext.renderDrawable(drawable, imageSize);
            try {
                return future2.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        if ((sourceImage = this.getTrimmedImage()) == null) {
            sourceImage = AssetStudioUtils.createDummyImage();
        }
        double scaleFactor = Math.min(imageSize.getWidth() * this.myScaleFactor / (double)sourceImage.getWidth(), imageSize.getHeight() * this.myScaleFactor / (double)sourceImage.getHeight());
        int width = AssetStudioUtils.roundToInt((double)sourceImage.getWidth() * scaleFactor);
        int height = AssetStudioUtils.roundToInt((double)sourceImage.getHeight() * scaleFactor);
        BufferedImage scaledImage = AssetUtil.scaledImage((BufferedImage)sourceImage, (int)width, (int)height);
        int x = AssetStudioUtils.roundToInt((double)(imageSize.width - width) / 2.0);
        int y = AssetStudioUtils.roundToInt((double)(imageSize.height - height) / 2.0);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageSize.width, (int)imageSize.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        if (this.myTint == null || this.myOpacity == 0.0) {
            effectArray = AssetUtil.NO_EFFECTS;
        } else {
            AssetUtil.FillEffect[] fillEffectArray = new AssetUtil.FillEffect[1];
            effectArray = fillEffectArray;
            fillEffectArray[0] = new AssetUtil.FillEffect((Paint)this.myTint, this.myOpacity);
        }
        AssetUtil.Effect[] effects = effectArray;
        AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)scaledImage, (int)x, (int)y, (AssetUtil.Effect[])effects);
        g.dispose();
        return outImage;
    }

    public double getScaleFactor() {
        return this.myScaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BufferedImage getTrimmedImage() {
        if (this.myImageFuture == null) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTrimmedImage == null) {
                try {
                    BufferedImage image = this.myImageFuture.get();
                    this.myTrimmedImage = this.myIsTrimmed ? AssetStudioUtils.trim(image) : image;
                }
                catch (InterruptedException | ExecutionException e) {
                    return null;
                }
            }
            return this.myTrimmedImage;
        }
    }

    @NotNull
    private Rectangle2D getTrimRectangle(@NotNull String xmlDrawable) {
        if (this.myTrimRectangle == null) {
            this.myTrimRectangle = this.calculateTrimRectangle(xmlDrawable);
        }
        return this.myTrimRectangle;
    }

    @NotNull
    private Rectangle2D calculateTrimRectangle(@NotNull String xmlDrawable) {
        Future<BufferedImage> futureImage = this.myContext.renderDrawable(xmlDrawable, this.myTargetSize);
        Future rectangleFuture = Futures.lazyTransform(futureImage, image -> {
            Rectangle bounds = ImageUtils.getCropBounds((BufferedImage)image, (ImageUtils.CropFilter)ImageUtils.TRANSPARENCY_FILTER, null);
            if (bounds == null) {
                return new Rectangle(this.myTargetSize);
            }
            double width = this.myTargetSize.getWidth();
            double height = this.myTargetSize.getHeight();
            return new Rectangle2D.Double(bounds.getX() / width, bounds.getY() / height, bounds.getWidth() / width, bounds.getHeight() / height);
        });
        try {
            return (Rectangle2D)rectangleFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return new Rectangle(this.myTargetSize);
        }
    }
}

