/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.CharSequences;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableSet;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawableTransformer {
    private static final ImmutableSet<String> NAMES_OF_HANDLED_ATTRIBUTES = ImmutableSet.of((Object)"width", (Object)"height", (Object)"viewportWidth", (Object)"viewportHeight", (Object)"tint", (Object)"alpha", (Object[])new String[0]);
    private static final String INDENT = "  ";
    private static final String DOUBLE_INDENT = "    ";

    private VectorDrawableTransformer() {
    }

    @NotNull
    public static String transform(@NotNull String originalDrawable, @NotNull Dimension targetSize, double scaleFactor, @Nullable Rectangle2D clipRectangle, @Nullable Color tint, double opacity) {
        KXmlParser parser = new KXmlParser();
        try {
            int endColumnNumber;
            String translateY;
            String prefix;
            int i2;
            String alphaValue;
            int token;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)originalDrawable, (boolean)true));
            int startLine = 1;
            int startColumn = 1;
            while ((token = parser.nextToken()) != 1 && token != 2) {
                startLine = parser.getLineNumber();
                startColumn = parser.getColumnNumber();
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return originalDrawable;
            }
            String originalTintValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "tint");
            String tintValue = tint == null ? originalTintValue : ResourceHelper.colorToString(tint);
            String originalAlphaValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "alpha");
            if (originalAlphaValue != null) {
                opacity *= VectorDrawableTransformer.parseDoubleValue(originalAlphaValue, "");
            }
            if ((alphaValue = XmlUtils.formatFloatAttribute((double)opacity)).equals("1")) {
                alphaValue = null;
            }
            double targetWidth = targetSize.getWidth();
            double targetHeight = targetSize.getHeight();
            double width = targetWidth;
            double height = targetHeight;
            String widthValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "width");
            if (widthValue != null) {
                String suffix = VectorDrawableTransformer.getSuffix(widthValue);
                width = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "width", suffix);
                height = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "height", suffix);
                if (suffix.equals("dp") && width == targetWidth && height == targetHeight && scaleFactor == 1.0 && clipRectangle == null && Objects.equals(tintValue, originalTintValue) && Objects.equals(alphaValue, originalAlphaValue)) {
                    return originalDrawable;
                }
                if (Double.isNaN(width) || Double.isNaN(height)) {
                    width = targetWidth;
                    height = targetHeight;
                }
            }
            double originalViewportWidth = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportWidth", "");
            double originalViewportHeight = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportHeight", "");
            if (Double.isNaN(originalViewportWidth) || Double.isNaN(originalViewportHeight)) {
                originalViewportWidth = width;
                originalViewportHeight = height;
            }
            double viewportWidth = originalViewportWidth;
            double viewportHeight = originalViewportHeight;
            double x = 0.0;
            double y = 0.0;
            double ratio = targetWidth * height / (targetHeight * width);
            if (ratio > 1.0) {
                viewportWidth *= ratio;
            } else if (ratio < 1.0) {
                viewportHeight /= ratio;
            }
            viewportWidth /= scaleFactor;
            viewportHeight /= scaleFactor;
            if (clipRectangle != null) {
                double s = Math.max(clipRectangle.getWidth(), clipRectangle.getHeight());
                x = (0.5 - clipRectangle.getCenterX()) * (viewportWidth *= s);
                y = (0.5 - clipRectangle.getCenterY()) * (viewportHeight *= s);
            }
            x += (viewportWidth - originalViewportWidth) / 2.0;
            y += (viewportHeight - originalViewportHeight) / 2.0;
            StringBuilder result2 = new StringBuilder(originalDrawable.length() + originalDrawable.length() / 8);
            Indenter indenter = new Indenter(originalDrawable);
            indenter.copy(1, 1, startLine, startColumn, "", result2);
            String lineSeparator = VectorDrawableTransformer.detectLineSeparator(originalDrawable);
            result2.append(String.format("<vector %s:%s=\"%s\"", "xmlns", "android", "http://schemas.android.com/apk/res/android"));
            for (i2 = 0; i2 < parser.getNamespaceCount(1); ++i2) {
                prefix = parser.getNamespacePrefix(i2);
                String uri = parser.getNamespaceUri(i2);
                if ("android".equals(prefix) && "http://schemas.android.com/apk/res/android".equals(uri)) continue;
                result2.append(String.format("%s%s%s:%s=\"%s\"", lineSeparator, DOUBLE_INDENT, "xmlns", prefix, uri));
            }
            result2.append(String.format("%s%sandroid:width=\"%sdp\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatAttribute((double)targetWidth)));
            result2.append(String.format("%s%sandroid:height=\"%sdp\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatAttribute((double)targetHeight)));
            result2.append(String.format("%s%sandroid:viewportWidth=\"%s\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatAttribute((double)viewportWidth)));
            result2.append(String.format("%s%sandroid:viewportHeight=\"%s\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatAttribute((double)viewportHeight)));
            if (tintValue != null) {
                result2.append(String.format("%s%sandroid:tint=\"%s\"", lineSeparator, DOUBLE_INDENT, tintValue));
            }
            if (alphaValue != null) {
                result2.append(String.format("%s%sandroid:alpha=\"%s\"", lineSeparator, DOUBLE_INDENT, alphaValue));
            }
            for (i2 = 0; i2 < parser.getAttributeCount(); ++i2) {
                prefix = parser.getAttributePrefix(i2);
                String name = parser.getAttributeName(i2);
                if ("android".equals(prefix) && NAMES_OF_HANDLED_ATTRIBUTES.contains((Object)name)) continue;
                if (prefix != null) {
                    name = prefix + ':' + name;
                }
                result2.append(String.format("%s%s%s=\"%s\"", lineSeparator, DOUBLE_INDENT, name, parser.getAttributeValue(i2)));
            }
            result2.append('>');
            String indent = "";
            String translateX = VectorDrawableTransformer.isSignificantlyDifferentFromZero(x / viewportWidth) ? XmlUtils.formatFloatAttribute((double)x) : null;
            String string = translateY = VectorDrawableTransformer.isSignificantlyDifferentFromZero(y / viewportHeight) ? XmlUtils.formatFloatAttribute((double)y) : null;
            if (translateX != null || translateY != null) {
                result2.append(lineSeparator).append(INDENT);
                result2.append("<group");
                String delimiter = " ";
                if (translateX != null) {
                    result2.append(String.format("%sandroid:translateX=\"%s\"", delimiter, translateX));
                    delimiter = lineSeparator + INDENT + DOUBLE_INDENT;
                }
                if (translateY != null) {
                    result2.append(String.format("%sandroid:translateY=\"%s\"", delimiter, translateY));
                }
                result2.append('>');
                indent = INDENT;
            }
            startLine = parser.getLineNumber();
            startColumn = parser.getColumnNumber();
            while ((token = parser.nextToken()) != 1 && token != 3 || parser.getDepth() > 1) {
                int endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, token == 5 ? "" : indent, result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            if (startColumn != 1) {
                result2.append(lineSeparator);
            }
            if (translateX != null || translateY != null) {
                result2.append(INDENT).append(String.format("</group>%s", lineSeparator));
            }
            while (parser.nextToken() != 1) {
                int endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            return result2.toString();
        }
        catch (IOException | XmlPullParserException e) {
            return originalDrawable;
        }
    }

    private static String detectLineSeparator(CharSequence str) {
        LineSeparator separator = StringUtil.detectSeparators((CharSequence)str);
        if (separator != null) {
            return separator.getSeparatorString();
        }
        return CodeStyle.getDefaultSettings().getLineSeparator();
    }

    private static double getDoubleAttributeValue(@NotNull KXmlParser parser, @NotNull String namespaceUri, @NotNull String attributeName, @NotNull String expectedSuffix) {
        String value2 = parser.getAttributeValue(namespaceUri, attributeName);
        return VectorDrawableTransformer.parseDoubleValue(value2, expectedSuffix);
    }

    private static double parseDoubleValue(String value2, @NotNull String expectedSuffix) {
        if (value2 == null || !value2.endsWith(expectedSuffix)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(value2.substring(0, value2.length() - expectedSuffix.length()));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @NotNull
    private static String getSuffix(@NotNull String value2) {
        int i2 = value2.length();
        while (--i2 >= 0 && !Character.isDigit(value2.charAt(i2))) {
        }
        return value2.substring(++i2);
    }

    private static boolean isSignificantlyDifferentFromZero(double value2) {
        return Math.abs(value2) >= 1.0E-6;
    }

    private static class Indenter {
        private int myLine;
        private int myColumn;
        private int myOffset;
        private final CharSequence myText;

        Indenter(CharSequence text) {
            this.myText = text;
            this.myLine = 1;
            this.myColumn = 1;
        }

        void copy(int fromLine, int fromColumn, int toLine, int toColumn, String indent, StringBuilder out) {
            char c;
            if (this.myLine != fromLine) {
                if (this.myLine > fromLine) {
                    this.myLine = 1;
                    this.myColumn = 1;
                    this.myOffset = 0;
                }
                while (this.myLine < fromLine) {
                    c = this.myText.charAt(this.myOffset);
                    if (c == '\n') {
                        ++this.myLine;
                        this.myColumn = 1;
                    } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                        ++this.myColumn;
                    }
                    ++this.myOffset;
                }
            }
            this.myOffset += fromColumn - this.myColumn;
            this.myColumn = fromColumn;
            while (this.myLine < toLine || this.myLine == toLine && this.myColumn < toColumn) {
                c = this.myText.charAt(this.myOffset);
                if (c == '\n') {
                    ++this.myLine;
                    this.myColumn = 1;
                } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                    if (this.myColumn == 1) {
                        out.append(indent);
                    }
                    ++this.myColumn;
                }
                ++this.myOffset;
                out.append(c);
            }
        }
    }
}

