/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.GuardedBy;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageAsset
extends BaseAsset {
    @NotNull
    private final OptionalValueProperty<File> myImagePath;
    @NotNull
    private final ObservableBool myIsResizable;
    @NotNull
    private final BoolValueProperty myXmlDrawableIsResizable = new BoolValueProperty();
    @NotNull
    private final ObjectValueProperty<Validator.Result> myValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    @NotNull
    private String myRole = "an image file";
    private boolean isClipart;
    @NotNull
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    @Nullable
    private File myImageFile;
    @GuardedBy(value="myLock")
    @Nullable
    private ListenableFuture<String> myXmlDrawableFuture;
    @GuardedBy(value="myLock")
    @Nullable
    private ListenableFuture<BufferedImage> myImageFuture;

    public ImageAsset() {
        this.myImagePath = new OptionalValueProperty();
        this.myImagePath.addListener(() -> {
            this.myXmlDrawableIsResizable.set(false);
            Object object = this.myLock;
            synchronized (object) {
                this.myImageFile = (File)this.myImagePath.getValueOrNull();
                this.myXmlDrawableFuture = null;
                this.myImageFuture = null;
            }
        });
        this.myIsResizable = new BooleanExpression(new ObservableValue[]{this.myImagePath, this.myXmlDrawableIsResizable}){

            @Override
            @NotNull
            public Boolean get() {
                FileType fileType = ImageAsset.getFileType((File)ImageAsset.this.myImagePath.getValueOrNull());
                if (fileType == null) {
                    return false;
                }
                if (fileType == FileType.RASTER_IMAGE_CANDIDATE) {
                    return true;
                }
                ImageAsset.this.getXmlDrawable();
                return ImageAsset.this.myXmlDrawableIsResizable.get();
            }
        };
    }

    public void setRole(@NotNull String role) {
        this.myRole = role;
    }

    public void setClipart(boolean clipart) {
        this.isClipart = clipart;
    }

    public boolean isClipart() {
        return this.isClipart;
    }

    @Override
    public boolean isColorable() {
        return this.isClipart;
    }

    @NotNull
    public OptionalValueProperty<File> imagePath() {
        return this.myImagePath;
    }

    @Override
    @NotNull
    public ObservableBool isResizable() {
        return this.myIsResizable;
    }

    @NotNull
    public ObjectValueProperty<Validator.Result> getValidityState() {
        return this.myValidityState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myImageFuture == null) {
                File file = this.myImageFile;
                if (file == null || ImageAsset.isVectorGraphics(FileType.fromFile(file))) {
                    return null;
                }
                this.myImageFuture = FutureUtils.executeOnPooledThread(() -> this.loadImage(file));
            }
            return this.myImageFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ListenableFuture<String> getXmlDrawable() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myXmlDrawableFuture == null) {
                if (this.myImageFile == null) {
                    return null;
                }
                FileType fileType = FileType.fromFile(this.myImageFile);
                if (!ImageAsset.isVectorGraphics(fileType)) {
                    return null;
                }
                File file = this.myImageFile;
                this.myXmlDrawableFuture = FutureUtils.executeOnPooledThread(() -> this.loadXmlDrawable(file));
            }
            return this.myXmlDrawableFuture;
        }
    }

    @Nullable
    private String loadXmlDrawable(@NotNull File file) {
        String xmlText = null;
        Validator.Result validityState = this.checkFileExistence(file);
        if (validityState.getSeverity() == Validator.Severity.OK) {
            FileType fileType = FileType.fromFile(file);
            try {
                switch (fileType) {
                    case XML_DRAWABLE: {
                        xmlText = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
                        break;
                    }
                    case SVG: {
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        String message2 = Svg2Vector.parseSvgToXml((File)file, (OutputStream)outStream);
                        xmlText = outStream.toString(StandardCharsets.UTF_8.name());
                        if (xmlText.isEmpty()) {
                            xmlText = null;
                        }
                        if (message2.isEmpty()) break;
                        validityState = new Validator.Result(xmlText == null ? Validator.Severity.ERROR : Validator.Severity.WARNING, message2);
                        break;
                    }
                    case LAYERED_IMAGE: {
                        xmlText = new LayeredImageConverter().toVectorDrawableXml(file);
                        break;
                    }
                }
            }
            catch (IOException e) {
                validityState = Validator.Result.fromThrowable((Throwable)e);
            }
        }
        if (xmlText == null && validityState.getSeverity() == Validator.Severity.OK) {
            validityState = Validator.Result.fromNullableMessage((String)"The specified asset could not be parsed. Please choose another asset.");
        }
        boolean resizable = xmlText != null && "vector".equals(XmlUtils.getRootTagName(xmlText));
        this.updateValidityStateAndResizability(file, validityState, resizable);
        return xmlText;
    }

    @Nullable
    private BufferedImage loadImage(@NotNull File file) {
        FileType fileType;
        BufferedImage image = null;
        Validator.Result validityState = this.checkFileExistence(file);
        if (validityState.getSeverity() == Validator.Severity.OK && (fileType = FileType.fromFile(file)) == FileType.RASTER_IMAGE_CANDIDATE) {
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                validityState = Validator.Result.fromThrowable((Throwable)e);
            }
        }
        this.updateValidityStateAndResizability(file, validityState, image != null);
        return image;
    }

    @NotNull
    private Validator.Result checkFileExistence(@NotNull File file) {
        if (!file.exists()) {
            return Validator.Result.fromNullableMessage((String)("File " + file.getName() + " does not exist"));
        }
        if (file.isDirectory()) {
            return new Validator.Result(Validator.Severity.WARNING, "Please select " + this.myRole);
        }
        return Validator.Result.OK;
    }

    private void updateValidityStateAndResizability(@NotNull File file, @NotNull Validator.Result validityState, boolean resizable) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (FileUtil.filesEqual((File)file, (File)((File)this.myImagePath.getValueOrNull()))) {
                this.myValidityState.set(validityState);
                this.myXmlDrawableIsResizable.set(resizable);
            }
        });
    }

    private static boolean isVectorGraphics(@Nullable FileType fileType) {
        return fileType == FileType.XML_DRAWABLE || fileType == FileType.SVG || fileType == FileType.LAYERED_IMAGE;
    }

    @Nullable
    private static FileType getFileType(@Nullable File file) {
        return file == null ? null : FileType.fromFile(file);
    }

    private static enum FileType {
        XML_DRAWABLE,
        SVG,
        LAYERED_IMAGE,
        RASTER_IMAGE_CANDIDATE;


        @NotNull
        static FileType fromFile(@NotNull File file) {
            String path = file.getPath();
            if (SdkUtils.endsWithIgnoreCase((String)path, (String)".xml")) {
                return XML_DRAWABLE;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path, (String)".svg")) {
                return SVG;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path, (String)".psd")) {
                return LAYERED_IMAGE;
            }
            return RASTER_IMAGE_CANDIDATE;
        }
    }
}

