/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.tools.idea.npw.assetstudio.TextRenderUtil;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAsset
extends BaseAsset {
    public static final String DEFAULT_TEXT = "Aa";
    private static final String PREFERRED_FONT = "Roboto";
    private static final int FONT_SIZE = 144;
    private final StringProperty myText = new StringValueProperty("Aa");
    private final StringProperty myFontFamily = new StringValueProperty();
    private final List<String> myAllFontFamilies = ImmutableList.copyOf((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());

    public TextAsset() {
        this.selectFontFamily(PREFERRED_FONT);
    }

    private void selectFontFamily(@NotNull String fontFamily) {
        if (this.myAllFontFamilies.contains(fontFamily)) {
            this.myFontFamily.set(fontFamily);
        } else if (!this.myAllFontFamilies.isEmpty()) {
            this.myFontFamily.set(this.myAllFontFamilies.get(0));
        }
    }

    @NotNull
    public static List<String> getAllFontFamilies() {
        return ImmutableList.copyOf((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    @NotNull
    public StringProperty text() {
        return this.myText;
    }

    @NotNull
    public StringProperty fontFamily() {
        return this.myFontFamily;
    }

    @NotNull
    public String defaultFontFamily() {
        if (this.myAllFontFamilies.contains(PREFERRED_FONT)) {
            return PREFERRED_FONT;
        }
        return this.myAllFontFamilies.isEmpty() ? "" : this.myAllFontFamilies.get(0);
    }

    @Override
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        TextRenderUtil.Options options = new TextRenderUtil.Options();
        options.font = Font.decode(this.myFontFamily + " " + 144);
        options.foregroundColor = this.color().getValueOr(Color.BLACK).getRGB();
        return Futures.immediateFuture((Object)TextRenderUtil.renderTextImage((String)this.myText.get(), 1, options));
    }
}

