/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class CategoryIconMap {
    public static final Filter ACCEPT_ALL = category -> true;
    @NotNull
    private final Map<String, Map<String, BufferedImage>> myCategoryMap;

    public CategoryIconMap(@NotNull Map<String, Map<String, BufferedImage>> categoryMap) {
        this.myCategoryMap = categoryMap;
    }

    @NotNull
    public Map<Density, BufferedImage> toDensityMap() {
        return this.toDensityMap(ACCEPT_ALL);
    }

    @NotNull
    public Map<Density, BufferedImage> toDensityMap(@NotNull Filter filter2) {
        HashMap<Density, BufferedImage> densityImageMap = new HashMap<Density, BufferedImage>();
        for (String category : this.myCategoryMap.keySet()) {
            if (!filter2.accept(category)) continue;
            Map<String, BufferedImage> pathImageMap = this.myCategoryMap.get(category);
            for (String path : pathImageMap.keySet()) {
                Density density = IconGenerator.pathToDensity(path);
                if (density == null) continue;
                BufferedImage image = pathImageMap.get(path);
                densityImageMap.put(density, image);
            }
        }
        return densityImageMap;
    }

    @NotNull
    public Map<File, BufferedImage> toFileMap(@NotNull File rootDir) {
        HashMap<File, BufferedImage> outputMap = new HashMap<File, BufferedImage>();
        for (Map<String, BufferedImage> pathImageMap : this.myCategoryMap.values()) {
            for (Map.Entry<String, BufferedImage> pathImageEntry : pathImageMap.entrySet()) {
                outputMap.put(new File(rootDir, pathImageEntry.getKey()), pathImageEntry.getValue());
            }
        }
        return outputMap;
    }

    public static interface Filter {
        public boolean accept(@NotNull String var1);
    }
}

