/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.intellij.openapi.components.PersistentStateComponent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public final class TextAssetEditor
extends JPanel
implements AssetComponent<TextAsset>,
PersistentStateComponent<PersistentState> {
    private static final String TEXT_PROPERTY = "text";
    private static final String FONT_FAMILY_PROPERTY = "fontFamily";
    private final TextAsset myTextAsset = new TextAsset();
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myListeners = new ArrayList<ActionListener>(1);

    public TextAssetEditor() {
        super((LayoutManager)new TabularLayout("50px,180px"));
        JTextField textField2 = new JTextField();
        List<String> fontFamilies = TextAsset.getAllFontFamilies();
        JComboBox<String> fontCombo = new JComboBox<String>(fontFamilies.toArray(new String[0]));
        this.add((Component)textField2, new TabularLayout.Constraint(0, 0));
        this.add(fontCombo, new TabularLayout.Constraint(0, 1));
        this.myBindings.bindTwoWay(new TextProperty(textField2), this.myTextAsset.text());
        SelectedItemProperty selectedFont = new SelectedItemProperty(fontCombo);
        this.myBindings.bindTwoWay(ObjectProperty.wrap(selectedFont), this.myTextAsset.fontFamily());
        InvalidationListener onTextChanged = () -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener2 : this.myListeners) {
                listener2.actionPerformed(e);
            }
        };
        this.myTextAsset.text().addListener(onTextChanged);
        this.myTextAsset.fontFamily().addListener(onTextChanged);
    }

    @Override
    @NotNull
    public TextAsset getAsset() {
        return this.myTextAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        this.myListeners.add(listener2);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.clear();
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        state.set(TEXT_PROPERTY, (String)this.myTextAsset.text().get(), "Aa");
        state.set(FONT_FAMILY_PROPERTY, (String)this.myTextAsset.fontFamily().get(), this.myTextAsset.defaultFontFamily());
        return state;
    }

    public void loadState(@NotNull PersistentState state) {
        this.myTextAsset.text().set(state.get(TEXT_PROPERTY, "Aa"));
        this.myTextAsset.fontFamily().set(state.get(FONT_FAMILY_PROPERTY, this.myTextAsset.defaultFontFamily()));
    }
}

