/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.ide.common.vectordrawable.VdIcon;
import com.android.tools.idea.npw.assetstudio.MaterialDesignIcons;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.IconPickerDialog;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.observable.BindingsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VectorIconButton
extends JButton
implements AssetComponent<VectorAsset>,
Disposable,
PersistentStateComponent<PersistentState> {
    private static final String URL_PROPERTY = "url";
    private final VectorAsset myXmlAsset = new VectorAsset();
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myAssetListeners = new ArrayList<ActionListener>(1);
    @Nullable
    private VdIcon myIcon;

    public VectorIconButton() {
        this.addActionListener(actionEvent -> {
            IconPickerDialog iconPicker = new IconPickerDialog(this.myIcon);
            if (iconPicker.showAndGet()) {
                VdIcon selectedIcon = iconPicker.getSelectedIcon();
                assert (selectedIcon != null);
                this.updateIcon(selectedIcon);
            }
        });
        this.myXmlAsset.path().addListener(() -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener2 : this.myAssetListeners) {
                listener2.actionPerformed(e);
            }
        });
        this.updateIcon(VectorIconButton.createIcon(MaterialDesignIcons.getDefaultIcon()));
    }

    private void updateIcon(@Nullable VdIcon selectedIcon) {
        int h = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        if (h < 0 && selectedIcon != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.updateIcon(selectedIcon), ModalityState.any(), o -> Disposer.isDisposed((Disposable)this));
            return;
        }
        this.myIcon = null;
        this.setIcon(null);
        if (selectedIcon != null) {
            try {
                File iconFile = new File(FileUtil.getTempDirectory(), selectedIcon.getName());
                InputStream iconStream = selectedIcon.getURL().openStream();
                FileOutputStream outputStream = new FileOutputStream(iconFile);
                FileUtil.copy((InputStream)iconStream, (OutputStream)outputStream);
                this.myXmlAsset.path().set(iconFile);
                VectorAsset.Preview result2 = this.myXmlAsset.generatePreview(h);
                BufferedImage image = result2.getImage();
                if (image != null) {
                    image = VdIcon.adjustIconColor((Component)this, (BufferedImage)image);
                    this.setIcon(new ImageIcon(image));
                }
                this.myIcon = selectedIcon;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    @NotNull
    public VectorAsset getAsset() {
        return this.myXmlAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        this.myAssetListeners.add(listener2);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myAssetListeners.clear();
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        URL defaultIconUrl = MaterialDesignIcons.getDefaultIcon();
        URL iconUrl = this.myIcon == null ? defaultIconUrl : this.myIcon.getURL();
        state.set(URL_PROPERTY, iconUrl.toString(), defaultIconUrl.toString());
        return state;
    }

    public void loadState(@NotNull PersistentState state) {
        URL iconUrl;
        URL defaultIconUrl = MaterialDesignIcons.getDefaultIcon();
        try {
            iconUrl = new URL(state.get(URL_PROPERTY, defaultIconUrl.toString()));
        }
        catch (MalformedURLException e) {
            iconUrl = defaultIconUrl;
        }
        this.updateIcon(VectorIconButton.createIcon(iconUrl));
        if (this.myIcon == null && iconUrl.equals(defaultIconUrl)) {
            this.updateIcon(VectorIconButton.createIcon(defaultIconUrl));
        }
    }

    @Nullable
    private static VdIcon createIcon(@NotNull URL url) {
        try {
            return new VdIcon(url);
        }
        catch (IOException e) {
            return null;
        }
    }
}

