/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.adtui.validation.validators.FalseValidator;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.ui.ProposedFileTreeCellRenderer;
import com.android.tools.idea.npw.assetstudio.ui.ProposedFileTreeModel;
import com.android.tools.idea.npw.assetstudio.wizard.CheckeredBackgroundPanel;
import com.android.tools.idea.npw.assetstudio.wizard.DensityAwareFileComparator;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.utils.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfirmGenerateImagesStep
extends ModelWizardStep<GenerateIconsModel>
implements PersistentStateComponent<PersistentState> {
    private static final String CONFIRMATION_STEP_PROPERTY = "confirmationStep";
    private static final String RESOURCE_DIRECTORY_PROPERTY = "resourceDirectory";
    private final List<NamedModuleTemplate> myTemplates;
    private final ValidatorPanel myValidatorPanel;
    private final ListenerManager myListeners;
    private final JBLabel myPreviewIcon;
    private JPanel myRootPanel;
    private JComboBox<NamedModuleTemplate> myPathsComboBox;
    private Tree myOutputPreviewTree;
    private CheckeredBackgroundPanel myPreviewPanel;
    private JTextField mySizeDpTextField;
    private JTextField myDensityTextField;
    private JTextField myFileTypeTextField;
    private JTextField mySizePxTextField;
    private JSplitPane mySplitPane;
    private Map<File, GeneratedIcon> myPathToPreviewImage;
    private JPanel myLeftPanel;
    private JPanel myRightPanel;
    private JPanel myPreviewFillPanel;
    private TitledSeparator myDetailsHeaderPanel;
    private JPanel myDetailsGridContainer;
    private JPanel myDensityRow;
    private JPanel mySizeDetailsRow;
    private JPanel mySizePxRow;
    private JPanel myDetailsPanel;
    private JPanel myImagePreviewPanel;
    private JPanel myXmlPreviewPanel;
    private JTextPane myXmlTextPane;
    private EditorEx myFilePreviewEditor;
    private EditorFactory myEditorFactory;
    private Document myXmlPreviewDocument;
    private ObjectProperty<NamedModuleTemplate> mySelectedTemplate;
    private BoolProperty myFilesAlreadyExist;

    public ConfirmGenerateImagesStep(@NotNull GenerateIconsModel model2, @NotNull List<NamedModuleTemplate> templates) {
        super(model2, "Confirm Icon Path");
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myFilesAlreadyExist = new BoolValueProperty();
        Preconditions.checkArgument((!templates.isEmpty() ? 1 : 0) != 0);
        this.myTemplates = templates;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        DefaultComboBoxModel<NamedModuleTemplate> moduleTemplatesModel = new DefaultComboBoxModel<NamedModuleTemplate>();
        for (NamedModuleTemplate template : templates) {
            moduleTemplatesModel.addElement(template);
        }
        this.myPathsComboBox.setRenderer((ListCellRenderer<NamedModuleTemplate>)new ListCellRendererWrapper<NamedModuleTemplate>(){

            public void customize(JList list, NamedModuleTemplate template, int index, boolean selected, boolean hasFocus) {
                this.setText(template.getName());
            }
        });
        this.myPathsComboBox.setModel(moduleTemplatesModel);
        DefaultTreeModel emptyModel = new DefaultTreeModel(null);
        this.myOutputPreviewTree.setModel((TreeModel)emptyModel);
        this.myOutputPreviewTree.setCellRenderer((TreeCellRenderer)((Object)new ProposedFileTreeCellRenderer()));
        this.myOutputPreviewTree.setBorder(BorderFactory.createLineBorder(UIUtil.getBoundsColor()));
        this.myOutputPreviewTree.setRowHeight(-1);
        this.myOutputPreviewTree.getEmptyText().setText("No resource folder defined in project");
        this.myOutputPreviewTree.addTreeSelectionListener(e -> {
            TreePath newPath = e.getNewLeadSelectionPath();
            this.showSelectedNodeDetails(newPath);
        });
        String alreadyExistsError = WizardUtils.toHtmlString("Some existing files will be overwritten by this operation.<br>Files which replace existing files are marked red in the preview above.");
        this.myValidatorPanel.registerValidator((ObservableValue)this.myFilesAlreadyExist, (Validator)new FalseValidator(Validator.Severity.WARNING, alreadyExistsError));
        this.myPreviewIcon = new JBLabel();
        this.myPreviewIcon.setVisible(false);
        this.myPreviewIcon.setHorizontalAlignment(0);
        this.myPreviewIcon.setVerticalAlignment(0);
        this.myPreviewPanel.setLayout(new BorderLayout());
        this.myPreviewPanel.add((Component)this.myPreviewIcon, "Center");
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.mySplitPane);
    }

    private void showSelectedNodeDetails(TreePath newPath) {
        if (newPath != null && newPath.getLastPathComponent() instanceof ProposedFileTreeModel.Node) {
            ProposedFileTreeModel.Node node = (ProposedFileTreeModel.Node)newPath.getLastPathComponent();
            GeneratedIcon generatedIcon = this.myPathToPreviewImage.get(node.getFile());
            if (generatedIcon instanceof GeneratedImageIcon) {
                GeneratedImageIcon generatedImageIcon = (GeneratedImageIcon)generatedIcon;
                BufferedImage image = generatedImageIcon.getImage();
                ImageIcon icon2 = new ImageIcon(image);
                this.myPreviewIcon.setIcon((Icon)icon2);
                this.myPreviewIcon.setVisible(true);
                String extension = FileUtilRt.getExtension((String)node.getFile().getName()).toUpperCase();
                if (StringUtil.isEmpty((String)extension)) {
                    this.myFileTypeTextField.setText("N/A");
                } else {
                    this.myFileTypeTextField.setText(String.format("%s File", extension));
                }
                this.mySizePxTextField.setText(String.format(Locale.US, "%dx%d", icon2.getIconWidth(), icon2.getIconHeight()));
                Density density = generatedImageIcon.getDensity();
                this.myDensityTextField.setText(density.getResourceValue());
                double scaleFactor = IconGenerator.getMdpiScaleFactor(density);
                this.mySizeDpTextField.setText(String.format(Locale.US, "%dx%d", Math.round((double)icon2.getIconWidth() / scaleFactor), Math.round((double)icon2.getIconHeight() / scaleFactor)));
                this.mySizeDetailsRow.setVisible(true);
                this.mySizePxRow.setVisible(true);
                this.myImagePreviewPanel.setVisible(true);
                this.myXmlPreviewPanel.setVisible(false);
                return;
            }
            if (generatedIcon instanceof GeneratedXmlResource) {
                GeneratedXmlResource xml = (GeneratedXmlResource)generatedIcon;
                String xmlText = xml.getXmlText();
                BufferedImage image = this.getPreviewImage(xml);
                if (image == null) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (this.myEditorFactory == null) {
                            this.myEditorFactory = EditorFactory.getInstance();
                        }
                        if (this.myXmlPreviewDocument == null) {
                            this.myXmlPreviewDocument = this.myEditorFactory.createDocument((CharSequence)"");
                        }
                        this.myXmlPreviewDocument.setReadOnly(false);
                        this.myXmlPreviewDocument.setText((CharSequence)StringUtil.convertLineSeparators((String)xmlText));
                        this.myXmlPreviewDocument.setReadOnly(true);
                        if (this.myFilePreviewEditor == null) {
                            this.myFilePreviewEditor = (EditorEx)this.myEditorFactory.createViewer(this.myXmlPreviewDocument);
                            this.myFilePreviewEditor.setCaretVisible(false);
                            this.myFilePreviewEditor.getSettings().setLineNumbersShown(false);
                            this.myFilePreviewEditor.getSettings().setLineMarkerAreaShown(false);
                            this.myFilePreviewEditor.getSettings().setFoldingOutlineShown(false);
                            this.myFilePreviewEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(null, (FileType)StdFileTypes.XML));
                            this.myXmlPreviewPanel.removeAll();
                            this.myXmlPreviewPanel.add(this.myFilePreviewEditor.getComponent());
                        }
                    });
                    this.myImagePreviewPanel.setVisible(false);
                    this.myXmlPreviewPanel.setVisible(true);
                } else {
                    ImageIcon icon3 = new ImageIcon(image);
                    this.myPreviewIcon.setIcon((Icon)icon3);
                    String drawableType = ConfirmGenerateImagesStep.getDrawableType(xmlText);
                    this.myFileTypeTextField.setText(drawableType);
                    this.myPreviewIcon.setVisible(true);
                    this.myDensityTextField.setText(Density.ANYDPI.getShortDisplayValue());
                    Dimension dpSize = ConfirmGenerateImagesStep.getDpSize(xml);
                    if (dpSize == null) {
                        this.mySizeDetailsRow.setVisible(false);
                    } else {
                        this.mySizeDpTextField.setText(String.format(Locale.US, "%dx%d", dpSize.width, dpSize.height));
                        this.mySizeDetailsRow.setVisible(true);
                    }
                    this.mySizePxRow.setVisible(false);
                    this.myImagePreviewPanel.setVisible(true);
                    this.myXmlPreviewPanel.setVisible(false);
                }
                return;
            }
        }
        this.myPreviewIcon.setVisible(false);
        this.myPreviewIcon.setIcon(null);
        this.myFileTypeTextField.setText("");
        this.mySizeDpTextField.setText("");
        this.mySizePxTextField.setText("");
        this.myDensityTextField.setText("");
        this.myImagePreviewPanel.setVisible(true);
        this.myXmlPreviewPanel.setVisible(false);
    }

    @NotNull
    private static String getDrawableType(@NotNull String xmlText) {
        String tagName = XmlUtils.getRootTagName((String)xmlText);
        if (tagName != null) {
            switch (tagName) {
                case "vector": {
                    return "Vector Drawable";
                }
                case "shape": {
                    return "Shape Drawable";
                }
                case "bitmap": {
                    return "Bitmap Drawable";
                }
                case "layer-list": {
                    return "Layer List";
                }
            }
        }
        return "Drawable";
    }

    @Nullable
    private static Dimension getDpSize(@NotNull GeneratedXmlResource xml) {
        IconCategory xmlCategory = xml.getCategory();
        if (xmlCategory == IconCategory.ADAPTIVE_BACKGROUND_LAYER || xmlCategory == IconCategory.ADAPTIVE_FOREGROUND_LAYER) {
            return LauncherIconGenerator.SIZE_FULL_BLEED_DP;
        }
        return null;
    }

    @Nullable
    private BufferedImage getPreviewImage(@NotNull GeneratedXmlResource xml) {
        String xmlText = xml.getXmlText();
        IconGenerator generator = ((GenerateIconsModel)this.getModel()).getIconGenerator();
        IconCategory xmlCategory = xml.getCategory();
        if (generator != null && (xmlCategory == IconCategory.ADAPTIVE_BACKGROUND_LAYER || xmlCategory == IconCategory.ADAPTIVE_FOREGROUND_LAYER)) {
            GraphicGeneratorContext generatorContext = generator.getGraphicGeneratorContext();
            Rectangle rectangle = AssetStudioUtils.scaleRectangle(LauncherIconGenerator.IMAGE_SIZE_FULL_BLEED_DP, IconGenerator.getMdpiScaleFactor(Density.XHIGH) * (double)0.8f);
            Future<BufferedImage> imageFuture = generatorContext.renderDrawable(xmlText, rectangle.getSize());
            try {
                return imageFuture.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        this.mySelectedTemplate = ObjectProperty.wrap(new SelectedItemProperty(this.myPathsComboBox));
        PersistentStateUtil.load(this, ((GenerateIconsModel)this.getModel()).getPersistentState().getChild(CONFIRMATION_STEP_PROPERTY));
    }

    @Override
    public void onWizardFinished() {
        ((GenerateIconsModel)this.getModel()).getPersistentState().setChild(CONFIRMATION_STEP_PROPERTY, this.getState());
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        NamedModuleTemplate moduleTemplate = (NamedModuleTemplate)this.mySelectedTemplate.get();
        state.set(RESOURCE_DIRECTORY_PROPERTY, moduleTemplate.getName(), this.myTemplates.get(0).getName());
        return state;
    }

    public void loadState(@NotNull PersistentState state) {
        String templateName = state.get(RESOURCE_DIRECTORY_PROPERTY);
        if (templateName != null) {
            for (NamedModuleTemplate template : this.myTemplates) {
                if (!template.getName().equals(templateName)) continue;
                this.mySelectedTemplate.set(template);
                break;
            }
        }
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    protected void onProceeding() {
        ((GenerateIconsModel)this.getModel()).setPaths(((NamedModuleTemplate)this.mySelectedTemplate.get()).getPaths());
    }

    @Override
    protected void onEntering() {
        this.myListeners.release(this.mySelectedTemplate);
        this.myListeners.listenAndFire(this.mySelectedTemplate, namedTemplate -> {
            int i2;
            IconGenerator iconGenerator = ((GenerateIconsModel)this.getModel()).getIconGenerator();
            AndroidModuleTemplate template = namedTemplate.getPaths();
            File resDirectory = IconGenerator.getResDirectory(template);
            if (iconGenerator == null || resDirectory == null || resDirectory.getParentFile() == null) {
                return;
            }
            this.myFilesAlreadyExist.set(false);
            this.myPathToPreviewImage = iconGenerator.generateIntoIconMap(template);
            Set<File> outputDirectories = this.myPathToPreviewImage.keySet().stream().flatMap(x -> {
                File root = resDirectory.getParentFile();
                ArrayList<File> directories = new ArrayList<File>();
                for (File f = x.getParentFile(); f != null && !Objects.equals(f, root); f = f.getParentFile()) {
                    directories.add(f);
                }
                return directories.stream();
            }).collect(Collectors.toSet());
            ImmutableSortedSet proposedFiles = ImmutableSortedSet.orderedBy((Comparator)new DensityAwareFileComparator(outputDirectories)).addAll(this.myPathToPreviewImage.keySet()).build();
            ProposedFileTreeModel treeModel = new ProposedFileTreeModel(resDirectory.getParentFile(), (Set<? extends File>)proposedFiles);
            this.myFilesAlreadyExist.set(treeModel.hasConflicts());
            this.myOutputPreviewTree.setModel((TreeModel)treeModel);
            for (i2 = 0; i2 < this.myOutputPreviewTree.getRowCount(); ++i2) {
                this.myOutputPreviewTree.expandRow(i2);
            }
            for (i2 = 0; i2 < this.myOutputPreviewTree.getRowCount(); ++i2) {
                TreePath rowPath = this.myOutputPreviewTree.getPathForRow(i2);
                if (rowPath == null || !treeModel.isLeaf(rowPath.getLastPathComponent())) continue;
                this.myOutputPreviewTree.setSelectionRow(i2);
                break;
            }
        });
    }

    @Override
    public void dispose() {
        if (this.myEditorFactory != null && this.myFilePreviewEditor != null) {
            this.myEditorFactory.releaseEditor((Editor)this.myFilePreviewEditor);
        }
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TitledSeparator titledSeparator;
        JTextPane jTextPane;
        JPanel jPanel;
        CheckeredBackgroundPanel checkeredBackgroundPanel;
        JPanel jPanel2;
        JTextField jTextField;
        JPanel jPanel3;
        JTextField jTextField2;
        JPanel jPanel4;
        JTextField jTextField3;
        JPanel jPanel5;
        JTextField jTextField4;
        JPanel jPanel6;
        JPanel jPanel7;
        JPanel jPanel8;
        JPanel jPanel9;
        Tree tree;
        JPanel jPanel10;
        JSplitPane jSplitPane;
        JPanel jPanel11;
        this.myRootPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerLocation(500);
        jPanel11.add((Component)jSplitPane, new GridConstraints(0, 0, 2, 3, 0, 3, 3, 3, null, null, null));
        this.myLeftPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel10);
        JLabel jLabel = new JLabel();
        jLabel.setText("Res Directory:");
        jPanel10.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Output Directories:");
        jPanel10.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myPathsComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel10.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel10.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myOutputPreviewTree = tree = new Tree();
        tree.setOpaque(false);
        tree.setToolTipText("A preview rendering of the output tree");
        jBScrollPane.setViewportView((Component)tree);
        this.myRightPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel9);
        this.myDetailsPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myImagePreviewPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDetailsGridContainer = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel12, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myFileTypeTextField = jTextField4 = new JTextField();
        jTextField4.setEditable(false);
        jPanel12.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("File Type:");
        jPanel12.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDensityRow = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.myDensityTextField = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        jPanel5.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Density:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySizeDetailsRow = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.mySizeDpTextField = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Size (dp):");
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySizePxRow = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        this.mySizePxTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Size (px):");
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel7.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myPreviewFillPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane2.setViewportView(jPanel2);
        this.myPreviewPanel = checkeredBackgroundPanel = new CheckeredBackgroundPanel();
        jPanel2.add((Component)checkeredBackgroundPanel, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myXmlPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myXmlTextPane = jTextPane = new JTextPane();
        jTextPane.setText("<xml></xml>");
        jPanel.add((Component)jTextPane, "Center");
        this.myDetailsHeaderPanel = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Output File");
        jPanel9.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

