/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.Density;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconPanel;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureLauncherIconPanel;
import com.android.tools.idea.npw.assetstudio.ui.PreviewIconsPanel;
import com.android.tools.idea.npw.assetstudio.wizard.CheckeredBackgroundPanel;
import com.android.tools.idea.npw.assetstudio.wizard.IconGenerationProcessor;
import com.android.tools.idea.npw.assetstudio.wizard.ImagePreviewPanel;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.npw.assetstudio.wizard.WrappedFlowLayout;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateImageAssetPanel
extends JPanel
implements Disposable,
PersistentStateComponent<PersistentState> {
    private static final String OUTPUT_ICON_TYPE_PROPERTY = "outputIconType";
    @NotNull
    private final AndroidModuleTemplate myDefaultPaths;
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final BindingsManager myBindings;
    @NotNull
    private final ListenerManager myListeners;
    private final Map<AndroidIconType, PreviewIconsPanel> myOutputPreviewPanels;
    private final ObjectProperty<AndroidIconType> myOutputIconType;
    private final StringProperty myOutputName;
    private JPanel myRootPanel;
    private JComboBox<AndroidIconType> myIconTypeCombo;
    private JPanel myConfigureIconPanels;
    private Map<AndroidIconType, ConfigureIconView> myConfigureIconViews;
    private CheckeredBackgroundPanel myOutputPreviewPanel;
    private TitledSeparator myOutputPreviewLabel;
    private JBScrollPane myOutputPreviewScrollPane;
    private JSplitPane mySplitPane;
    private JCheckBox myShowGrid;
    private JCheckBox myShowSafeZone;
    private JComboBox<Density> myPreviewResolutionComboBox;
    private JPanel myPreviewPanel;
    private JPanel myIconTypePanel;
    private JPanel myPreviewTitlePanel;
    private JPanel myPreviewContentsPanel;
    private JPanel myOutputIconTypePanel;
    private SelectedProperty myShowGridProperty;
    private SelectedProperty myShowSafeZoneProperty;
    private AbstractProperty<Density> myPreviewDensityProperty;
    private JBLoadingPanel myLoadingPanel;
    @NotNull
    private AndroidModuleTemplate myPaths;
    @NotNull
    private final IconGenerationProcessor myIconGenerationProcessor;
    @NotNull
    private final StringProperty myPreviewRenderingError;

    public GenerateImageAssetPanel(@NotNull Disposable disposableParent, @NotNull AndroidFacet facet, @NotNull AndroidModuleTemplate defaultPaths, AndroidIconType ... supportedTypes) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myOutputName = new StringValueProperty();
        this.myConfigureIconViews = new TreeMap<AndroidIconType, ConfigureIconView>();
        this.myIconGenerationProcessor = new IconGenerationProcessor();
        this.myPreviewRenderingError = new StringValueProperty();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), panel2 -> new LoadingDecorator((JComponent)panel2, this, -1){

            protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AsyncProcessIcon icon2) {
                NonOpaquePanel panel2 = super.customizeLoadingLayer(parent, text, icon2);
                Font font = text.getFont();
                text.setFont(font.deriveFont(font.getStyle(), font.getSize() + 6));
                text.setForeground(ColorUtil.toAlpha((Color)Color.BLACK, (int)100));
                panel2.setOpaque(true);
                return panel2;
            }
        });
        this.myLoadingPanel.add((Component)this.myOutputPreviewPanel);
        this.myOutputPreviewScrollPane.getViewport().setView((Component)this.myLoadingPanel);
        this.myLoadingPanel.setLoadingText("Rendering preview images");
        this.myLoadingPanel.startLoading();
        this.myPaths = this.myDefaultPaths = defaultPaths;
        if (supportedTypes.length == 0) {
            supportedTypes = AndroidIconType.values();
        }
        DefaultComboBoxModel<AndroidIconType> supportedTypesModel = new DefaultComboBoxModel<AndroidIconType>(supportedTypes);
        this.myIconTypeCombo.setModel(supportedTypesModel);
        this.myIconTypeCombo.setVisible(supportedTypes.length > 1);
        this.myOutputIconType = ObjectProperty.wrap(new SelectedItemProperty(this.myIconTypeCombo));
        this.myOutputPreviewPanel.setName("PreviewIconsPanel");
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myRootPanel);
        this.myPreviewResolutionComboBox.setRenderer((ListCellRenderer<Density>)new ListCellRendererWrapper<Density>(){

            public void customize(JList list, Density value2, int index, boolean selected, boolean hasFocus) {
                if (value2 != null) {
                    this.setText(value2.getResourceValue());
                }
            }
        });
        DefaultComboBoxModel<Density> densitiesModel = new DefaultComboBoxModel<Density>();
        densitiesModel.addElement(Density.MEDIUM);
        densitiesModel.addElement(Density.HIGH);
        densitiesModel.addElement(Density.XHIGH);
        densitiesModel.addElement(Density.XXHIGH);
        densitiesModel.addElement(Density.XXXHIGH);
        this.myPreviewResolutionComboBox.setModel(densitiesModel);
        this.myPreviewDensityProperty = ObjectProperty.wrap(new SelectedItemProperty(this.myPreviewResolutionComboBox));
        this.myShowGridProperty = new SelectedProperty(this.myShowGrid);
        this.myShowSafeZoneProperty = new SelectedProperty(this.myShowSafeZone);
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(facet);
        int minSdkVersion2 = androidModuleInfo.getMinSdkVersion().getApiLevel();
        assert (this.myConfigureIconPanels.getLayout() instanceof CardLayout);
        DrawableRenderer renderer = new DrawableRenderer(facet);
        Disposer.register((Disposable)this, (Disposable)renderer);
        for (AndroidIconType iconType : supportedTypes) {
            JPanel view;
            switch (iconType) {
                case LAUNCHER: {
                    view = new ConfigureLauncherIconPanel(this, facet, this.myShowGridProperty, this.myShowSafeZoneProperty, this.myPreviewDensityProperty, this.myValidatorPanel, renderer);
                    break;
                }
                case LAUNCHER_LEGACY: 
                case ACTIONBAR: 
                case NOTIFICATION: {
                    view = new ConfigureIconPanel(this, facet, iconType, minSdkVersion2, renderer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid icon type");
                }
            }
            this.myConfigureIconViews.put(iconType, (ConfigureIconView)((Object)view));
            this.myConfigureIconPanels.add((Component)view.getRootComponent(), iconType.toString());
        }
        ImmutableMap.Builder previewPanelBuilder = ImmutableMap.builder();
        previewPanelBuilder.put((Object)AndroidIconType.LAUNCHER, (Object)new LauncherIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.LAUNCHER_LEGACY, (Object)new LauncherLegacyIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.ACTIONBAR, (Object)new ActionBarIconsPreviewPanel());
        previewPanelBuilder.put((Object)AndroidIconType.NOTIFICATION, (Object)new NotificationIconsPreviewPanel());
        this.myOutputPreviewPanels = previewPanelBuilder.build();
        WrappedFlowLayout previewLayout = new WrappedFlowLayout(3);
        previewLayout.setAlignOnBaseline(true);
        this.myOutputPreviewPanel.setLayout(previewLayout);
        this.myOutputPreviewScrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                GenerateImageAssetPanel.this.myOutputPreviewPanel.revalidate();
            }
        });
        this.mySplitPane.setDividerLocation(this.mySplitPane.getLeftComponent().getPreferredSize().width);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.mySplitPane);
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myValidatorPanel);
        this.add((Component)this.myValidatorPanel);
    }

    private void initializeListenersAndBindings() {
        ActionListener onAssetModified = actionEvent -> this.renderIconPreviews();
        for (ConfigureIconView view : this.myConfigureIconViews.values()) {
            view.addAssetListener(onAssetModified);
        }
        Runnable updatePreview = () -> {
            ConfigureIconView iconView = this.getActiveIconView();
            this.myBindings.bind(this.myOutputName, iconView.outputName());
            this.myOutputPreviewLabel.setText("Preview");
            this.renderIconPreviews();
        };
        this.myListeners.listenAndFire(this.myOutputIconType, iconType -> {
            ((CardLayout)this.myConfigureIconPanels.getLayout()).show(this.myConfigureIconPanels, iconType.toString());
            updatePreview.run();
        });
        this.myListeners.listenAndFire(this.myShowGridProperty, selected -> updatePreview.run());
        this.myListeners.listenAndFire(this.myShowSafeZoneProperty, selected -> updatePreview.run());
        this.myListeners.listenAndFire(this.myPreviewDensityProperty, value2 -> updatePreview.run());
        Expression<Boolean> isAdaptiveIconOutput = Expression.create(() -> this.myOutputIconType.get() == AndroidIconType.LAUNCHER, this.myOutputIconType);
        this.myBindings.bind(new VisibleProperty(this.myShowGrid), isAdaptiveIconOutput);
        this.myBindings.bind(new VisibleProperty(this.myShowSafeZone), isAdaptiveIconOutput);
        this.myBindings.bind(new VisibleProperty(this.myPreviewResolutionComboBox), isAdaptiveIconOutput);
    }

    private void updateOutputPreviewPanel() {
        this.myOutputPreviewPanel.removeAll();
        PreviewIconsPanel iconsPanel = this.myOutputPreviewPanels.get(this.myOutputIconType.get());
        for (PreviewIconsPanel.IconPreviewInfo previewInfo : iconsPanel.getIconPreviewInfos()) {
            ImagePreviewPanel previewPanel = new ImagePreviewPanel();
            previewPanel.getComponent().setName("IconPanel");
            previewPanel.setLabelText(previewInfo.getLabel());
            previewPanel.setImage(previewInfo.getImage());
            previewPanel.setImageBackground(previewInfo.getImageBackground());
            previewPanel.setImageOpaque(previewInfo.isImageOpaque());
            if (this.myOutputIconType.get() != AndroidIconType.LAUNCHER) {
                previewPanel.setImageBorder(previewInfo.getImageBorder());
            }
            this.myOutputPreviewPanel.add(previewPanel.getComponent());
        }
        this.myOutputPreviewPanel.revalidate();
        this.myOutputPreviewPanel.repaint();
    }

    @NotNull
    private ConfigureIconView getActiveIconView() {
        for (ConfigureIconView view : this.myConfigureIconViews.values()) {
            if (!view.getRootComponent().isVisible()) continue;
            return view;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " is configured incorrectly. Please report this error.");
    }

    private void initializeValidators() {
        this.myValidatorPanel.registerValidator((ObservableValue)this.myOutputName, outputName -> {
            String trimmedName = outputName.trim();
            if (trimmedName.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, "Icon name must be set");
            }
            if (this.iconExists()) {
                return new Validator.Result(Validator.Severity.WARNING, "An icon with the same name already exists and will be overwritten.");
            }
            return Validator.Result.OK;
        });
        this.myValidatorPanel.registerValidator((ObservableValue)this.myPreviewRenderingError, errorMessage -> {
            if (!errorMessage.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, errorMessage);
            }
            return Validator.Result.OK;
        });
    }

    public void setProjectPaths(@Nullable AndroidModuleTemplate projectPaths) {
        this.myPaths = projectPaths != null ? projectPaths : this.myDefaultPaths;
    }

    public void setOutputName(@NotNull String name) {
        this.getActiveIconView().outputName().set(name);
    }

    @NotNull
    public IconGenerator getIconGenerator() {
        return this.getActiveIconView().getIconGenerator();
    }

    @NotNull
    public ObservableBool hasErrors() {
        return this.myValidatorPanel.hasErrors();
    }

    private boolean iconExists() {
        Map<File, GeneratedIcon> pathImageMap = this.getIconGenerator().generateIconPlaceholders(this.myPaths);
        for (File path : pathImageMap.keySet()) {
            if (!path.exists()) continue;
            return true;
        }
        return false;
    }

    private void renderIconPreviews() {
        GenerateImageAssetPanel.invokeVeryLate(this::enqueueGenerateNotificationIcons, ModalityState.any(), o -> Disposer.isDisposed((Disposable)this));
    }

    private void enqueueGenerateNotificationIcons() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AndroidIconType iconType = (AndroidIconType)((Object)this.myOutputIconType.get());
        IconGenerator iconGenerator = this.getActiveIconView().getIconGenerator();
        this.myIconGenerationProcessor.enqueue(iconGenerator, iconGeneratorResult -> {
            if (iconGeneratorResult == null) {
                return;
            }
            this.myLoadingPanel.stopLoading();
            this.myOutputPreviewPanels.get((Object)iconType).showPreviewImages((IconGeneratorResult)iconGeneratorResult);
            if (Objects.equals((Object)iconType, this.myOutputIconType.get())) {
                this.updateOutputPreviewPanel();
                Collection<String> errors = iconGeneratorResult.getErrors();
                String errorMessage = errors.isEmpty() ? "" : (errors.size() == 1 ? "Preview rendering error: " + (String)Iterables.getOnlyElement(errors) : "Icon preview was rendered with errors");
                this.myPreviewRenderingError.set(errorMessage);
            }
        });
    }

    private static void invokeVeryLate(@NotNull Runnable runnable, @NotNull ModalityState state, @NotNull Condition expired) {
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> application.invokeLater(runnable, state, expired), state, expired);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        state.set(OUTPUT_ICON_TYPE_PROPERTY, (Enum)this.myOutputIconType.get(), AndroidIconType.LAUNCHER);
        for (Map.Entry<AndroidIconType, ConfigureIconView> entry : this.myConfigureIconViews.entrySet()) {
            state.setChild(AssetStudioUtils.toLowerCamelCase(entry.getKey()), (PersistentState)entry.getValue().getState());
        }
        return state;
    }

    public void loadState(@NotNull PersistentState state) {
        this.myOutputIconType.set(state.get(OUTPUT_ICON_TYPE_PROPERTY, AndroidIconType.LAUNCHER));
        ApplicationManager.getApplication().invokeLater(() -> {
            for (Map.Entry<AndroidIconType, ConfigureIconView> entry : this.myConfigureIconViews.entrySet()) {
                PersistentStateUtil.load((PersistentStateComponent<PersistentState>)((PersistentStateComponent)entry.getValue()), state.getChild(AssetStudioUtils.toLowerCamelCase(entry.getKey())));
            }
        }, ModalityState.any());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CheckeredBackgroundPanel checkeredBackgroundPanel;
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TitledSeparator titledSeparator;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JSplitPane jSplitPane;
        JPanel jPanel7;
        this.myRootPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(10);
        ((Component)jSplitPane).setEnabled(true);
        jPanel7.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myIconTypePanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel6);
        this.myOutputIconTypePanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 1, 1, 1, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Icon Type:");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null));
        JComboBox jComboBox = new JComboBox();
        this.myIconTypeCombo = jComboBox;
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigureIconPanels = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 3, new Dimension(350, -1), null, null));
        this.myPreviewPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 2, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel3);
        this.myPreviewTitlePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 2, 1, 3, 0, null, null, null));
        this.myOutputPreviewLabel = titledSeparator = new TitledSeparator();
        titledSeparator.setText("Preview");
        jPanel2.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myShowGrid = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show Grid");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowSafeZone = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show Safe Zone");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myPreviewResolutionComboBox = jComboBox2;
        jPanel2.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPreviewContentsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myOutputPreviewScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOutputPreviewPanel = checkeredBackgroundPanel = new CheckeredBackgroundPanel();
        jBScrollPane.setViewportView(checkeredBackgroundPanel);
        jBLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static class NotificationIconsPreviewPanel
    extends PreviewIconsPanel {
        NotificationIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.DARK, CategoryIconMap.ACCEPT_ALL);
        }
    }

    private static class ActionBarIconsPreviewPanel
    extends PreviewIconsPanel {
        ActionBarIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.TRANSPARENT);
        }
    }

    private static class LauncherLegacyIconsPreviewPanel
    extends PreviewIconsPanel {
        LauncherLegacyIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.TRANSPARENT);
        }

        @Override
        public void showPreviewImages(@NotNull IconGeneratorResult iconGeneratorResult) {
            Collection<GeneratedIcon> generatedIcons = iconGeneratorResult.getIcons();
            List<Pair<String, BufferedImage>> list = generatedIcons.stream().filter(icon2 -> icon2 instanceof GeneratedImageIcon).map(icon2 -> (GeneratedImageIcon)icon2).filter(icon2 -> icon2.getDensity() != Density.NODPI).sorted(Comparator.comparingInt(icon2 -> -icon2.getDensity().getDpiValue())).map(icon2 -> Pair.of((Object)icon2.getDensity().getResourceValue(), (Object)icon2.getImage())).collect(Collectors.toList());
            this.showPreviewImagesImpl(list);
        }
    }

    private static class LauncherIconsPreviewPanel
    extends PreviewIconsPanel {
        LauncherIconsPreviewPanel() {
            super("", PreviewIconsPanel.Theme.TRANSPARENT);
        }

        @Override
        public void showPreviewImages(@NotNull IconGeneratorResult result2) {
            Collection<GeneratedIcon> generatedIcons = result2.getIcons();
            List<Pair<String, BufferedImage>> list = generatedIcons.stream().filter(icon2 -> icon2 instanceof GeneratedImageIcon).map(icon2 -> (GeneratedImageIcon)icon2).filter(icon2 -> this.filterPreviewIcon((GeneratedImageIcon)icon2, ((LauncherIconGenerator.LauncherIconOptions)result2.getOptions()).previewDensity)).map(icon2 -> Pair.of((Object)((Object)LauncherIconsPreviewPanel.getPreviewShapeFromId(icon2.getName())), (Object)icon2.getImage())).sorted((pair1, pair2) -> LauncherIconsPreviewPanel.comparePreviewShapes((LauncherIconGenerator.PreviewShape)((Object)((Object)pair1.getFirst())), (LauncherIconGenerator.PreviewShape)((Object)((Object)pair2.getFirst())))).map(pair -> Pair.of((Object)((LauncherIconGenerator.PreviewShape)((Object)((Object)pair.getFirst()))).displayName, (Object)pair.getSecond())).collect(Collectors.toList());
            this.showPreviewImagesImpl(list);
        }

        protected boolean filterPreviewIcon(@NotNull GeneratedImageIcon icon2, @NotNull Density density) {
            return Objects.equals((Object)IconCategory.PREVIEW, (Object)icon2.getCategory()) && Objects.equals(icon2.getDensity(), density);
        }

        private static int comparePreviewShapes(@NotNull LauncherIconGenerator.PreviewShape x, @NotNull LauncherIconGenerator.PreviewShape y) {
            return Integer.compare(LauncherIconsPreviewPanel.getPreviewShapeDisplayOrder(x), LauncherIconsPreviewPanel.getPreviewShapeDisplayOrder(y));
        }

        private static int getPreviewShapeDisplayOrder(@NotNull LauncherIconGenerator.PreviewShape previewShape) {
            switch (previewShape) {
                case CIRCLE: {
                    return 1;
                }
                case SQUIRCLE: {
                    return 2;
                }
                case ROUNDED_SQUARE: {
                    return 3;
                }
                case SQUARE: {
                    return 4;
                }
                case FULL_BLEED: {
                    return 5;
                }
                case LEGACY: {
                    return 6;
                }
                case LEGACY_ROUND: {
                    return 7;
                }
                case WEB: {
                    return 8;
                }
            }
            return 1000;
        }

        @NotNull
        private static LauncherIconGenerator.PreviewShape getPreviewShapeFromId(@NotNull String previewShapeId) {
            for (LauncherIconGenerator.PreviewShape shape : LauncherIconGenerator.PreviewShape.values()) {
                if (!Objects.equals(shape.id, previewShapeId)) continue;
                return shape;
            }
            return LauncherIconGenerator.PreviewShape.SQUARE;
        }
    }
}

