/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.SwingWorker;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconGenerationProcessor {
    @Nullable
    private Request myQueuedRequest;
    @Nullable
    private Request myRunningRequest;

    public void enqueue(@NotNull IconGenerator iconGenerator, @NotNull Consumer<IconGeneratorResult> onDone) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (((Optional)iconGenerator.sourceAsset().get()).isPresent()) {
            IconGenerator.Options options = iconGenerator.createOptions(true);
            this.myQueuedRequest = new Request(iconGenerator, options, onDone);
        }
        this.processNextRequest();
    }

    private void processNextRequest() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myQueuedRequest == null) {
            return;
        }
        if (this.myRunningRequest != null) {
            this.myRunningRequest.cancel();
        }
        this.myRunningRequest = this.myQueuedRequest;
        this.myQueuedRequest = null;
        Worker worker = new Worker(this.myRunningRequest, () -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myRunningRequest = null;
            this.processNextRequest();
        });
        worker.start();
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(IconGenerationProcessor.class);
    }

    private static class Worker
    extends SwingWorker {
        @NotNull
        private final Request myRequest;
        @NotNull
        private final Runnable myOnDone;

        Worker(@NotNull Request request, @NotNull Runnable onDone) {
            this.myRequest = request;
            this.myOnDone = onDone;
        }

        public Object construct() {
            long start = System.currentTimeMillis();
            this.myRequest.run();
            long end = System.currentTimeMillis();
            IconGenerationProcessor.getLog().info(String.format(Locale.US, "Icons generated in %.2g sec", (double)(end - start) / 1000.0));
            return null;
        }

        public void finished() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            try {
                this.myRequest.done();
            }
            finally {
                ApplicationManager.getApplication().invokeLater(this.myOnDone, ModalityState.any());
            }
        }
    }

    private static class Request {
        @NotNull
        private final IconGenerator myIconGenerator;
        @NotNull
        private final Consumer<IconGeneratorResult> myOnDone;
        @NotNull
        private final IconGenerator.Options myOptions;
        @Nullable
        private IconGeneratorResult myGeneratorResult;
        private boolean isCanceled;

        Request(@NotNull IconGenerator iconGenerator, @NotNull IconGenerator.Options options, @NotNull Consumer<IconGeneratorResult> onDone) {
            this.myIconGenerator = iconGenerator;
            this.myOptions = options;
            this.myOnDone = onDone;
        }

        public void run() {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            this.myGeneratorResult = this.myIconGenerator.generateIcons(this.myOptions);
        }

        public void done() {
            if (!this.isCanceled) {
                this.myOnDone.accept(this.myGeneratorResult);
            }
        }

        public void cancel() {
            this.isCanceled = true;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }
    }
}

