/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.benchmark;

import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.benchmark.NewBenchmarkModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.template.components.LanguageComboProvider;
import com.android.tools.idea.npw.validator.ModuleValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureBenchmarkModuleStep
extends SkippableWizardStep<NewBenchmarkModuleModel> {
    @NotNull
    private final StudioWizardStepPanel myRootPanel;
    @NotNull
    private ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private JPanel myPanel;
    private JTextField myModuleName;
    private LabelWithEditButton myPackageName;
    private JComboBox<Language> myLanguageComboBox;

    public ConfigureBenchmarkModuleStep(@NotNull NewBenchmarkModuleModel model2, String title) {
        super(model2, title);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        TextProperty moduleNameText = new TextProperty(this.myModuleName);
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        SelectedItemProperty language = new SelectedItemProperty(this.myLanguageComboBox);
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        ModuleValidator moduleValidator = new ModuleValidator(model2.getProject());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myValidatorPanel.registerValidator((ObservableValue)moduleNameText, (Validator)moduleValidator);
        this.myValidatorPanel.registerValidator((ObservableValue)model2.packageName(), value2 -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value2)));
        this.myModuleName.setText(WizardUtils.getUniqueName((String)model2.moduleName().get(), moduleValidator));
        DomainToPackageExpression computedPackageName = new DomainToPackageExpression(new StringValueProperty(NewProjectModel.getInitialDomain(false)), model2.moduleName());
        this.myBindings.bind(model2.moduleName(), moduleNameText, this.myValidatorPanel.hasErrors().not());
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myBindings.bind(model2.packageName(), packageNameText);
        this.myBindings.bindTwoWay(language, model2.language());
        this.myListeners.listen(packageNameText, value2 -> isPackageNameSynced.set(value2.equals(computedPackageName.get())));
        this.myRootPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myPackageName;
    }

    private void createUIComponents() {
        this.myLanguageComboBox = new LanguageComboProvider().createComponent();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        LabelWithEditButton labelWithEditButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Module name:");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Java package name:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageName = labelWithEditButton = new LabelWithEditButton();
        jPanel.add((Component)labelWithEditButton, new GridConstraints(2, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, 20, jBLabel.getFont());
        if (font != null) {
            jBLabel.setFont(font);
        }
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.wizard.module.config.title"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, new Dimension(-1, 50), null));
        this.myModuleName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Language:");
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        JComboBox<Language> jComboBox = this.myLanguageComboBox;
        jPanel.add(jComboBox, new GridConstraints(3, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        jLabel2.setLabelFor((Component)labelWithEditButton);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

