/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.benchmark;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.benchmark.ConfigureBenchmarkModuleStep;
import com.android.tools.idea.npw.benchmark.NewBenchmarkModuleModel;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewBenchmarkModuleDescriptionProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleGalleryEntry> getDescriptions(Project project) {
        if (((Boolean)StudioFlags.NPW_BENCHMARK_TEMPLATE_MODULE.get()).booleanValue()) {
            return Collections.singletonList(new BenchmarkModuleTemplateGalleryEntry());
        }
        return Collections.EMPTY_LIST;
    }

    private static class BenchmarkModuleTemplateGalleryEntry
    implements ModuleGalleryEntry {
        @NotNull
        private TemplateHandle myTemplateHandle = new TemplateHandle(TemplateManager.getInstance().getTemplateFile("Application", "Benchmark Module"));

        BenchmarkModuleTemplateGalleryEntry() {
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return ActivityGallery.getTemplateIcon(this.myTemplateHandle, false);
        }

        @Override
        @NotNull
        public String getName() {
            return AndroidBundle.message("android.wizard.module.new.benchmark.module.app", new Object[0]);
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateHandle.getMetadata().getDescription();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model2) {
            Project project = model2.getProject().getValue();
            return new ConfigureBenchmarkModuleStep(new NewBenchmarkModuleModel(project, this.myTemplateHandle, model2.getProjectSyncInvoker()), this.getName());
        }
    }
}

