/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.benchmark;

import com.android.tools.idea.gradle.npw.project.GradleAndroidModuleTemplate;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewBenchmarkModuleModel
extends WizardModel {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TemplateHandle myTemplateHandle;
    @NotNull
    private final ProjectSyncInvoker myProjectSyncInvoker;
    @NotNull
    private final StringProperty myModuleName = new StringValueProperty("benchmark");
    @NotNull
    private final StringProperty myPackageName = new StringValueProperty();
    @NotNull
    private final OptionalProperty<Language> myLanguage = new OptionalValueProperty<Language>(Language.KOTLIN);

    public NewBenchmarkModuleModel(@NotNull Project project, @NotNull TemplateHandle templateHandle, @NotNull ProjectSyncInvoker projectSyncInvoker) {
        this.myProject = project;
        this.myTemplateHandle = templateHandle;
        this.myProjectSyncInvoker = projectSyncInvoker;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public StringProperty moduleName() {
        return this.myModuleName;
    }

    @NotNull
    public StringProperty packageName() {
        return this.myPackageName;
    }

    @NotNull
    public OptionalProperty<Language> language() {
        return this.myLanguage;
    }

    @Override
    protected void handleFinished() {
        AndroidModuleTemplate modulePaths = GradleAndroidModuleTemplate.createDefaultTemplateAt(this.myProject.getBasePath(), (String)this.moduleName().get()).getPaths();
        HashMap myTemplateValues = Maps.newHashMap();
        new TemplateValueInjector(myTemplateValues).setProjectDefaults(this.myProject, (String)this.moduleName().get()).setModuleRoots(modulePaths, this.myProject.getBasePath(), (String)this.moduleName().get(), (String)this.packageName().get()).setJavaVersion(this.myProject);
        myTemplateValues.put("isNewProject", false);
        myTemplateValues.put("isLibraryProject", true);
        myTemplateValues.put("language", this.myLanguage.getValue().getName());
        myTemplateValues.put("includeKotlinSupport", this.myLanguage.getValue() == Language.KOTLIN);
        File moduleRoot = modulePaths.getModuleRoot();
        assert (moduleRoot != null);
        if (this.doDryRun(moduleRoot, myTemplateValues)) {
            this.render(moduleRoot, myTemplateValues);
        }
    }

    private boolean doDryRun(@NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        return this.renderTemplate(true, this.myProject, moduleRoot, templateValues, null);
    }

    private void render(@NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        ArrayList<File> filesToOpen = new ArrayList<File>();
        boolean success = this.renderTemplate(false, this.myProject, moduleRoot, templateValues, filesToOpen);
        if (success) {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> TemplateUtils.openEditors(this.myProject, filesToOpen, true));
            this.myProjectSyncInvoker.syncProject(this.myProject);
        }
    }

    private boolean renderTemplate(boolean dryRun, @NotNull Project project, @NotNull File moduleRoot, @NotNull Map<String, Object> templateValues, @Nullable List<File> filesToOpen) {
        Template template = this.myTemplateHandle.getTemplate();
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(AndroidBundle.message("android.wizard.module.new.module.menu.description", new Object[0])).withDryRun(dryRun).withShowErrors(true).withModuleRoot(moduleRoot).withParams(templateValues).intoOpenFiles(filesToOpen).build();
        return template.render(context, dryRun);
    }
}

