/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.dynamicapp;

import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.dynamicapp.ConfigureDynamicDeliveryStep;
import com.android.tools.idea.npw.dynamicapp.ConfigureModuleDownloadOptionsStep;
import com.android.tools.idea.npw.dynamicapp.DynamicFeatureModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.project.FormFactorSdkControls;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.npw.ui.TemplateIcon;
import com.android.tools.idea.npw.validator.ModuleValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureDynamicModuleStep
extends SkippableWizardStep<DynamicFeatureModel> {
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private JPanel myPanel;
    private JTextField myModuleName;
    private JTextField myPackageName;
    private JComboBox<Module> myBaseApplication;
    private JLabel myTemplateIconTitle;
    private JLabel myTemplateIconDetail;
    private JPanel myFormFactorSdkControlsPanel;
    private JCheckBox myFusingCheckbox;
    private JBLabel myInstantModuleInfo;
    private JBLabel myInstantInfoIcon;
    private JTextField myModuleTitle;
    private JLabel myModuleTitleLabel;
    private FormFactorSdkControls myFormFactorSdkControls;

    public ConfigureDynamicModuleStep(final @NotNull DynamicFeatureModel model2, final @NotNull String basePackage, boolean isInstant) {
        super(model2, AndroidBundle.message("android.wizard.module.config.title", new Object[0]));
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        Expression<String> computedPackageName = new Expression<String>(new ObservableValue[]{model2.moduleName()}){

            @Override
            @NotNull
            public String get() {
                return String.format("%s.%s", basePackage, NewProjectModel.toPackagePart((String)model2.moduleName().get()));
            }
        };
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myBindings.bind(model2.packageName(), packageNameText);
        this.myInstantInfoIcon.setIcon(AllIcons.General.BalloonInformation);
        if (isInstant) {
            SelectedProperty isFusingSelected = new SelectedProperty(this.myFusingCheckbox);
            this.myBindings.bind(model2.featureFusing(), isFusingSelected);
            BoolValueProperty isOnDemand = new BoolValueProperty(false);
            this.myBindings.bind(model2.featureOnDemand(), isOnDemand);
            BoolValueProperty isInstantModule = new BoolValueProperty(true);
            this.myBindings.bind(model2.instantModule(), isInstantModule);
            this.myBindings.bindTwoWay(new TextProperty(this.myModuleTitle), ((DynamicFeatureModel)this.getModel()).featureTitle());
        } else {
            this.myFusingCheckbox.setVisible(false);
            this.myInstantInfoIcon.setVisible(false);
            this.myInstantModuleInfo.setVisible(false);
            this.myModuleTitleLabel.setVisible(false);
            this.myModuleTitle.setVisible(false);
        }
        if (DynamicAppUtils.baseIsInstantEnabled(model2.getProject())) {
            this.myInstantInfoIcon.setVisible(false);
            this.myInstantModuleInfo.setVisible(false);
        }
        this.myListeners.listen(packageNameText, value2 -> isPackageNameSynced.set(value2.equals(computedPackageName.get())));
        JBScrollPane sp = new JBScrollPane((Component)this.myPanel, 20, 31);
        sp.setBorder(BorderFactory.createEmptyBorder());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)sp);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myValidatorPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        if (((Boolean)StudioFlags.NPW_DYNAMIC_APPS_CONDITIONAL_DELIVERY.get()).booleanValue()) {
            return Collections.singletonList(new ConfigureModuleDownloadOptionsStep((DynamicFeatureModel)this.getModel()));
        }
        return Collections.singletonList(new ConfigureDynamicDeliveryStep((DynamicFeatureModel)this.getModel()));
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        StringProperty modelName = ((DynamicFeatureModel)this.getModel()).moduleName();
        Project project = ((DynamicFeatureModel)this.getModel()).getProject();
        this.myBindings.bindTwoWay(new TextProperty(this.myModuleName), modelName);
        StringValueProperty companyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(false));
        String basePackage = new DomainToPackageExpression(companyDomain, new StringValueProperty("")).get();
        Expression<String> computedPackageName = modelName.transform(appName -> String.format("%s.%s", basePackage, NewProjectModel.toPackagePart(appName)));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(((DynamicFeatureModel)this.getModel()).packageName(), packageNameText);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myListeners.listen(packageNameText, value2 -> isPackageNameSynced.set(value2.equals(computedPackageName.get())));
        OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo = ((DynamicFeatureModel)this.getModel()).androidSdkInfo();
        this.myFormFactorSdkControls.init(androidSdkInfo, this);
        AndroidProjectInfo.getInstance(project).getAllModulesOfProjectType(0).stream().filter(module -> AndroidModuleModel.get(module) != null).forEach(module -> this.myBaseApplication.addItem((Module)module));
        OptionalProperty<Module> baseApplication = ((DynamicFeatureModel)this.getModel()).baseApplication();
        this.myBindings.bind(baseApplication, new SelectedItemProperty(this.myBaseApplication));
        this.myValidatorPanel.registerValidator((ObservableValue)modelName, value2 -> value2.isEmpty() ? new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.empty.module.name", new Object[0])) : Validator.Result.OK);
        this.myValidatorPanel.registerValidator((ObservableValue)((DynamicFeatureModel)this.getModel()).packageName(), value2 -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value2)));
        this.myValidatorPanel.registerValidator(androidSdkInfo, value2 -> value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("select.target.dialog.text", new Object[0])));
        this.myValidatorPanel.registerValidator(baseApplication, value2 -> value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.module.new.dynamic.select.base", new Object[0])));
        ModuleValidator moduleValidator = new ModuleValidator(project);
        modelName.set(WizardUtils.getUniqueName((String)modelName.get(), moduleValidator));
        this.myValidatorPanel.registerValidator((ObservableValue)modelName, (Validator)new ModuleValidator(project));
    }

    @Override
    protected void onEntering() {
        FormFactor formFactor = FormFactor.MOBILE;
        TemplateHandle templateHandle = ((DynamicFeatureModel)this.getModel()).getTemplateHandle();
        this.myFormFactorSdkControls.startDataLoading(formFactor, templateHandle.getMetadata().getMinSdk());
        this.setTemplateThumbnail(templateHandle);
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myModuleName;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    private void setTemplateThumbnail(@Nullable TemplateHandle templateHandle) {
        TemplateIcon icon2 = ActivityGallery.getTemplateIcon(templateHandle, false);
        if (icon2 != null) {
            icon2.setHeight(256);
            this.myTemplateIconTitle.setIcon((Icon)((Object)icon2));
        }
        this.myTemplateIconTitle.setText("<html><center>" + ActivityGallery.getTemplateImageLabel(templateHandle, false) + "</center></html>");
        this.myTemplateIconDetail.setText("<html><center>" + ActivityGallery.getTemplateDescription(templateHandle, false) + "</center></html>");
    }

    private void createUIComponents() {
        this.myBaseApplication = new ComboBox(new DefaultComboBoxModel());
        this.myBaseApplication.setRenderer((ListCellRenderer<Module>)new ListCellRendererWrapper<Module>(){

            public void customize(JList list, Module module, int index, boolean selected, boolean hasFocus) {
                if (module == null) {
                    this.setText(AndroidBundle.message("android.wizard.module.config.new.base.missing", new Object[0]));
                } else {
                    this.setIcon(ModuleType.get((Module)module).getIcon());
                    this.setText(module.getName());
                }
            }
        });
        this.myFormFactorSdkControls = new FormFactorSdkControls();
        this.myFormFactorSdkControls.showStatsPanel(false);
        this.myFormFactorSdkControlsPanel = this.myFormFactorSdkControls.getRoot();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JTextField jTextField;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JLabel jLabel2;
        JLabel jLabel3;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(19, 3, new Insets(0, 45, 0, 65), -1, -1, false, false));
        jPanel.setPreferredSize(new Dimension(-1, -1));
        JLabel jLabel4 = new JLabel();
        Font font = this.$$$getFont$$$(null, 0, -1, jLabel4.getFont());
        if (font != null) {
            jLabel4.setFont(font);
        }
        jLabel4.setText("Package name");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(0);
        jLabel4.setVerticalAlignment(0);
        jPanel.add((Component)jLabel4, new GridConstraints(7, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleName = jTextField3 = new JTextField();
        jTextField3.setToolTipText("The name that will be shown in the Android launcher for this application");
        jPanel.add((Component)jTextField3, new GridConstraints(5, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackageName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(8, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 2, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 14, 1, 1, 0, 3, 3, null, null, null));
        this.myTemplateIconTitle = jLabel3 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, -1, 18, jLabel3.getFont());
        if (font2 != null) {
            jLabel3.setFont(font2);
        }
        jLabel3.setHorizontalAlignment(0);
        jLabel3.setHorizontalTextPosition(0);
        jLabel3.setText("Template Label");
        jLabel3.setVerticalTextPosition(3);
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 6, 6, null, new Dimension(220, -1), null));
        this.myTemplateIconDetail = jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setHorizontalTextPosition(0);
        jLabel2.setText("Detail");
        jLabel2.setVerticalAlignment(1);
        jLabel2.setVerticalTextPosition(1);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 1, 0, 7, 7, null, new Dimension(240, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(9, 2, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel3 = this.myFormFactorSdkControlsPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(10, 2, 1, 1, 1, 1, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        Font font3 = this.$$$getFont$$$(null, 0, -1, jLabel5.getFont());
        if (font3 != null) {
            jLabel5.setFont(font3);
        }
        jLabel5.setText("Base application module");
        jLabel5.setDisplayedMnemonic('B');
        jLabel5.setDisplayedMnemonicIndex(0);
        jLabel5.setVerticalAlignment(0);
        jPanel.add((Component)jLabel5, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<Module> jComboBox = this.myBaseApplication;
        jComboBox.setName("baseComboBox");
        jPanel.add(jComboBox, new GridConstraints(3, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        Font font4 = this.$$$getFont$$$(null, 0, -1, jLabel6.getFont());
        if (font4 != null) {
            jLabel6.setFont(font4);
        }
        jLabel6.setText("Module name");
        jLabel6.setDisplayedMnemonic('M');
        jLabel6.setDisplayedMnemonicIndex(0);
        jLabel6.setVerticalAlignment(0);
        jPanel.add((Component)jLabel6, new GridConstraints(4, 2, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(51, 14), null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(18, 0, 1, 3, 0, 2, 1, 0, null, null, null));
        this.myFusingCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Fusing (install module on pre-Lollipop devices)");
        jPanel.add((Component)jCheckBox, new GridConstraints(14, 2, 3, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(17, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModuleTitleLabel = jLabel = new JLabel();
        jLabel.setText("Module title (this may be visible to users)");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel, new GridConstraints(12, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleTitle = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(13, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer6 = new Spacer();
        jPanel.add((Component)spacer6, new GridConstraints(11, 2, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(16, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInstantInfoIcon = jBLabel2 = new JBLabel();
        jBLabel2.setBackground(new Color(-12828863));
        jBLabel2.setHorizontalAlignment(4);
        jBLabel2.setName("InstantInfoIcon");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 5, 0, 0, 0, null, null, null));
        this.myInstantModuleInfo = jBLabel = new JBLabel();
        jBLabel.setBackground(new Color(-12828863));
        jBLabel.setHorizontalTextPosition(10);
        jBLabel.setName("InstantModuleInfo");
        jBLabel.setText("<html>This will also enable your base<br>module to support instant apps</html>");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel.add((Component)spacer7, new GridConstraints(15, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        Spacer spacer8 = new Spacer();
        jPanel.add((Component)spacer8, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 1, null, new Dimension(55, -1), null));
        jLabel4.setLabelFor(jTextField2);
        jLabel6.setLabelFor(jTextField3);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

