/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.dynamicapp;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.npw.project.GradleAndroidModuleTemplate;
import com.android.tools.idea.npw.dynamicapp.DeviceFeatureModel;
import com.android.tools.idea.npw.dynamicapp.DownloadInstallKind;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.collections.ObservableList;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class DynamicFeatureModel
extends WizardModel {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TemplateHandle myTemplateHandle;
    @NotNull
    private final ProjectSyncInvoker myProjectSyncInvoker;
    @NotNull
    private final StringProperty myModuleName = new StringValueProperty("dynamicfeature");
    @NotNull
    private final StringProperty myFeatureTitle = new StringValueProperty("Module Title");
    @NotNull
    private final StringProperty myPackageName = new StringValueProperty();
    @NotNull
    private final OptionalProperty<AndroidVersionsInfo.VersionItem> myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
    @NotNull
    private final OptionalProperty<Module> myBaseApplication = new OptionalValueProperty<Module>();
    @NotNull
    private final BoolProperty myFeatureOnDemand = new BoolValueProperty(true);
    @NotNull
    private final OptionalProperty<DownloadInstallKind> myDownloadInstallKind;
    @NotNull
    private final BoolProperty myFeatureFusing = new BoolValueProperty(true);
    @NotNull
    private final BoolProperty myInstantModule = new BoolValueProperty(false);
    @NotNull
    private final ObservableList<DeviceFeatureModel> myDeviceFeatures = new ObservableList();

    public DynamicFeatureModel(@NotNull Project project, @NotNull TemplateHandle templateHandle, @NotNull ProjectSyncInvoker projectSyncInvoker, boolean isInstant) {
        this.myProject = project;
        this.myTemplateHandle = templateHandle;
        this.myProjectSyncInvoker = projectSyncInvoker;
        this.myDownloadInstallKind = isInstant ? new OptionalValueProperty<DownloadInstallKind>(DownloadInstallKind.INCLUDE_AT_INSTALL_TIME) : new OptionalValueProperty<DownloadInstallKind>(DownloadInstallKind.ON_DEMAND_ONLY);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public TemplateHandle getTemplateHandle() {
        return this.myTemplateHandle;
    }

    @NotNull
    public StringProperty moduleName() {
        return this.myModuleName;
    }

    @NotNull
    public StringProperty featureTitle() {
        return this.myFeatureTitle;
    }

    @NotNull
    public StringProperty packageName() {
        return this.myPackageName;
    }

    @NotNull
    public OptionalProperty<Module> baseApplication() {
        return this.myBaseApplication;
    }

    @NotNull
    public OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo() {
        return this.myAndroidSdkInfo;
    }

    @NotNull
    public BoolProperty featureOnDemand() {
        return this.myFeatureOnDemand;
    }

    @NotNull
    public OptionalProperty<DownloadInstallKind> downloadInstallKind() {
        return this.myDownloadInstallKind;
    }

    @NotNull
    public ObservableList<DeviceFeatureModel> deviceFeatures() {
        return this.myDeviceFeatures;
    }

    @NotNull
    public BoolProperty featureFusing() {
        return this.myFeatureFusing;
    }

    @NotNull
    public BoolProperty instantModule() {
        return this.myInstantModule;
    }

    @Override
    protected void handleFinished() {
        AndroidModuleTemplate modulePaths = GradleAndroidModuleTemplate.createDefaultTemplateAt(this.myProject.getBasePath(), (String)this.moduleName().get()).getPaths();
        HashMap myTemplateValues = Maps.newHashMap();
        new TemplateValueInjector(myTemplateValues).setModuleRoots(modulePaths, this.myProject.getBasePath(), (String)this.moduleName().get(), (String)this.packageName().get()).setBuildVersion(this.androidSdkInfo().getValue(), this.myProject).setBaseFeature(this.baseApplication().getValue());
        myTemplateValues.put("isDynamicFeature", true);
        myTemplateValues.put("projectSimpleName", NewProjectModel.toPackagePart((String)this.moduleName().get()));
        myTemplateValues.put("dynamicFeatureTitle", this.featureTitle().get());
        myTemplateValues.put("dynamicFeatureOnDemand", this.featureOnDemand().get());
        myTemplateValues.put("dynamicFeatureFusing", this.featureFusing().get());
        myTemplateValues.put("makeIgnore", true);
        myTemplateValues.put("isNewProject", true);
        myTemplateValues.put("isLibraryProject", false);
        myTemplateValues.put("isInstantModule", this.instantModule().get());
        myTemplateValues.put("dynamicFeatureSupportsDynamicDelivery", StudioFlags.NPW_DYNAMIC_APPS_CONDITIONAL_DELIVERY.get());
        myTemplateValues.put("dynamicFeatureInstallTimeDelivery", this.myDownloadInstallKind.getValue() == DownloadInstallKind.INCLUDE_AT_INSTALL_TIME);
        myTemplateValues.put("dynamicFeatureInstallTimeWithConditionsDelivery", this.myDownloadInstallKind.getValue() == DownloadInstallKind.INCLUDE_AT_INSTALL_TIME_WITH_CONDITIONS);
        myTemplateValues.put("dynamicFeatureOnDemandDelivery", this.myDownloadInstallKind.getValue() == DownloadInstallKind.ON_DEMAND_ONLY);
        myTemplateValues.put("dynamicFeatureDeviceFeatureList", this.myDeviceFeatures);
        File moduleRoot = modulePaths.getModuleRoot();
        assert (moduleRoot != null);
        if (this.doDryRun(moduleRoot, myTemplateValues)) {
            this.render(moduleRoot, myTemplateValues);
        }
    }

    private boolean doDryRun(@NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        return this.renderTemplate(true, this.myProject, moduleRoot, templateValues);
    }

    private void render(@NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        this.renderTemplate(false, this.myProject, moduleRoot, templateValues);
        this.myProjectSyncInvoker.syncProject(this.myProject);
    }

    private boolean renderTemplate(boolean dryRun, @NotNull Project project, @NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        Template template = this.myTemplateHandle.getTemplate();
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(AndroidBundle.message("android.wizard.module.new.module.menu.description", new Object[0])).withDryRun(dryRun).withShowErrors(true).withModuleRoot(moduleRoot).withParams(templateValues).build();
        return template.render(context, dryRun);
    }
}

