/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.dynamicapp;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.dynamicapp.ConfigureDynamicModuleStep;
import com.android.tools.idea.npw.dynamicapp.DynamicFeatureModel;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewDynamicAppModuleDescriptionProvider
implements ModuleDescriptionProvider {
    public static final String DYNAMIC_FEATURE_TEMPLATE = "Dynamic Feature";
    public static final String INSTANT_DYNAMIC_FEATURE_TEMPLATE = "Dynamic Feature (Instant App)";

    public Collection<ModuleGalleryEntry> getDescriptions(Project project) {
        if (((Boolean)StudioFlags.UAB_INSTANT_DYNAMIC_FEATURE_MODULE.get()).booleanValue() && !this.hasFeaturePlugin(project)) {
            return ImmutableList.of((Object)new FeatureTemplateGalleryEntry(false), (Object)new FeatureTemplateGalleryEntry(true));
        }
        return ImmutableList.of((Object)new FeatureTemplateGalleryEntry(false));
    }

    private boolean hasFeaturePlugin(Project project) {
        return (Boolean)StudioFlags.UAB_HIDE_INSTANT_MODULES_FOR_NON_FEATURE_PLUGIN_PROJECTS.get() != false && AndroidGradleModuleUtils.projectContainsFeatureModule(project);
    }

    private static class FeatureTemplateGalleryEntry
    implements ModuleTemplateGalleryEntry {
        @NotNull
        private final File myTemplateFile;
        @NotNull
        private TemplateHandle myTemplateHandle;
        private boolean myIsInstant;

        FeatureTemplateGalleryEntry(boolean isInstant) {
            this.myTemplateFile = TemplateManager.getInstance().getTemplateFile("Application", isInstant ? NewDynamicAppModuleDescriptionProvider.INSTANT_DYNAMIC_FEATURE_TEMPLATE : NewDynamicAppModuleDescriptionProvider.DYNAMIC_FEATURE_TEMPLATE);
            this.myTemplateHandle = new TemplateHandle(this.myTemplateFile);
            this.myIsInstant = isInstant;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return ActivityGallery.getTemplateIcon(this.myTemplateHandle, false);
        }

        @Override
        @NotNull
        public String getName() {
            return AndroidBundle.message(this.myIsInstant ? "android.wizard.module.new.dynamic.module.instant" : "android.wizard.module.new.dynamic.module", new Object[0]);
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateHandle.getMetadata().getDescription();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public File getTemplateFile() {
            return this.myTemplateFile;
        }

        @Override
        @NotNull
        public FormFactor getFormFactor() {
            return FormFactor.MOBILE;
        }

        @Override
        public boolean isLibrary() {
            return false;
        }

        @Override
        public boolean isInstantApp() {
            return false;
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model2) {
            Project project = model2.getProject().getValue();
            String basePackage = NewProjectModel.getSuggestedProjectPackage(project, false);
            return new ConfigureDynamicModuleStep(new DynamicFeatureModel(project, this.myTemplateHandle, model2.getProjectSyncInvoker(), this.myIsInstant), basePackage, this.myIsInstant);
        }
    }
}

