/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.ideahost;

import com.android.tools.idea.help.StudioHelpManagerImpl;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.ui.wizard.deprecated.StudioWizardLayout;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.util.Disposer;
import java.awt.Window;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeaWizardAdapter
implements ModelWizard.WizardListener,
WizardDelegate,
Disposable {
    @NotNull
    private final ListenerManager myListeners = new ListenerManager();
    @NotNull
    private final ModelWizardDialog.CustomLayout myCustomLayout = new StudioWizardLayout();
    @NotNull
    private final AbstractWizard myHostWizard;
    @NotNull
    private final ModelWizard myGuestWizard;

    IdeaWizardAdapter(@NotNull AbstractWizard host, @NotNull ModelWizard guest) {
        this.myHostWizard = host;
        this.myGuestWizard = guest;
        this.myGuestWizard.addResultListener(this);
        this.myListeners.listenAll(this.myGuestWizard.canGoBack(), this.myGuestWizard.canGoForward(), this.myGuestWizard.onLastStep()).withAndFire(this::updateButtons);
        Disposer.register((Disposable)this.myHostWizard.getDisposable(), (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myGuestWizard);
        Disposer.register((Disposable)this, (Disposable)this.myCustomLayout);
    }

    private void updateButtons() {
        this.myHostWizard.updateButtons(((Boolean)this.myGuestWizard.onLastStep().get()).booleanValue(), ((Boolean)this.myGuestWizard.canGoForward().get()).booleanValue(), (Boolean)this.myGuestWizard.canGoBack().get() == false);
    }

    @Override
    public void onWizardFinished(@NotNull ModelWizard.WizardResult result2) {
        this.myHostWizard.close(1, result2.isFinished());
    }

    @Override
    public void onWizardAdvanceError(@NotNull Exception e) {
        DialogEarthquakeShaker.shake((Window)this.myHostWizard.getWindow());
    }

    public void doNextAction() {
        assert (((Boolean)this.myGuestWizard.canGoForward().get()).booleanValue());
        this.myGuestWizard.goForward();
        this.updateButtons();
    }

    public void doPreviousAction() {
        assert (((Boolean)this.myGuestWizard.canGoBack().get()).booleanValue());
        this.myGuestWizard.goBack();
        this.updateButtons();
    }

    public void doFinishAction() {
        assert (((Boolean)this.myGuestWizard.canGoForward().get()).booleanValue());
        assert (((Boolean)this.myGuestWizard.onLastStep().get()).booleanValue());
        this.myGuestWizard.goForward();
        this.updateButtons();
    }

    public boolean canProceed() {
        return (Boolean)this.myGuestWizard.canGoForward().get();
    }

    public void dispose() {
        this.myListeners.releaseAll();
        this.myGuestWizard.removeResultListener(this);
    }

    @NotNull
    public ModuleWizardStep getProxyStep() {
        return new ModuleWizardStep(){

            public JComponent getComponent() {
                return IdeaWizardAdapter.this.myCustomLayout.decorate(IdeaWizardAdapter.this.myGuestWizard.getTitleHeader(), IdeaWizardAdapter.this.myGuestWizard.getContentPanel());
            }

            public void updateDataModel() {
            }

            @Nullable
            public String getHelpId() {
                return StudioHelpManagerImpl.STUDIO_HELP_PREFIX + "studio/projects/create-project.html";
            }
        };
    }
}

