/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.npw.importing.ArchiveToGradleModuleModel;
import com.android.tools.idea.npw.importing.ArchiveToGradleModuleStep;
import com.android.tools.idea.npw.importing.SourceToGradleModuleModel;
import com.android.tools.idea.npw.importing.SourceToGradleModuleStep;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportModuleGalleryEntryProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleGalleryEntry> getDescriptions(Project project) {
        return ImmutableList.of((Object)new SourceImportModuleGalleryEntry(AndroidBundle.message("android.wizard.module.import.eclipse.title", new Object[0])), (Object)new SourceImportModuleGalleryEntry(AndroidBundle.message("android.wizard.module.import.gradle.title", new Object[0])), (Object)new ArchiveImportModuleGalleryEntry());
    }

    private static class ArchiveImportModuleGalleryEntry
    implements ModuleGalleryEntry {
        private ArchiveImportModuleGalleryEntry() {
        }

        @Override
        @Nullable
        public Icon getIcon() {
            File androidModuleTemplate = TemplateManager.getInstance().getTemplateFile("Application", "Android Project");
            return ActivityGallery.getTemplateIcon(new TemplateHandle(androidModuleTemplate), false);
        }

        @Override
        @NotNull
        public String getName() {
            return AndroidBundle.message("android.wizard.module.import.title", new Object[0]);
        }

        @Override
        @Nullable
        public String getDescription() {
            return AndroidBundle.message("android.wizard.module.import.description", new Object[0]);
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model2) {
            return new ArchiveToGradleModuleStep(new ArchiveToGradleModuleModel(model2.getProject().getValue(), model2.getProjectSyncInvoker()));
        }
    }

    private static class SourceImportModuleGalleryEntry
    implements ModuleGalleryEntry {
        @NotNull
        private final TemplateHandle myTemplateHandle;

        SourceImportModuleGalleryEntry(String templateName) {
            this.myTemplateHandle = new TemplateHandle(TemplateManager.getInstance().getTemplateFile("Application", templateName));
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return ActivityGallery.getTemplateIcon(this.myTemplateHandle, false);
        }

        @Override
        @NotNull
        public String getName() {
            return this.myTemplateHandle.getMetadata().getTitle();
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateHandle.getMetadata().getDescription();
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model2) {
            return new SourceToGradleModuleStep(new SourceToGradleModuleModel(model2.getProject().getValue(), model2.getProjectSyncInvoker()));
        }
    }
}

