/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.importing.ImportUIUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleListModel {
    @Nullable
    private final Project myProject;
    private Map<ModuleToImport, ModuleValidationState> myModules;
    private Multimap<ModuleToImport, ModuleToImport> myRequiredModules;
    @Nullable
    private VirtualFile mySelectedDirectory;
    private Map<ModuleToImport, String> myNameOverrides = Maps.newHashMap();
    private ModuleToImport myPrimaryModule;
    private Map<ModuleToImport, Boolean> myExplicitSelection = Maps.newHashMap();

    public ModuleListModel(@Nullable Project project) {
        this.myProject = project;
    }

    @Nullable
    private static ModuleToImport findPrimaryModule(@Nullable VirtualFile directory, @NotNull Iterable<ModuleToImport> modules) {
        if (directory == null) {
            return null;
        }
        for (ModuleToImport module : modules) {
            if (!Objects.equal((Object)module.location, (Object)directory)) continue;
            return module;
        }
        return null;
    }

    private static boolean isValidModuleName(String moduleName) {
        if (StringUtil.isEmpty((String)moduleName)) {
            return false;
        }
        int previousSegmentStart = 0;
        int segmentSeparator = moduleName.indexOf(58, previousSegmentStart);
        while (segmentSeparator >= 0) {
            if (!ModuleListModel.isValidPathSegment(moduleName, previousSegmentStart, segmentSeparator)) {
                return false;
            }
            previousSegmentStart = segmentSeparator + 1;
            segmentSeparator = moduleName.indexOf(58, previousSegmentStart);
        }
        return ModuleListModel.isValidPathSegment(moduleName, previousSegmentStart, moduleName.length());
    }

    private static boolean isValidPathSegment(String string, int segmentStart, int segmentEnd) {
        if (segmentEnd == segmentStart) {
            return segmentStart == 0;
        }
        String segment = string.substring(segmentStart, segmentEnd);
        return !StringUtil.isEmpty((String)segment) && GradleUtil.isValidGradlePath(segment) < 0;
    }

    private static String getNameErrorMessage(String moduleName) {
        if (StringUtil.isEmptyOrSpaces((String)moduleName)) {
            return "Module name is empty";
        }
        return "Module name is not valid";
    }

    private Multimap<ModuleToImport, ModuleToImport> computeRequiredModules(Set<ModuleToImport> modules) {
        HashMap namesToModules = Maps.newHashMapWithExpectedSize((int)modules.size());
        for (ModuleToImport module : modules) {
            namesToModules.put(module.name, module);
        }
        LinkedListMultimap requiredModules = LinkedListMultimap.create();
        LinkedList queue = Lists.newLinkedList();
        for (ModuleToImport module : modules) {
            if (!Objects.equal((Object)module, (Object)this.myPrimaryModule) && this.isUnselected(module, false)) continue;
            queue.add(module);
        }
        while (!queue.isEmpty()) {
            ModuleToImport moduleToImport = (ModuleToImport)queue.remove();
            for (ModuleToImport dep : Iterables.transform(moduleToImport.getDependencies(), (Function)Functions.forMap((Map)namesToModules, null))) {
                if (dep == null) continue;
                if (!requiredModules.containsKey((Object)dep)) {
                    queue.add(dep);
                }
                requiredModules.put((Object)dep, (Object)moduleToImport);
            }
        }
        return requiredModules;
    }

    private boolean isUnselected(ModuleToImport module, boolean isSelected) {
        if (module.location == null) {
            return true;
        }
        if (Objects.equal((Object)this.myPrimaryModule, (Object)module)) {
            return false;
        }
        if (this.myModules.get(module) == ModuleValidationState.ALREADY_EXISTS) {
            return !Objects.equal((Object)true, (Object)this.myExplicitSelection.get(module));
        }
        return !isSelected && this.isExplicitlyUnselected(module);
    }

    private ModuleValidationState validateModule(ModuleToImport module) {
        VirtualFile location = module.location;
        if (location == null || !location.exists()) {
            return ModuleValidationState.NOT_FOUND;
        }
        String moduleName = this.getModuleName(module);
        if (!ModuleListModel.isValidModuleName(moduleName)) {
            return ModuleValidationState.INVALID_NAME;
        }
        if (GradleUtil.hasModule(this.myProject, moduleName)) {
            return ModuleValidationState.ALREADY_EXISTS;
        }
        return ModuleValidationState.OK;
    }

    public void setContents(@Nullable VirtualFile selectedDirectory, @NotNull Iterable<ModuleToImport> modules) {
        this.mySelectedDirectory = selectedDirectory;
        this.myPrimaryModule = ModuleListModel.findPrimaryModule(selectedDirectory, modules);
        this.revalidate(modules);
    }

    private void checkForDuplicateNames() {
        Set<ModuleToImport> modules = this.getSelectedModules();
        ImmutableMultiset names = ImmutableMultiset.copyOf((Iterable)Iterables.transform(modules, (Function)new Function<ModuleToImport, String>(){

            public String apply(@Nullable ModuleToImport input) {
                return input == null ? null : ModuleListModel.this.getModuleName(input);
            }
        }));
        for (ModuleToImport module : modules) {
            ModuleValidationState state = this.myModules.get(module);
            if (state != ModuleValidationState.OK || names.count((Object)this.getModuleName(module)) <= 1) continue;
            this.myModules.put(module, ModuleValidationState.DUPLICATE_MODULE_NAME);
        }
    }

    public Set<ModuleToImport> getSelectedModules() {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.myModules.keySet(), (Predicate)new Predicate<ModuleToImport>(){

            public boolean apply(@Nullable ModuleToImport input) {
                assert (input != null);
                return ModuleListModel.this.isSelected(input);
            }
        }));
    }

    public boolean hasPrimary() {
        return this.myPrimaryModule != null;
    }

    public String getModuleName(ModuleToImport module) {
        if (this.myNameOverrides.containsKey(module) && !this.isRequiredModule(module)) {
            return this.myNameOverrides.get(module);
        }
        return module.name;
    }

    public ModuleValidationState getModuleState(ModuleToImport module) {
        if (module == null) {
            return ModuleValidationState.NULL;
        }
        ModuleValidationState state = this.myModules.get(module);
        if (state == ModuleValidationState.OK && this.isRequiredModule(module)) {
            return ModuleValidationState.REQUIRED;
        }
        return state;
    }

    private boolean isRequiredModule(ModuleToImport module) {
        return this.myRequiredModules.containsKey((Object)module);
    }

    private Map<ModuleToImport, ModuleValidationState> validateModules(Iterable<ModuleToImport> modules) {
        HashMap result2 = Maps.newHashMap();
        for (ModuleToImport module : modules) {
            result2.put(module, this.validateModule(module));
        }
        return result2;
    }

    public void setSelected(ModuleToImport module, boolean isSelected) {
        this.myExplicitSelection.put(module, isSelected);
        this.revalidate(this.myModules.keySet());
    }

    private void revalidate(Iterable<ModuleToImport> modules) {
        this.myModules = this.validateModules(modules);
        this.myRequiredModules = this.computeRequiredModules(this.myModules.keySet());
        for (ModuleToImport module : this.myRequiredModules.keySet()) {
            this.myNameOverrides.remove(module);
        }
        this.checkForDuplicateNames();
    }

    public void setModuleName(ModuleToImport module, @Nullable String newName2) {
        if (!this.isExplicitlyUnselected(module)) {
            if (newName2 == null) {
                this.myNameOverrides.remove(module);
            } else {
                this.myNameOverrides.put(module, newName2);
            }
            this.revalidate(this.myModules.keySet());
        }
    }

    private boolean isExplicitlyUnselected(ModuleToImport module) {
        return Objects.equal((Object)false, (Object)this.myExplicitSelection.get(module));
    }

    @Nullable
    public MessageType getStatusSeverity(ModuleToImport module) {
        ModuleValidationState state = this.getModuleState(module);
        switch (state) {
            case OK: 
            case NULL: {
                return null;
            }
            case NOT_FOUND: 
            case DUPLICATE_MODULE_NAME: 
            case INVALID_NAME: {
                return MessageType.ERROR;
            }
            case ALREADY_EXISTS: {
                return this.getSelectedModules().contains(module) ? MessageType.ERROR : MessageType.WARNING;
            }
            case REQUIRED: {
                return MessageType.INFO;
            }
        }
        throw new IllegalArgumentException(state.name());
    }

    @Nullable
    public String getStatusDescription(@NotNull ModuleToImport module) {
        ModuleValidationState state = this.getModuleState(module);
        switch (state) {
            case OK: 
            case NULL: {
                return null;
            }
            case NOT_FOUND: {
                return "Module sources not found";
            }
            case ALREADY_EXISTS: {
                if (this.isSelected(module) && this.isRequiredModule(module)) {
                    return "Cannot rename module required by another";
                }
                return "Project already contains module with this name";
            }
            case DUPLICATE_MODULE_NAME: {
                return "More then one module with this name is selected";
            }
            case REQUIRED: {
                Iterable requiredBy = Iterables.transform((Iterable)this.myRequiredModules.get((Object)module), (Function)new Function<ModuleToImport, String>(){

                    public String apply(ModuleToImport input) {
                        return "'" + ModuleListModel.this.getModuleName(input) + "'";
                    }
                });
                return ImportUIUtil.formatElementListString(requiredBy, "Required by module %s", "Required by modules %s and %s", "Required by modules %s and %d more");
            }
            case INVALID_NAME: {
                return ModuleListModel.getNameErrorMessage(this.getModuleName(module));
            }
        }
        throw new IllegalStateException(state.name());
    }

    @Nullable
    public ModuleToImport getPrimary() {
        return this.myPrimaryModule;
    }

    @Nullable
    public VirtualFile getCurrentPath() {
        return this.mySelectedDirectory;
    }

    public Collection<ModuleToImport> getAllModules() {
        return ImmutableList.copyOf(this.myModules.keySet());
    }

    public boolean isSelected(@NotNull ModuleToImport module) {
        return !this.isUnselected(module, this.isRequiredModule(module));
    }

    public boolean canToggleModuleSelection(ModuleToImport module) {
        ModuleValidationState state = this.getModuleState(module);
        return state != ModuleValidationState.NOT_FOUND && !this.isRequiredModule(module);
    }

    public boolean canRename(ModuleToImport module) {
        return !this.isRequiredModule(module) && this.isSelected(module);
    }

    public static enum ModuleValidationState {
        OK,
        NULL,
        NOT_FOUND,
        ALREADY_EXISTS,
        REQUIRED,
        DUPLICATE_MODULE_NAME,
        INVALID_NAME;

    }
}

