/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.instantapp;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.instantapp.ConfigureInstantAppModuleStep;
import com.android.tools.idea.npw.instantapp.NewInstantAppModuleModel;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStep;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewInstantAppModuleDescriptionProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleGalleryEntry> getDescriptions(Project project) {
        if (((Boolean)StudioFlags.UAB_HIDE_INSTANT_MODULES_FOR_NON_FEATURE_PLUGIN_PROJECTS.get()).booleanValue() && !AndroidGradleModuleUtils.projectContainsFeatureModule(project)) {
            return Arrays.asList(new ModuleGalleryEntry[0]);
        }
        return Arrays.asList(new FeatureTemplateGalleryEntry(), new ApplicationTemplateGalleryEntry());
    }

    private static class ApplicationTemplateGalleryEntry
    implements ModuleGalleryEntry {
        @NotNull
        private TemplateHandle myTemplateHandle = new TemplateHandle(TemplateManager.getInstance().getTemplateFile("Application", "Instant App"));

        ApplicationTemplateGalleryEntry() {
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return ActivityGallery.getTemplateIcon(this.myTemplateHandle, false);
        }

        @Override
        @NotNull
        public String getName() {
            return this.myTemplateHandle.getMetadata().getTitle();
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateHandle.getMetadata().getDescription();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model2) {
            return new ConfigureInstantAppModuleStep(new NewInstantAppModuleModel(model2.getProject().getValue(), this.myTemplateHandle, model2.getProjectSyncInvoker()), this.getName());
        }
    }

    private static class FeatureTemplateGalleryEntry
    implements ModuleTemplateGalleryEntry {
        @NotNull
        private final TemplateHandle myTemplateHandle;

        FeatureTemplateGalleryEntry() {
            String moduleName = AndroidBundle.message("android.wizard.module.new.feature.module", new Object[0]);
            this.myTemplateHandle = new TemplateHandle(TemplateManager.getInstance().getTemplateFile("Application", moduleName));
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return ActivityGallery.getTemplateIcon(this.myTemplateHandle, false);
        }

        @Override
        @NotNull
        public String getName() {
            return this.myTemplateHandle.getMetadata().getTitle();
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateHandle.getMetadata().getDescription();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public File getTemplateFile() {
            return TemplateManager.getInstance().getTemplateFile("Application", "Android Module");
        }

        @Override
        @NotNull
        public FormFactor getFormFactor() {
            return FormFactor.MOBILE;
        }

        @Override
        public boolean isLibrary() {
            return true;
        }

        @Override
        public boolean isInstantApp() {
            return true;
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model2) {
            String basePackage = NewProjectModel.getSuggestedProjectPackage(model2.getProject().getValue(), true);
            return new ConfigureAndroidModuleStep(model2, FormFactor.MOBILE, this.myTemplateHandle.getMetadata().getMinSdk(), basePackage, true, true, this.getDescription());
        }
    }
}

