/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.instantapp;

import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewInstantAppModuleModel
extends WizardModel {
    @NotNull
    private final Project myProject;
    @NotNull
    private final TemplateHandle myTemplateHandle;
    @NotNull
    private final ProjectSyncInvoker myProjectSyncInvoker;
    @NotNull
    private final StringProperty myModuleName = new StringValueProperty("instantapp");
    @NotNull
    private final BoolProperty myCreateGitIgnore = new BoolValueProperty(true);

    public NewInstantAppModuleModel(@NotNull Project project, @NotNull TemplateHandle templateHandle, @NotNull ProjectSyncInvoker projectSyncInvoker) {
        this.myProject = project;
        this.myTemplateHandle = templateHandle;
        this.myProjectSyncInvoker = projectSyncInvoker;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public StringProperty moduleName() {
        return this.myModuleName;
    }

    @NotNull
    public BoolProperty createGitIgnore() {
        return this.myCreateGitIgnore;
    }

    @Override
    protected void handleFinished() {
        File moduleRoot = NewModuleModel.getModuleRoot(this.myProject.getBasePath(), (String)this.moduleName().get());
        HashMap myTemplateValues = Maps.newHashMap();
        myTemplateValues.put("topOut", this.myProject.getBasePath());
        myTemplateValues.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getAbsolutePath()));
        myTemplateValues.put("projectName", this.moduleName().get());
        myTemplateValues.put("makeIgnore", this.createGitIgnore().get());
        TemplateValueInjector injector = new TemplateValueInjector(myTemplateValues);
        injector.addGradleVersions(this.myProject);
        if (this.doDryRun(moduleRoot, myTemplateValues)) {
            this.render(moduleRoot, myTemplateValues);
        }
    }

    private boolean doDryRun(@NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        return this.renderTemplate(true, this.myProject, moduleRoot, templateValues, null);
    }

    private void render(@NotNull File moduleRoot, @NotNull Map<String, Object> templateValues) {
        ArrayList<File> filesToOpen = new ArrayList<File>();
        boolean success = this.renderTemplate(false, this.myProject, moduleRoot, templateValues, filesToOpen);
        if (success) {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> TemplateUtils.openEditors(this.myProject, filesToOpen, true));
            this.myProjectSyncInvoker.syncProject(this.myProject);
        }
    }

    private boolean renderTemplate(boolean dryRun, @NotNull Project project, @NotNull File moduleRoot, @NotNull Map<String, Object> templateValues, @Nullable List<File> filesToOpen) {
        Template template = this.myTemplateHandle.getTemplate();
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(AndroidBundle.message("android.wizard.module.new.module.menu.description", new Object[0])).withDryRun(dryRun).withShowErrors(true).withModuleRoot(moduleRoot).withParams(templateValues).intoOpenFiles(filesToOpen).build();
        return template.render(context, dryRun);
    }
}

