/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.java;

import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.java.NewJavaModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.validator.ClassNameValidator;
import com.android.tools.idea.npw.validator.ModuleValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureJavaModuleStep
extends SkippableWizardStep<NewJavaModuleModel> {
    @NotNull
    private final StudioWizardStepPanel myRootPanel;
    @NotNull
    private ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private JPanel myPanel;
    private JTextField myLibraryName;
    private LabelWithEditButton myPackageName;
    private JTextField myClassName;
    private JCheckBox myCreateIgnoreFile;

    public ConfigureJavaModuleStep(@NotNull NewJavaModuleModel model2, String title) {
        super(model2, title);
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        ModuleValidator moduleValidator = new ModuleValidator(model2.getProject());
        this.myLibraryName.setText(WizardUtils.getUniqueName((String)model2.libraryNameName().get(), moduleValidator));
        TextProperty libraryNameText = new TextProperty(this.myLibraryName);
        this.myBindings.bind(model2.libraryNameName(), libraryNameText, this.myValidatorPanel.hasErrors().not());
        this.myBindings.bindTwoWay(new TextProperty(this.myClassName), model2.className());
        DomainToPackageExpression computedPackageName = new DomainToPackageExpression(new StringValueProperty(NewProjectModel.getInitialDomain(false)), model2.libraryNameName());
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myBindings.bind(model2.packageName(), packageNameText);
        this.myListeners.listen(packageNameText, value2 -> isPackageNameSynced.set(value2.equals(computedPackageName.get())));
        this.myBindings.bindTwoWay(new SelectedProperty(this.myCreateIgnoreFile), model2.createGitIgnore());
        this.myValidatorPanel.registerValidator((ObservableValue)libraryNameText, (Validator)moduleValidator);
        this.myValidatorPanel.registerValidator((ObservableValue)model2.packageName(), value2 -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value2)));
        this.myValidatorPanel.registerValidator((ObservableValue)model2.className(), (Validator)new ClassNameValidator());
        this.myRootPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        return Lists.newArrayList();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myValidatorPanel.hasErrors().not();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myRootPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myLibraryName;
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        LabelWithEditButton labelWithEditButton;
        JTextField jTextField2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myLibraryName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Library name:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Java package name:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Java class name:");
        jLabel3.setDisplayedMnemonic('J');
        jLabel3.setDisplayedMnemonicIndex(0);
        ((Component)jLabel3).setVisible(true);
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageName = labelWithEditButton = new LabelWithEditButton();
        jPanel.add((Component)labelWithEditButton, new GridConstraints(2, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myClassName = jTextField = new JTextField();
        jTextField.setName("ClassName");
        ((Component)jTextField).setVisible(true);
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCreateIgnoreFile = jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand("Create .ignore file");
        jCheckBox.setText("Create .gitignore file");
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, 20, jBLabel.getFont());
        if (font != null) {
            jBLabel.setFont(font);
        }
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.wizard.module.config.title"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, new Dimension(-1, 50), null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor((Component)labelWithEditButton);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

