/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.tools.idea.npw.template.ConvertJavaToKotlinProvider;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaToKotlinHandler {
    private JavaToKotlinHandler() {
    }

    @NotNull
    public static ConvertJavaToKotlinProvider getJavaToKotlinConversionProvider() {
        ConvertJavaToKotlinProvider[] providers = (ConvertJavaToKotlinProvider[])ConvertJavaToKotlinProvider.EP_NAME.getExtensions();
        if (providers.length == 0) {
            throw new RuntimeException("Could not find a ConvertJavaToKotlinProvider, even though the Kotlin plugin is bundled with Studio.\nIs the Kotlin plugin disabled?");
        }
        return providers[0];
    }

    static void convertJavaFilesToKotlin(@NotNull Project project, @NotNull List<File> files2, @NotNull Runnable postProcessFunction) {
        if (!JavaToKotlinHandler.hasJavaFiles(files2)) {
            DumbService.getInstance((Project)project).smartInvokeLater(postProcessFunction);
            return;
        }
        ConvertJavaToKotlinProvider provider = JavaToKotlinHandler.getJavaToKotlinConversionProvider();
        Disposable tempDisposable = Disposer.newDisposable();
        project.getMessageBus().connect(tempDisposable).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
            if (result2 == ProjectSystemSyncManager.SyncResult.SUCCESS || result2 == ProjectSystemSyncManager.SyncResult.FAILURE) {
                JavaToKotlinHandler.callConverter(project, provider, files2, postProcessFunction);
                Disposer.dispose((Disposable)tempDisposable);
            }
        });
    }

    static boolean hasJavaFiles(@NotNull List<File> files2) {
        return files2.stream().anyMatch(file -> file.getName().endsWith(".java"));
    }

    private static void callConverter(@NotNull Project project, @NotNull ConvertJavaToKotlinProvider provider, @NotNull List<File> files2, @NotNull Runnable postProcessFunction) {
        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            List<PsiJavaFile> psiJavaFiles = JavaToKotlinHandler.files2PsiJavaFiles(project, files2);
            if (!psiJavaFiles.isEmpty()) {
                provider.convertToKotlin(project, psiJavaFiles);
            }
            postProcessFunction.run();
        });
    }

    private static List<PsiJavaFile> files2PsiJavaFiles(Project project, List<File> files2) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        ArrayList psiJavaFiles = Lists.newArrayListWithExpectedSize((int)files2.size());
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (File file : files2) {
            PsiFile psiFile;
            VirtualFile virtualFile = localFileSystem.findFileByIoFile(file);
            if (virtualFile == null || !((psiFile = psiManager.findFile(virtualFile)) instanceof PsiJavaFile)) continue;
            psiJavaFiles.add((PsiJavaFile)psiFile);
        }
        return psiJavaFiles;
    }
}

