/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.project.IndexingSuspender;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultiTemplateRenderer {
    private static final Topic<TemplateRendererListener> TEMPLATE_RENDERER_TOPIC = new Topic("Template rendering", TemplateRendererListener.class);
    @Nullable
    private Project myProject;
    @NotNull
    private final ProjectSyncInvoker myProjectSyncInvoker;
    private final List<TemplateRenderer> myTemplateRenderers = new ArrayList<TemplateRenderer>();
    private int myRequestCount = 1;

    public MultiTemplateRenderer(@Nullable Project project, @NotNull ProjectSyncInvoker projectSyncInvoker) {
        this.myProject = project;
        this.myProjectSyncInvoker = projectSyncInvoker;
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull TemplateRendererListener listener2) {
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(TEMPLATE_RENDERER_TOPIC, (Object)listener2);
        return connection;
    }

    public static void multiRenderingStarted(@NotNull Project project) {
        ((TemplateRendererListener)project.getMessageBus().syncPublisher(TEMPLATE_RENDERER_TOPIC)).multiRenderingStarted();
    }

    public static void multiRenderingFinished(@NotNull Project project) {
        ((TemplateRendererListener)project.getMessageBus().syncPublisher(TEMPLATE_RENDERER_TOPIC)).multiRenderingFinished();
    }

    public void setProject(@NotNull Project project) {
        this.myProject = project;
    }

    public void incrementRenders() {
        ++this.myRequestCount;
    }

    public void requestRender(@NotNull TemplateRenderer templateRenderer) {
        this.myTemplateRenderers.add(templateRenderer);
        this.countDown();
    }

    public void skipRender() {
        this.countDown();
    }

    private void countDown() {
        if (this.myRequestCount == 0) {
            throw new IllegalStateException("Invalid extra call to MultiTemplateRenderer#countDown");
        }
        --this.myRequestCount;
        if (this.myRequestCount == 0 && !this.myTemplateRenderers.isEmpty()) {
            assert (this.myProject != null) : "Project instance is always expected to be not null at this point.";
            IndexingSuspender.ensureInitialised(this.myProject);
            MultiTemplateRenderer.multiRenderingStarted(this.myProject);
            try {
                for (TemplateRenderer renderer : this.myTemplateRenderers) {
                    renderer.init();
                }
                for (TemplateRenderer renderer : this.myTemplateRenderers) {
                    if (renderer.doDryRun()) continue;
                    return;
                }
                for (TemplateRenderer renderer : this.myTemplateRenderers) {
                    renderer.render();
                }
                if (this.myProject.isInitialized()) {
                    this.myProjectSyncInvoker.syncProject(this.myProject);
                }
            }
            finally {
                MultiTemplateRenderer.multiRenderingFinished(this.myProject);
            }
        }
    }

    public static interface TemplateRenderer {
        default public void init() {
        }

        public boolean doDryRun();

        public void render();
    }

    public static interface TemplateRendererListener {
        default public void multiRenderingStarted() {
        }

        default public void multiRenderingFinished() {
        }
    }
}

