/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.npw.model.MultiTemplateRenderer;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.BatchInvoker;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableString;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.string.StringExpression;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewModuleModel
extends WizardModel {
    private final BindingsManager myBindings = new BindingsManager(BatchInvoker.INVOKE_IMMEDIATELY_STRATEGY);
    @NotNull
    private final StringProperty myModuleName = new StringValueProperty();
    @NotNull
    private final StringProperty mySplitName = new StringValueProperty("feature");
    @NotNull
    private final BoolProperty myIsLibrary = new BoolValueProperty();
    @NotNull
    private final OptionalProperty<File> myTemplateFile = new OptionalValueProperty<File>();
    @NotNull
    private final OptionalProperty<Map<String, Object>> myRenderTemplateValues = new OptionalValueProperty<Map<String, Object>>();
    @NotNull
    private final Map<String, Object> myTemplateValues = Maps.newHashMap();
    @NotNull
    private final StringProperty myApplicationName;
    @NotNull
    private final StringProperty myProjectLocation;
    @NotNull
    private final StringProperty myPackageName = new StringValueProperty();
    @NotNull
    private final StringProperty myProjectPackageName;
    @NotNull
    private final BoolProperty myIsInstantApp = new BoolValueProperty();
    @NotNull
    private final BoolProperty myEnableCppSupport;
    @NotNull
    private final OptionalValueProperty<Language> myLanguage;
    @NotNull
    private final OptionalProperty<Project> myProject;
    @NotNull
    private final ProjectSyncInvoker myProjectSyncInvoker;
    @NotNull
    private final MultiTemplateRenderer myMultiTemplateRenderer;
    private final boolean myCreateInExistingProject;

    public NewModuleModel(@NotNull Project project, @NotNull ProjectSyncInvoker projectSyncInvoker) {
        this.myModuleName.addConstraint(String::trim);
        this.mySplitName.addConstraint(String::trim);
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myProjectSyncInvoker = projectSyncInvoker;
        this.myProjectPackageName = this.myPackageName;
        this.myCreateInExistingProject = true;
        this.myEnableCppSupport = new BoolValueProperty();
        this.myLanguage = new OptionalValueProperty<Language>(RenderTemplateModel.getInitialSourceLanguage(project));
        this.myApplicationName = new StringValueProperty(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
        this.myApplicationName.addConstraint(String::trim);
        this.myProjectLocation = new StringValueProperty(project.getBasePath());
        this.myIsLibrary.addListener(() -> this.updateApplicationName());
        this.myIsInstantApp.addListener(() -> this.updateApplicationName());
        this.myMultiTemplateRenderer = new MultiTemplateRenderer(project, projectSyncInvoker);
    }

    public NewModuleModel(@NotNull NewProjectModel projectModel, @NotNull File templateFile) {
        this.myModuleName.addConstraint(String::trim);
        this.mySplitName.addConstraint(String::trim);
        this.myProject = projectModel.project();
        this.myProjectPackageName = projectModel.packageName();
        this.myProjectSyncInvoker = projectModel.getProjectSyncInvoker();
        this.myCreateInExistingProject = false;
        this.myEnableCppSupport = projectModel.enableCppSupport();
        this.myApplicationName = projectModel.applicationName();
        this.myProjectLocation = projectModel.projectLocation();
        this.myTemplateFile.setValue(templateFile);
        this.myMultiTemplateRenderer = projectModel.getMultiTemplateRenderer();
        this.myMultiTemplateRenderer.incrementRenders();
        this.myLanguage = new OptionalValueProperty();
        this.myBindings.bind(this.myPackageName, this.myProjectPackageName, this.myIsInstantApp.not());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myBindings.releaseAll();
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        return this.myProject;
    }

    @NotNull
    public ProjectSyncInvoker getProjectSyncInvoker() {
        return this.myProjectSyncInvoker;
    }

    @NotNull
    public StringProperty applicationName() {
        return this.myApplicationName;
    }

    @NotNull
    public StringProperty projectLocation() {
        return this.myProjectLocation;
    }

    @NotNull
    public StringProperty moduleName() {
        return this.myModuleName;
    }

    @NotNull
    public StringProperty splitName() {
        return this.mySplitName;
    }

    @NotNull
    public StringProperty packageName() {
        return this.myPackageName;
    }

    @NotNull
    public BoolProperty isLibrary() {
        return this.myIsLibrary;
    }

    @NotNull
    public BoolProperty instantApp() {
        return this.myIsInstantApp;
    }

    @NotNull
    public BoolProperty enableCppSupport() {
        return this.myEnableCppSupport;
    }

    @NotNull
    public OptionalValueProperty<Language> language() {
        return this.myLanguage;
    }

    @NotNull
    public OptionalProperty<File> templateFile() {
        return this.myTemplateFile;
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        return this.myTemplateValues;
    }

    @NotNull
    public OptionalProperty<Map<String, Object>> getRenderTemplateValues() {
        return this.myRenderTemplateValues;
    }

    @NotNull
    public MultiTemplateRenderer getMultiTemplateRenderer() {
        return this.myMultiTemplateRenderer;
    }

    @NotNull
    public ObservableString computedFeatureModulePackageName() {
        return new StringExpression(new ObservableValue[]{this.myProjectPackageName, this.mySplitName}){

            @Override
            @NotNull
            public String get() {
                return (String)NewModuleModel.this.myProjectPackageName.get() + "." + (String)NewModuleModel.this.mySplitName.get();
            }
        };
    }

    public void setDefaultRenderTemplateValues(@NotNull RenderTemplateModel renderModel, @Nullable Project project) {
        HashMap renderTemplateValues = Maps.newHashMap();
        new TemplateValueInjector(renderTemplateValues).setBuildVersion(renderModel.androidSdkInfo().getValue(), project).setModuleRoots(((NamedModuleTemplate)renderModel.getTemplate().get()).getPaths(), project.getBasePath(), (String)this.moduleName().get(), (String)this.packageName().get());
        this.getRenderTemplateValues().setValue(renderTemplateValues);
    }

    @NotNull
    public static File getModuleRoot(@NotNull String projectLocation, @NotNull String moduleName) {
        moduleName = moduleName.replace(':', File.separatorChar);
        return new File(projectLocation, moduleName);
    }

    @Override
    protected void handleFinished() {
        this.myMultiTemplateRenderer.requestRender(new ModuleTemplateRenderer());
    }

    @Override
    protected void handleSkipped() {
        this.myMultiTemplateRenderer.skipRender();
    }

    private void updateApplicationName() {
        String msgId;
        if (((Boolean)this.myIsInstantApp.get()).booleanValue()) {
            boolean isNewBaseFeature = ((Optional)this.myProject.get()).isPresent() && InstantApps.findBaseFeature(this.myProject.getValue()) == null;
            msgId = isNewBaseFeature ? "android.wizard.module.config.new.base.feature" : "android.wizard.module.config.new.feature";
        } else {
            msgId = (Boolean)this.myIsLibrary.get() != false ? "android.wizard.module.config.new.library" : "android.wizard.module.config.new.application";
        }
        this.myApplicationName.set(AndroidBundle.message(msgId, new Object[0]));
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(NewModuleModel.class);
    }

    private class ModuleTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        Map<String, Object> myTemplateValues;

        private ModuleTemplateRenderer() {
        }

        @Override
        public boolean doDryRun() {
            if (NewModuleModel.this.myTemplateFile.getValueOrNull() == null) {
                return false;
            }
            if (!((Optional)NewModuleModel.this.myProject.get()).isPresent()) {
                NewModuleModel.getLog().error("NewModuleModel did not collect expected information and will not complete. Please report this error.");
                return false;
            }
            Map renderTemplateValues = (Map)NewModuleModel.this.myRenderTemplateValues.getValueOrNull();
            this.myTemplateValues = new HashMap<String, Object>(NewModuleModel.this.myTemplateValues);
            this.myTemplateValues.put("isLibraryProject", NewModuleModel.this.myIsLibrary.get());
            Project project = (Project)NewModuleModel.this.myProject.getValue();
            if (((Boolean)NewModuleModel.this.myIsInstantApp.get()).booleanValue()) {
                this.myTemplateValues.put("instantAppPackageName", NewModuleModel.this.myProjectPackageName.get());
                if (renderTemplateValues != null) {
                    new TemplateValueInjector(renderTemplateValues).setInstantAppSupport(NewModuleModel.this.myCreateInExistingProject, project, (String)NewModuleModel.this.myModuleName.get());
                }
                if (NewModuleModel.this.myCreateInExistingProject) {
                    boolean hasInstantAppWrapper = (Boolean)NewModuleModel.this.myIsInstantApp.get() != false && InstantApps.findBaseFeature(project) == null;
                    this.myTemplateValues.put("hasMonolithicAppWrapper", false);
                    this.myTemplateValues.put("hasInstantAppWrapper", hasInstantAppWrapper);
                }
            }
            if (renderTemplateValues != null) {
                if (((Optional)NewModuleModel.this.language().get()).isPresent()) {
                    new TemplateValueInjector(renderTemplateValues).setLanguage((Language)((Object)NewModuleModel.this.language().getValue()));
                }
                this.myTemplateValues.putAll(renderTemplateValues);
            }
            return this.renderModule(true, this.myTemplateValues, project, (String)NewModuleModel.this.myModuleName.get());
        }

        @Override
        public void render() {
            final Project project = (Project)NewModuleModel.this.myProject.getValue();
            boolean success = (Boolean)new WriteCommandAction<Boolean>(project, "New Module", new PsiFile[0]){

                protected void run(@NotNull Result<Boolean> result2) {
                    result2.setResult((Object)ModuleTemplateRenderer.this.renderModule(false, ModuleTemplateRenderer.this.myTemplateValues, project, (String)NewModuleModel.this.myModuleName.get()));
                }
            }.execute().getResultObject();
            if (!success) {
                NewModuleModel.getLog().warn("A problem occurred while creating a new Module. Please check the log file for possible errors.");
            }
        }

        private boolean renderModule(boolean dryRun, @NotNull Map<String, Object> templateState, @NotNull Project project, @NotNull String moduleName) {
            File projectRoot = new File(project.getBasePath());
            File moduleRoot = NewModuleModel.getModuleRoot(project.getBasePath(), moduleName);
            Template template = Template.createFromPath((File)NewModuleModel.this.myTemplateFile.getValue());
            ArrayList<File> filesToOpen = new ArrayList<File>();
            RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName("New Module").withDryRun(dryRun).withShowErrors(true).withOutputRoot(projectRoot).withModuleRoot(moduleRoot).intoOpenFiles(filesToOpen).withParams(templateState).build();
            boolean renderResult = template.render(context, dryRun);
            if (renderResult && !dryRun) {
                DumbService.getInstance((Project)project).smartInvokeLater(() -> TemplateUtils.openEditors(project, filesToOpen, false));
            }
            return renderResult;
        }
    }
}

