/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.repository.io.FileOpUtils;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.npw.model.MultiTemplateRenderer;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class NewProjectModel
extends WizardModel {
    static final String PROPERTIES_ANDROID_PACKAGE_KEY = "SAVED_ANDROID_PACKAGE";
    static final String PROPERTIES_KOTLIN_SUPPORT_KEY = "SAVED_PROJECT_KOTLIN_SUPPORT";
    static final String PROPERTIES_NPW_LANGUAGE_KEY = "SAVED_ANDROID_NPW_LANGUAGE";
    static final String PROPERTIES_NPW_ASKED_LANGUAGE_KEY = "SAVED_ANDROID_NPW_ASKED_LANGUAGE";
    private static final String PROPERTIES_DOMAIN_KEY = "SAVED_COMPANY_DOMAIN";
    private static final String PROPERTIES_CPP_SUPPORT_KEY = "SAVED_PROJECT_CPP_SUPPORT";
    private static final String EXAMPLE_DOMAIN = "example.com";
    private static final Pattern DISALLOWED_IN_DOMAIN = Pattern.compile("[^a-zA-Z0-9_]");
    private final StringProperty myApplicationName = new StringValueProperty(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
    private final StringProperty myCompanyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(true));
    private final StringProperty myPackageName = new StringValueProperty();
    private final StringProperty myProjectLocation = new StringValueProperty();
    private final BoolProperty myEnableCppSupport = new BoolValueProperty();
    private final StringProperty myCppFlags = new StringValueProperty();
    private final OptionalProperty<Project> myProject = new OptionalValueProperty<Project>();
    private final Map<String, Object> myTemplateValues = Maps.newHashMap();
    private final Set<NewModuleModel> myNewModels = new HashSet<NewModuleModel>();
    private final ProjectSyncInvoker myProjectSyncInvoker;
    private final MultiTemplateRenderer myMultiTemplateRenderer;
    private final OptionalValueProperty<Language> myLanguage = new OptionalValueProperty();
    private final BoolProperty myUseOfflineRepo = new BoolValueProperty();
    private final BoolProperty myUseAndroidx = new BoolValueProperty();

    private static Logger getLogger() {
        return Logger.getInstance(NewProjectModel.class);
    }

    public NewProjectModel() {
        this(new ProjectSyncInvoker.DefaultProjectSyncInvoker());
    }

    public NewProjectModel(@NotNull ProjectSyncInvoker projectSyncInvoker) {
        this.myProjectSyncInvoker = projectSyncInvoker;
        this.myMultiTemplateRenderer = new MultiTemplateRenderer(null, this.myProjectSyncInvoker);
        this.myCompanyDomain.addListener(() -> {
            String domain = (String)this.myCompanyDomain.get();
            if (AndroidUtils.isValidAndroidPackageName(domain)) {
                PropertiesComponent.getInstance().setValue(PROPERTIES_DOMAIN_KEY, domain);
            }
        });
        this.myPackageName.addListener(() -> {
            String androidPackage = (String)this.myPackageName.get();
            int lastDotIdx = androidPackage.lastIndexOf(46);
            if (lastDotIdx >= 0) {
                androidPackage = androidPackage.substring(0, lastDotIdx);
            }
            if (AndroidUtils.isValidAndroidPackageName(androidPackage)) {
                PropertiesComponent.getInstance().setValue(PROPERTIES_ANDROID_PACKAGE_KEY, androidPackage);
            }
        });
        this.myApplicationName.addConstraint(String::trim);
        this.myEnableCppSupport.set(NewProjectModel.getInitialCppSupport());
        this.myUseAndroidx.set(this.getInitialUseAndroidxSupport());
        this.myLanguage.set((Language)((Object)NewProjectModel.calculateInitialLanguage(PropertiesComponent.getInstance())));
    }

    @NotNull
    public ProjectSyncInvoker getProjectSyncInvoker() {
        return this.myProjectSyncInvoker;
    }

    public StringProperty packageName() {
        return this.myPackageName;
    }

    public StringProperty applicationName() {
        return this.myApplicationName;
    }

    public StringProperty companyDomain() {
        return this.myCompanyDomain;
    }

    public StringProperty projectLocation() {
        return this.myProjectLocation;
    }

    public BoolProperty enableCppSupport() {
        return this.myEnableCppSupport;
    }

    public StringProperty cppFlags() {
        return this.myCppFlags;
    }

    public OptionalValueProperty<Language> language() {
        return this.myLanguage;
    }

    @NotNull
    public BoolProperty useOfflineRepo() {
        return this.myUseOfflineRepo;
    }

    public boolean isAndroidxAvailable() {
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData == null) {
            return false;
        }
        for (IAndroidTarget target : sdkData.getTargets()) {
            if (target.getVersion().getApiLevel() < 28) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BoolProperty useAndroidx() {
        return this.myUseAndroidx;
    }

    public OptionalProperty<Project> project() {
        return this.myProject;
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        return this.myTemplateValues;
    }

    public Set<NewModuleModel> getNewModuleModels() {
        return this.myNewModels;
    }

    public MultiTemplateRenderer getMultiTemplateRenderer() {
        return this.myMultiTemplateRenderer;
    }

    @NotNull
    public static String getInitialDomain(boolean includeUserName) {
        String androidPackage = PropertiesComponent.getInstance().getValue(PROPERTIES_ANDROID_PACKAGE_KEY);
        if (androidPackage != null) {
            return new DomainToPackageExpression(new StringValueProperty(androidPackage), new StringValueProperty("")).get();
        }
        String domain = PropertiesComponent.getInstance().getValue(PROPERTIES_DOMAIN_KEY);
        if (domain != null) {
            return domain;
        }
        String userName = includeUserName ? System.getProperty("user.name") : null;
        return userName == null ? EXAMPLE_DOMAIN : NewProjectModel.toPackagePart(userName) + '.' + EXAMPLE_DOMAIN;
    }

    @NotNull
    public static String getSuggestedProjectPackage(@NotNull Project project, boolean isInstantApp) {
        String basePackage = null;
        if (isInstantApp) {
            AndroidFacet androidFacet;
            Module baseFeatureModule = InstantApps.findBaseFeature(project);
            AndroidFacet androidFacet2 = androidFacet = baseFeatureModule == null ? null : AndroidFacet.getInstance(baseFeatureModule);
            if (androidFacet != null && ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel() != null) {
                basePackage = AndroidPackageUtils.getPackageForApplication(androidFacet);
            }
        }
        if (basePackage == null) {
            StringValueProperty companyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(false));
            basePackage = new DomainToPackageExpression(companyDomain, new StringValueProperty("")).get();
        }
        return basePackage;
    }

    private static boolean getInitialCppSupport() {
        return PropertiesComponent.getInstance().isTrueValue(PROPERTIES_CPP_SUPPORT_KEY);
    }

    @NotNull
    static Optional<Language> calculateInitialLanguage(@NotNull PropertiesComponent props) {
        Language initialLanguage;
        String languageValue = props.getValue(PROPERTIES_NPW_LANGUAGE_KEY);
        if (languageValue == null) {
            boolean selectedOldUseKotlin = props.getBoolean(PROPERTIES_KOTLIN_SUPPORT_KEY);
            boolean isFirstUsage = !props.isValueSet(PROPERTIES_ANDROID_PACKAGE_KEY);
            initialLanguage = selectedOldUseKotlin || isFirstUsage ? Language.KOTLIN : Language.JAVA;
            props.setValue(PROPERTIES_NPW_LANGUAGE_KEY, initialLanguage.getName());
            props.unsetValue(PROPERTIES_KOTLIN_SUPPORT_KEY);
        } else {
            initialLanguage = Language.fromName(languageValue, Language.KOTLIN);
        }
        boolean askedBefore = props.getBoolean(PROPERTIES_NPW_ASKED_LANGUAGE_KEY);
        return initialLanguage == Language.KOTLIN || askedBefore ? Optional.of(initialLanguage) : Optional.empty();
    }

    @NotNull
    private Boolean getInitialUseAndroidxSupport() {
        return (Boolean)StudioFlags.NELE_USE_ANDROIDX_DEFAULT.get() != false && this.isAndroidxAvailable();
    }

    public void onWizardFinished(@NotNull ModelWizard.WizardResult wizardResult) {
        if (wizardResult == ModelWizard.WizardResult.FINISHED) {
            PropertiesComponent props = PropertiesComponent.getInstance();
            props.setValue(PROPERTIES_CPP_SUPPORT_KEY, ((Boolean)this.myEnableCppSupport.get()).booleanValue());
            props.setValue(PROPERTIES_NPW_LANGUAGE_KEY, ((Language)((Object)this.myLanguage.getValue())).getName());
            props.setValue(PROPERTIES_NPW_ASKED_LANGUAGE_KEY, true);
        }
    }

    @NotNull
    public static String toPackagePart(@NotNull String s) {
        String name = DISALLOWED_IN_DOMAIN.matcher(s = s.replace('-', '_')).replaceAll("").toLowerCase(Locale.US);
        if (!name.isEmpty() && AndroidUtils.isReservedKeyword(name) != null) {
            name = StringUtil.fixVariableNameDerivedFromPropertyName((String)name).toLowerCase(Locale.US);
        }
        return name;
    }

    @NotNull
    public static String sanitizeApplicationName(@NotNull String s) {
        return DISALLOWED_IN_DOMAIN.matcher(s).replaceAll("");
    }

    @Override
    protected void handleFinished() {
        String projectLocation = (String)this.projectLocation().get();
        String projectName = (String)this.applicationName().get();
        boolean couldEnsureLocationExists = (Boolean)WriteCommandAction.runWriteCommandAction(null, () -> {
            try {
                if (VfsUtil.createDirectoryIfMissing((String)projectLocation) != null && FileOpUtils.create().canWrite(new File(projectLocation))) {
                    return true;
                }
            }
            catch (Exception e) {
                NewProjectModel.getLogger().error(String.format("Exception thrown when creating target project location: %1$s", projectLocation), (Throwable)e);
            }
            return false;
        });
        if (couldEnsureLocationExists) {
            Project project = ProjectManager.getInstance().createProject(projectName, projectLocation);
            assert (project != null);
            this.project().setValue(project);
            this.myMultiTemplateRenderer.setProject(project);
        } else {
            String msg = "Could not ensure the target project location exists and is accessible:\n\n%1$s\n\nPlease try to specify another path.";
            Messages.showErrorDialog((String)String.format(msg, projectLocation), (String)"Error Creating Project");
        }
        this.myMultiTemplateRenderer.requestRender(new ProjectTemplateRenderer());
    }

    private static String getOfflineReposString() {
        return EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths().stream().map(f -> FilenameUtils.normalize((String)f.toString())).collect(Collectors.joining(","));
    }

    private class ProjectTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        private ProjectTemplateRenderer() {
        }

        @Override
        public boolean doDryRun() {
            if (NewProjectModel.this.project().getValueOrNull() == null) {
                return false;
            }
            this.performCreateProject(true);
            return true;
        }

        @Override
        public void render() {
            this.performCreateProject(false);
            try {
                File projectRoot = VfsUtilCore.virtualToIoFile((VirtualFile)NewProjectModel.this.project().getValue().getBaseDir());
                AndroidGradleModuleUtils.setGradleWrapperExecutable(projectRoot);
            }
            catch (IOException e) {
                NewProjectModel.getLogger().warn("Failed to update Gradle wrapper permissions", (Throwable)e);
            }
            ApplicationManager.getApplication().invokeLater(this::performGradleImport);
        }

        private void performCreateProject(boolean dryRun) {
            Project project = NewProjectModel.this.project().getValue();
            NewProjectModel.this.myTemplateValues.put("includeCppSupport", NewProjectModel.this.myEnableCppSupport.get());
            NewProjectModel.this.myTemplateValues.put("cppFlags", NewProjectModel.this.myCppFlags.get());
            NewProjectModel.this.myTemplateValues.put("topOut", project.getBasePath());
            NewProjectModel.this.myTemplateValues.put("includeKotlinSupport", NewProjectModel.this.myLanguage.getValue() == Language.KOTLIN);
            if (((Boolean)StudioFlags.NPW_OFFLINE_REPO_CHECKBOX.get()).booleanValue()) {
                String offlineReposString = NewProjectModel.getOfflineReposString();
                NewProjectModel.this.myTemplateValues.put("offlineRepoPath", offlineReposString);
                if (((Boolean)NewProjectModel.this.myUseOfflineRepo.get()).booleanValue()) {
                    NewProjectModel.this.myTemplateValues.put("useOfflineRepo", true);
                }
            }
            NewProjectModel.this.myTemplateValues.put("addAndroidXSupport", NewProjectModel.this.myUseAndroidx.get());
            HashMap params = Maps.newHashMap((Map)NewProjectModel.this.myTemplateValues);
            for (NewModuleModel newModuleModel : NewProjectModel.this.getNewModuleModels()) {
                params.putAll(newModuleModel.getTemplateValues());
                Map<String, Object> renderTemplateValues = newModuleModel.getRenderTemplateValues().getValue();
                renderTemplateValues.putAll(NewProjectModel.this.myTemplateValues);
                newModuleModel.getTemplateValues().putAll(NewProjectModel.this.myTemplateValues);
            }
            Template projectTemplate = Template.createFromName("gradle-projects", "NewAndroidProject");
            RenderingContext context = RenderingContext.Builder.newContext(projectTemplate, project).withCommandName("New Project").withDryRun(dryRun).withShowErrors(true).withParams(params).build();
            projectTemplate.render(context, dryRun);
        }

        private void performGradleImport() {
            Sdk jdk;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
            File rootLocation = new File((String)NewProjectModel.this.projectLocation().get());
            File wrapperPropertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(rootLocation);
            try {
                File gradleDistFile = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionFile("5.4.1");
                if (gradleDistFile == null) {
                    GradleWrapper.get(wrapperPropertiesFilePath).updateDistributionUrl("5.4.1");
                } else {
                    GradleWrapper.get(wrapperPropertiesFilePath).updateDistributionUrl(gradleDistFile);
                }
            }
            catch (IOException e) {
                NewProjectModel.getLogger().warn("Failed to update Gradle wrapper file", (Throwable)e);
            }
            if (!IdeInfo.getInstance().isAndroidStudio() && (jdk = IdeSdks.getInstance().getJdk()) != null) {
                ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)NewProjectModel.this.project().getValue()).setProjectSdk(jdk));
            }
            try {
                LanguageLevel initialLanguageLevel = null;
                AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
                if (sdkData != null) {
                    JavaSdkVersion version2;
                    JavaSdk jdk2 = JavaSdk.getInstance();
                    Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk2);
                    if (sdk != null && (version2 = jdk2.getVersion(sdk)) != null && version2.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                        initialLanguageLevel = LanguageLevel.JDK_1_7;
                    }
                }
                GradleProjectImporter.Request request = new GradleProjectImporter.Request(NewProjectModel.this.project().getValue());
                request.isNewProject = true;
                request.javaLanguageLevel = initialLanguageLevel;
                Project newProject = projectImporter.importProjectNoSync((String)NewProjectModel.this.applicationName().get(), rootLocation, request);
                GradleProjectInfo.getInstance(newProject).setSkipStartupActivity(true);
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(newProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_NEW);
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)AndroidBundle.message("android.wizard.project.create.error", new Object[0]));
                NewProjectModel.getLogger().error((Throwable)e);
            }
        }
    }
}

