/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.tools.idea.gradle.npw.project.GradleAndroidModuleTemplate;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.CircularParameterDependencyException;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.ParameterValueResolver;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class NewProjectModuleModel
extends WizardModel {
    public static final String EMPTY_ACTIVITY = "Empty Activity";
    public static final String ANDROID_MODULE = "Android Module";
    @NotNull
    private final NewProjectModel myProjectModel;
    @NotNull
    private final NewModuleModel myNewModuleModel;
    @NotNull
    private final RenderTemplateModel myExtraRenderTemplateModel;
    @NotNull
    private final OptionalProperty<AndroidVersionsInfo.VersionItem> myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
    @NotNull
    private final ObjectProperty<FormFactor> myFormFactor = new ObjectValueProperty<FormFactor>(FormFactor.MOBILE);
    @NotNull
    private final OptionalProperty<TemplateHandle> myRenderTemplateHandle = new OptionalValueProperty<TemplateHandle>();
    @NotNull
    private final BoolProperty myHasCompanionApp = new BoolValueProperty();
    @NotNull
    private final BoolProperty myDynamicInstantApp = new BoolValueProperty();

    public NewProjectModuleModel(@NotNull NewProjectModel projectModel) {
        this.myProjectModel = projectModel;
        this.myNewModuleModel = new NewModuleModel(this.myProjectModel, new File(""));
        this.myExtraRenderTemplateModel = new RenderTemplateModel(this.myNewModuleModel, null, GradleAndroidModuleTemplate.createDummyTemplate(), AndroidBundle.message("android.wizard.config.activity.title", new Object[0]));
    }

    @NotNull
    public BoolProperty instantApp() {
        return this.myNewModuleModel.instantApp();
    }

    @NotNull
    public BoolProperty dynamicInstantApp() {
        return this.myDynamicInstantApp;
    }

    @NotNull
    public OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo() {
        return this.myAndroidSdkInfo;
    }

    @NotNull
    public OptionalProperty<File> moduleTemplateFile() {
        return this.myNewModuleModel.templateFile();
    }

    @NotNull
    public OptionalProperty<TemplateHandle> renderTemplateHandle() {
        return this.myRenderTemplateHandle;
    }

    @NotNull
    public BoolProperty hasCompanionApp() {
        return this.myHasCompanionApp;
    }

    @NotNull
    public ObjectProperty<FormFactor> formFactor() {
        return this.myFormFactor;
    }

    @NotNull
    public RenderTemplateModel getExtraRenderTemplateModel() {
        return this.myExtraRenderTemplateModel;
    }

    @Override
    protected void handleFinished() {
        boolean noActivitySelected;
        this.myProjectModel.getNewModuleModels().clear();
        Project project = this.myNewModuleModel.getProject().getValueOrNull();
        String projectLocation = (String)this.myProjectModel.projectLocation().get();
        boolean hasCompanionApp = (Boolean)this.myHasCompanionApp.get();
        this.initMainModule();
        Map<String, Object> projectTemplateValues = this.myProjectModel.getTemplateValues();
        NewProjectModuleModel.addModuleToProject(this.myNewModuleModel, (FormFactor)((Object)this.myFormFactor.get()), this.myProjectModel, projectTemplateValues);
        int formFactorsCount = 1;
        if (hasCompanionApp) {
            ++formFactorsCount;
            NewModuleModel companionModuleModel = NewProjectModuleModel.createCompanionModuleModel(this.myProjectModel);
            RenderTemplateModel companionRenderModel = NewProjectModuleModel.createCompanionRenderModel(projectLocation, companionModuleModel);
            NewProjectModuleModel.addModuleToProject(companionModuleModel, FormFactor.MOBILE, this.myProjectModel, projectTemplateValues);
            companionRenderModel.androidSdkInfo().setValue(this.androidSdkInfo().getValue());
            companionModuleModel.getRenderTemplateValues().setValue(companionRenderModel.getTemplateValues());
            companionModuleModel.handleFinished();
            companionRenderModel.handleFinished();
        }
        projectTemplateValues.put("NumberOfEnabledFormFactors", formFactorsCount);
        RenderTemplateModel newRenderTemplateModel = this.createMainRenderModel(projectLocation);
        this.myNewModuleModel.getRenderTemplateValues().setValue(newRenderTemplateModel.getTemplateValues());
        boolean bl = noActivitySelected = newRenderTemplateModel.getTemplateHandle() == null;
        if (noActivitySelected) {
            this.myNewModuleModel.setDefaultRenderTemplateValues(newRenderTemplateModel, project);
        } else if (newRenderTemplateModel != this.myExtraRenderTemplateModel) {
            NewProjectModuleModel.addRenderDefaultTemplateValues(newRenderTemplateModel);
        }
        new TemplateValueInjector(this.myNewModuleModel.getTemplateValues()).setProjectDefaults(project, (String)this.myNewModuleModel.applicationName().get());
        projectTemplateValues.put("isDynamicInstantApp", this.myDynamicInstantApp.get());
        this.myNewModuleModel.handleFinished();
        if (newRenderTemplateModel != this.myExtraRenderTemplateModel) {
            if (noActivitySelected) {
                newRenderTemplateModel.handleSkipped();
            } else {
                newRenderTemplateModel.handleFinished();
            }
        }
    }

    private void initMainModule() {
        String moduleName;
        if (((Boolean)this.myHasCompanionApp.get()).booleanValue()) {
            moduleName = NewProjectModuleModel.getModuleName((FormFactor)((Object)this.myFormFactor.get()));
        } else if (((Boolean)this.myNewModuleModel.instantApp().get()).booleanValue()) {
            moduleName = (String)this.myNewModuleModel.splitName().get();
            this.myNewModuleModel.packageName().set(this.myNewModuleModel.computedFeatureModulePackageName().get());
        } else {
            moduleName = "app";
        }
        this.myNewModuleModel.moduleName().set(moduleName);
    }

    @NotNull
    private RenderTemplateModel createMainRenderModel(String projectLocation) {
        RenderTemplateModel newRenderTemplateModel;
        String moduleName = (String)this.myNewModuleModel.moduleName().get();
        if (((Boolean)this.myProjectModel.enableCppSupport().get()).booleanValue()) {
            newRenderTemplateModel = NewProjectModuleModel.createCompanionRenderModel(projectLocation, this.myNewModuleModel);
        } else if (this.myExtraRenderTemplateModel.getTemplateHandle() == null) {
            newRenderTemplateModel = new RenderTemplateModel(this.myNewModuleModel, null, GradleAndroidModuleTemplate.createDefaultTemplateAt(projectLocation, moduleName), "");
            newRenderTemplateModel.setTemplateHandle(this.renderTemplateHandle().getValueOrNull());
        } else {
            newRenderTemplateModel = this.myExtraRenderTemplateModel;
            this.myExtraRenderTemplateModel.getTemplate().set(GradleAndroidModuleTemplate.createDefaultTemplateAt(projectLocation, moduleName));
        }
        newRenderTemplateModel.androidSdkInfo().setValue(this.androidSdkInfo().getValue());
        return newRenderTemplateModel;
    }

    private static void addModuleToProject(@NotNull NewModuleModel moduleModel, @NotNull FormFactor formFactor, @NotNull NewProjectModel projectModel, @NotNull Map<String, Object> projectTemplateValues) {
        projectTemplateValues.put(formFactor.id + "included", true);
        projectTemplateValues.put(formFactor.id + "projectName", moduleModel.moduleName().get());
        projectModel.getNewModuleModels().add(moduleModel);
    }

    @NotNull
    private static NewModuleModel createCompanionModuleModel(@NotNull NewProjectModel projectModel) {
        File moduleTemplateFile = TemplateManager.getInstance().getTemplateFile("Application", ANDROID_MODULE);
        NewModuleModel companionModuleModel = new NewModuleModel(projectModel, moduleTemplateFile);
        companionModuleModel.moduleName().set(NewProjectModuleModel.getModuleName(FormFactor.MOBILE));
        new TemplateValueInjector(companionModuleModel.getTemplateValues()).setProjectDefaults(projectModel.project().getValueOrNull(), (String)companionModuleModel.applicationName().get());
        return companionModuleModel;
    }

    @NotNull
    private static RenderTemplateModel createCompanionRenderModel(@NotNull String projectLocation, @NotNull NewModuleModel moduleModel) {
        NamedModuleTemplate namedModuleTemplate = GradleAndroidModuleTemplate.createDefaultTemplateAt(projectLocation, (String)moduleModel.moduleName().get());
        File renderTemplateFile = TemplateManager.getInstance().getTemplateFile("Activity", EMPTY_ACTIVITY);
        TemplateHandle renderTemplateHandle = new TemplateHandle(renderTemplateFile);
        RenderTemplateModel companionRenderModel = new RenderTemplateModel(moduleModel, renderTemplateHandle, namedModuleTemplate, "");
        NewProjectModuleModel.addRenderDefaultTemplateValues(companionRenderModel);
        return companionRenderModel;
    }

    @NotNull
    private static String getModuleName(@NotNull FormFactor formFactor) {
        if (formFactor.baseFormFactor != null) {
            formFactor = formFactor.baseFormFactor;
        }
        return formFactor.id.replaceAll("\\s", "_").toLowerCase(Locale.US);
    }

    private static void addRenderDefaultTemplateValues(RenderTemplateModel renderTemplateModel) {
        Map<String, Object> templateValues = renderTemplateModel.getTemplateValues();
        TemplateMetadata templateMetadata = renderTemplateModel.getTemplateHandle().getMetadata();
        HashMap userValues = Maps.newHashMap();
        HashMap additionalValues = Maps.newHashMap();
        String packageName = (String)renderTemplateModel.packageName().get();
        boolean isInstantApp = (Boolean)renderTemplateModel.instantApp().get();
        new TemplateValueInjector(additionalValues).addTemplateAdditionalValues(packageName, isInstantApp, renderTemplateModel.getTemplate());
        additionalValues.put("packageName", renderTemplateModel.packageName().get());
        try {
            Collection<Parameter> renderParameters = templateMetadata.getParameters();
            Map<Parameter, Object> parameterValues = ParameterValueResolver.resolve(renderParameters, userValues, additionalValues);
            parameterValues.forEach((parameter, value2) -> templateValues.put(parameter.id, value2));
        }
        catch (CircularParameterDependencyException e) {
            NewProjectModuleModel.getLog().error("Circular dependency between parameters in template %1$s", (Throwable)e, new String[]{templateMetadata.getTitle()});
        }
    }

    private static Logger getLog() {
        return Logger.getInstance(NewProjectModuleModel.class);
    }
}

